/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class ArmorEffectData {
    private final ArmorEffect[] effect = new ArmorEffect[3];
    private int appendingIndex;

    public void triggerEvent(class_1799 stack, Consumer<ArmorEffect> consumer) {
        if (this.effect[0] == null) {
            ArmorEffect defaultEffect = DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::getArmorEffect).orElse(null);
            if (defaultEffect != null && defaultEffect.canBeAppliedTo(stack)) {
                consumer.accept(defaultEffect);
            }
        } else {
            for (ArmorEffect eff : this.effect) {
                if (eff == null) continue;
                consumer.accept(eff);
            }
        }
    }

    public void setArmorEffects(ArmorEffect first, ArmorEffect second, ArmorEffect third) {
        this.effect[0] = first;
        this.effect[1] = second;
        this.effect[2] = third;
    }

    public void addArmorEffects(ArmorEffect effect) {
        if (effect != null) {
            this.effect[this.appendingIndex] = effect;
            this.appendingIndex = (this.appendingIndex + 1) % 3;
        }
    }

    public void readFromNBT(class_2487 nbt) {
        if (nbt.method_10545("FirstEffect")) {
            this.effect[0] = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(new class_2960(nbt.method_10558("FirstEffect"))));
        }
        if (nbt.method_10545("SecondEffect")) {
            this.effect[1] = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(new class_2960(nbt.method_10558("SecondEffect"))));
        }
        if (nbt.method_10545("ThirdEffect")) {
            this.effect[2] = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(new class_2960(nbt.method_10558("ThirdEffect"))));
        }
        this.appendingIndex = nbt.method_10550("Index");
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        if (this.effect[0] != null) {
            nbt.method_10582("FirstEffect", this.effect[0].getRegistryName().toString());
        }
        if (this.effect[1] != null) {
            nbt.method_10582("SecondEffect", this.effect[1].getRegistryName().toString());
        }
        if (this.effect[2] != null) {
            nbt.method_10582("ThirdEffect", this.effect[2].getRegistryName().toString());
        }
        nbt.method_10569("Index", this.appendingIndex);
        return nbt;
    }
}

