/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment;

import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityCustomFishingHook;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.common.network.S2CEntityDataSync;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.HashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class EntityData {
    private boolean sleeping;
    private boolean isSilent;
    private boolean paralysis;
    private boolean stunned;
    private boolean noAIStunned;
    private boolean cold;
    private boolean poison;
    private boolean invis;
    private boolean orthoView;
    private int disabledState;
    public EntityCustomFishingHook fishingHook;
    private class_1799 main;
    private class_1799 off;
    public float sleepYRot;
    private final HashSet<class_2960> armorFlags = new HashSet();

    public static SleepState getSleepStateFrom(class_1309 entity) {
        return Platform.INSTANCE.getEntityData(entity).map(e -> e.getSleepState(entity)).orElse(SleepState.NONE);
    }

    public SleepState getSleepState(class_1309 entity) {
        SleepingEntity sleeping;
        if (!this.isSleeping()) {
            return SleepState.NONE;
        }
        if (entity instanceof SleepingEntity && (sleeping = (SleepingEntity)entity).hasSleepingAnimation()) {
            return SleepState.CUSTOM;
        }
        return SleepState.VANILLA;
    }

    public void setSleeping(class_1309 entity, boolean flag) {
        this.sleeping = flag;
        this.updateAiState(entity, flag);
        this.setOrthoView(entity, flag);
        this.sleepYRot = entity.field_6283;
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.SLEEP, this.sleeping), (class_1297)entity);
        } else {
            ClientHandlers.grabMouse(entity, this.sleeping);
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public void setPoison(class_1309 entity, boolean flag) {
        this.poison = flag;
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.POISON, this.poison), (class_1297)entity);
        }
    }

    public boolean isPoisoned() {
        return this.poison;
    }

    public void setCold(class_1309 entity, boolean flag) {
        this.cold = flag;
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.COLD, this.cold), (class_1297)entity);
        }
    }

    public boolean hasCold() {
        return this.cold;
    }

    public void setParalysis(class_1309 entity, boolean flag) {
        this.paralysis = flag;
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.PARALYSIS, this.paralysis), (class_1297)entity);
        }
    }

    public boolean isParalysed() {
        return this.paralysis;
    }

    public void setStunned(class_1309 entity, boolean flag) {
        this.stunned = flag;
        this.updateAiState(entity, flag);
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.STUN, this.stunned), (class_1297)entity);
        }
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public void setInvis(class_1309 entity, boolean flag) {
        this.invis = flag;
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.INVIS, this.invis), (class_1297)entity);
        }
    }

    public boolean isInvis() {
        return this.invis;
    }

    public void setOrthoView(class_1309 entity, boolean flag) {
        this.orthoView = flag;
        if (!entity.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CEntityDataSync(entity.method_5628(), S2CEntityDataSync.Type.ORTHOVIEW, this.orthoView), (class_1297)entity);
        } else {
            ClientHandlers.trySetPerspective(entity, flag);
        }
    }

    public boolean isOrthoView() {
        return this.orthoView;
    }

    public class_1799 getGloveOffHand(class_1799 stack) {
        if (stack != null && this.main != stack) {
            this.main = stack;
            this.off = this.main.method_7972();
        }
        return this.off;
    }

    public void addArmorFlag(class_2960 key) {
        this.armorFlags.add(key);
    }

    public void removeArmorFlag(class_2960 key) {
        this.armorFlags.remove(key);
    }

    public boolean hasArmorFlag(class_2960 key) {
        return this.armorFlags.contains(key);
    }

    private void updateAiState(class_1309 entity, boolean increase) {
        int pre = this.disabledState++;
        if (!increase) {
            --this.disabledState;
        }
        if (pre == 0 && increase) {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                this.noAIStunned = mob.method_5987();
                if (!this.noAIStunned) {
                    mob.method_5977(true);
                }
            }
            this.isSilent = entity.method_5701();
            if (!this.isSilent) {
                entity.method_5803(true);
            }
        } else if (pre == 1 && !increase) {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                if (!this.noAIStunned) {
                    mob.method_5977(false);
                }
            }
            if (!this.isSilent) {
                entity.method_5803(false);
            }
        }
    }

    public static enum SleepState {
        NONE,
        VANILLA,
        CUSTOM;

    }
}

