/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class DailyPlayerUpdater {
    private int lastUpdateDay = -1;
    private boolean gaveMonsterItem;
    private boolean ateFood;
    private int bathCounter;
    private final Random random = new Random();
    private int dailyRandomSeed;
    private final PlayerData data;

    public DailyPlayerUpdater(PlayerData data) {
        this.data = data;
    }

    public void tick(class_3222 player) {
        int day;
        if (this.dailyRandomSeed == 0) {
            this.dailyRandomSeed = player.method_6051().nextInt();
        }
        if (this.lastUpdateDay != (day = WorldUtils.day(player.field_6002))) {
            this.lastUpdateDay = day;
            this.data.getShippingInv().shipItems(player);
            this.data.refreshShop((class_1657)player);
            this.gaveMonsterItem = false;
            this.ateFood = false;
            this.bathCounter = 0;
            this.dailyRandomSeed = player.method_6051().nextInt();
        }
    }

    public void setLastUpdateDay(int lastUpdateDay) {
        this.lastUpdateDay = lastUpdateDay;
    }

    public void onGiveMonsterItem(class_3222 player) {
        if (!this.gaveMonsterItem) {
            this.gaveMonsterItem = true;
            LevelCalc.levelSkill(player, this.data, EnumSkills.TAMING, 4.0f);
        }
    }

    public void onFoodEaten(class_3222 player) {
        if (!this.ateFood) {
            this.ateFood = true;
            LevelCalc.levelSkill(player, this.data, EnumSkills.EATING, 50.0f);
        }
    }

    public int getBathCounter() {
        return this.bathCounter;
    }

    public void increaseBathCounter() {
        ++this.bathCounter;
    }

    public int getDailyRandomSeed() {
        return this.dailyRandomSeed;
    }

    public Random getDailyRandom() {
        this.random.setSeed(this.getDailyRandomSeed());
        return this.random;
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10569("LastUpdateDay", this.lastUpdateDay);
        compound.method_10556("GaveMonsterItem", this.gaveMonsterItem);
        compound.method_10556("AteFood", this.ateFood);
        compound.method_10569("BathCounter", this.bathCounter);
        compound.method_10569("DailyRandomSeed", this.dailyRandomSeed);
        return compound;
    }

    public void read(class_2487 compound) {
        this.lastUpdateDay = compound.method_10550("LastUpdateDay");
        this.gaveMonsterItem = compound.method_10577("GaveMonsterItem");
        this.ateFood = compound.method_10577("AteFood");
        this.bathCounter = compound.method_10550("BathCounter");
        this.dailyRandomSeed = compound.method_10550("DailyRandomSeed");
    }
}

