/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.api.datapack.SkillProperties;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.DailyPlayerUpdater;
import io.github.flemmli97.runecraftory.common.attachment.player.EntitySelector;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.attachment.player.Party;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.RecipeKeeper;
import io.github.flemmli97.runecraftory.common.attachment.player.WalkingTracker;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShippingBin;
import io.github.flemmli97.runecraftory.common.inventory.InventorySpells;
import io.github.flemmli97.runecraftory.common.items.tools.ItemStatIncrease;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.network.S2CFoodPkt;
import io.github.flemmli97.runecraftory.common.network.S2CItemStatBoost;
import io.github.flemmli97.runecraftory.common.network.S2CLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CMaxRunePoints;
import io.github.flemmli97.runecraftory.common.network.S2CMoney;
import io.github.flemmli97.runecraftory.common.network.S2CPlayerStats;
import io.github.flemmli97.runecraftory.common.network.S2CRunePoints;
import io.github.flemmli97.runecraftory.common.network.S2CSkillLevelPkt;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_5131;
import net.minecraft.class_5134;

public class PlayerData {
    public boolean starting;
    public boolean unlockedRecipes;
    private int money = GeneralConfig.startingMoney;
    private float runePointsMax = GeneralConfig.startingRp;
    private int runePoints = (int)this.runePointsMax;
    private float str = GeneralConfig.startingStr;
    private float vit = GeneralConfig.startingVit;
    private float intel = GeneralConfig.startingIntel;
    private float strAdd;
    private float vitAdd;
    private float intAdd;
    private final LevelExpPair level = new LevelExpPair();
    private final EnumMap<EnumSkills, LevelExpPair> skillLevels = new EnumMap(EnumSkills.class);
    private final InventorySpells spells = new InventorySpells();
    private final DailyPlayerUpdater updater = new DailyPlayerUpdater(this);
    private int rpStillRegen;
    private final RecipeKeeper keeper = new RecipeKeeper();
    private final Map<class_1792, ShippedItemData> shippedItems = new HashMap<class_1792, ShippedItemData>();
    private final Map<NPCJob, class_2371<class_1799>> shopItems = new HashMap<NPCJob, class_2371<class_1799>>();
    private final InventoryShippingBin shipping = new InventoryShippingBin();
    private class_1792 lastFoodBuff;
    private Map<class_1320, Double> foodBuffs = new HashMap<class_1320, Double>();
    private int foodDuration;
    private final PlayerWeaponHandler weaponHandler;
    private final WalkingTracker walkingTracker = new WalkingTracker();
    public final EntitySelector entitySelector = new EntitySelector();
    public final EntityStatsTracker entityStatsTracker = new EntityStatsTracker();
    public final Party party = new Party();
    private boolean touchedWater;
    private int craftingSeed;
    private int boughtBarns;
    private class_2338 blockBreakPosForMsg;
    private int breakTick;
    private int mobLevelIncrease;
    private NPCData.Gender gender;

    public PlayerData(class_1657 player) {
        for (EnumSkills skill : EnumSkills.values()) {
            this.skillLevels.put(skill, new LevelExpPair());
        }
        this.weaponHandler = new PlayerWeaponHandler(player);
    }

    public void setMaxHealth(class_1657 player, float amount, boolean asBaseHealth) {
        class_1324 health = player.method_5996(class_5134.field_23716);
        class_1322 modifier = health.method_6199(LibConstants.MAX_HEALTH_MODIFIER);
        double val = (double)amount - (asBaseHealth ? health.method_6201() : health.method_6194());
        if (modifier != null && !asBaseHealth) {
            val += modifier.method_6186();
        }
        health.method_6200(LibConstants.MAX_HEALTH_MODIFIER);
        health.method_26837(new class_1322(LibConstants.MAX_HEALTH_MODIFIER, "rf.hpModifier", val, class_1322.class_1323.field_6328));
    }

    private void setFoodHealthBonus(class_1657 player, double amount) {
        class_1324 health = player.method_5996(class_5134.field_23716);
        health.method_6200(LibConstants.FOOD_MODIFIER);
        health.method_26837(new class_1322(LibConstants.FOOD_MODIFIER, "rf.food.hpModifier", amount, class_1322.class_1323.field_6328));
    }

    public int getRunePoints() {
        return this.runePoints;
    }

    public int getMaxRunePoints() {
        return (int)((double)this.runePointsMax + this.foodBuffs.getOrDefault(ModAttributes.RPINCREASE.get(), 0.0));
    }

    public float getMaxRunePointsRaw() {
        return this.runePointsMax;
    }

    public boolean decreaseRunePoints(class_1657 player, int amount, boolean damage) {
        if (!GeneralConfig.useRp && !player.field_6002.field_9236) {
            return true;
        }
        if (!player.method_7337()) {
            if (EntityUtils.isExhaust((class_1309)player)) {
                amount *= 2;
            }
            if (this.runePoints >= amount) {
                this.runePoints -= amount;
            } else if (damage) {
                int diff = amount - this.runePoints;
                this.runePoints = 0;
                if (!player.field_6002.field_9236) {
                    int invul = player.field_6008;
                    player.field_6008 = 10;
                    boolean res = player.method_5643(CustomDamage.EXHAUST, Math.min(player.method_6063() * 0.25f, (float)(diff * 2)));
                    player.field_6008 = res ? 10 : invul;
                }
            } else {
                return false;
            }
            this.rpStillRegen = 200;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CRunePoints(this), serverPlayer);
            }
            return true;
        }
        return true;
    }

    public void refreshRunePoints(class_1657 player, int amount) {
        this.runePoints = class_3532.method_15340((int)(this.runePoints + amount), (int)0, (int)this.getMaxRunePoints());
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CRunePoints(this), serverPlayer);
        }
    }

    public void setRunePoints(class_1657 player, int amount) {
        this.runePoints = amount;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CRunePoints(this), serverPlayer);
        }
    }

    public void setMaxRunePoints(class_1657 player, float amount) {
        this.runePointsMax = amount;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CMaxRunePoints(this), serverPlayer);
        }
    }

    public int getMoney() {
        return this.money;
    }

    public boolean useMoney(class_1657 player, int amount) {
        if (this.money >= amount) {
            this.money -= amount;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CMoney(this), serverPlayer);
            }
            return true;
        }
        return false;
    }

    public void setMoney(class_1657 player, int amount) {
        this.money = amount;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ModCriteria.MONEY_TRIGGER.trigger(serverPlayer);
            Platform.INSTANCE.sendToClient(new S2CMoney(this), serverPlayer);
        }
    }

    public float getStr() {
        return this.str;
    }

    public void setStr(class_1657 player, float amount) {
        this.str = amount;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CPlayerStats(this), serverPlayer);
        }
    }

    public float getVit() {
        return this.vit;
    }

    public void setVit(class_1657 player, float amount) {
        this.vit = amount;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CPlayerStats(this), serverPlayer);
        }
    }

    public float getIntel() {
        return this.intel;
    }

    public void setIntel(class_1657 player, float amount) {
        this.intel = amount;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CPlayerStats(this), serverPlayer);
        }
    }

    public LevelExpPair getPlayerLevel() {
        return this.level;
    }

    public void setPlayerLevel(class_1657 player, int level, float xpAmount, boolean recalc) {
        this.level.setLevel(class_3532.method_15340((int)level, (int)1, (int)GeneralConfig.maxLevel), LevelCalc::xpAmountForLevelUp);
        this.level.setXp(class_3532.method_15363((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForLevelUp(level)));
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (recalc) {
                this.recalculateStats(serverPlayer, true);
            } else {
                Platform.INSTANCE.sendToClient(new S2CLevelPkt(this), serverPlayer);
            }
        }
    }

    public void addXp(class_1657 player, float amount) {
        if (this.level.getLevel() >= GeneralConfig.maxLevel) {
            return;
        }
        boolean levelUp = this.level.addXP(amount, GeneralConfig.maxLevel, LevelCalc::xpAmountForLevelUp, () -> this.onLevelUp(player));
        if (levelUp) {
            player.field_6002.method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 0.5f);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (levelUp) {
                ModCriteria.LEVEL_TRIGGER.trigger(serverPlayer);
            }
            Platform.INSTANCE.sendToClient(new S2CLevelPkt(this), serverPlayer);
        }
    }

    private void onLevelUp(class_1657 player) {
        float health = player.method_6063();
        this.updateHealth(player);
        player.method_6025(player.method_6063() - health);
        this.runePointsMax += GeneralConfig.rpPerLevel;
        this.runePoints = Math.min(this.runePoints + (int)GeneralConfig.rpPerLevel, this.runePoints);
        this.str += GeneralConfig.strPerLevel;
        this.vit += GeneralConfig.vitPerLevel;
        this.intel += GeneralConfig.intPerLevel;
    }

    public void recalculateStats(class_3222 player, boolean regen) {
        int lvl = this.level.getLevel() - 1;
        this.updateHealth((class_1657)player);
        this.runePointsMax = GeneralConfig.rpPerLevel * (float)lvl + (float)GeneralConfig.startingRp + (float)((int)this.skillValLevelFunc((skillLvl, prop) -> Float.valueOf((float)Math.min(100, skillLvl) * prop.rpIncrease())));
        if (regen) {
            player.method_6033(player.method_6063());
            this.runePoints = (int)this.runePointsMax;
        }
        this.str = GeneralConfig.strPerLevel * (float)lvl + (float)GeneralConfig.startingStr + (float)this.skillVal(SkillProperties::strIncrease);
        this.intel = GeneralConfig.intPerLevel * (float)lvl + (float)GeneralConfig.startingIntel + (float)this.skillVal(SkillProperties::intelIncrease);
        this.vit = GeneralConfig.vitPerLevel * (float)lvl + (float)GeneralConfig.startingVit + (float)this.skillVal(SkillProperties::vitIncrease);
        Platform.INSTANCE.sendToClient(new S2CLevelPkt(this), player);
    }

    private double skillVal(Function<SkillProperties, Number> func) {
        return this.skillLevels.entrySet().stream().mapToDouble(e -> (double)(((LevelExpPair)e.getValue()).getLevel() - 1) * ((Number)func.apply(DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor((EnumSkills)((Object)((Object)e.getKey()))))).doubleValue()).sum();
    }

    private double skillValLevelFunc(BiFunction<Integer, SkillProperties, Number> func) {
        return this.skillLevels.entrySet().stream().mapToDouble(e -> ((Number)func.apply(((LevelExpPair)e.getValue()).getLevel() - 1, DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor((EnumSkills)((Object)((Object)e.getKey()))))).doubleValue()).sum();
    }

    public LevelExpPair getSkillLevel(EnumSkills skill) {
        return this.skillLevels.get((Object)skill);
    }

    public void setSkillLevel(EnumSkills skill, class_1657 player, int level, float xpAmount, boolean recalc) {
        this.skillLevels.get((Object)skill).setLevel(player.field_6002.field_9236 ? level : class_3532.method_15340((int)level, (int)1, (int)DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()), l -> LevelCalc.xpAmountForSkillLevelUp(skill, l));
        this.skillLevels.get((Object)skill).setXp(player.field_6002.field_9236 ? xpAmount : class_3532.method_15363((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForSkillLevelUp(skill, level)));
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (recalc) {
                this.recalculateStats(serverPlayer, true);
                player.method_6033(player.method_6063());
            }
            Platform.INSTANCE.sendToClient(new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    public void increaseSkill(EnumSkills skill, class_1657 player, float amount) {
        if (this.skillLevels.get((Object)skill).getLevel() >= DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()) {
            return;
        }
        boolean levelUp = this.skillLevels.get((Object)skill).addXP(amount, DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel(), lvl -> LevelCalc.xpAmountForSkillLevelUp(skill, lvl), () -> this.onSkillLevelUp(skill, player));
        if (levelUp) {
            player.field_6002.method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 0.5f);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (levelUp) {
                ModCriteria.SKILL_LEVEL_TRIGGER.trigger(serverPlayer, skill);
            }
            Platform.INSTANCE.sendToClient(new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    private void onSkillLevelUp(EnumSkills skill, class_1657 player) {
        SkillProperties prop = DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill);
        int level = this.skillLevels.get((Object)skill).getLevel();
        float health = player.method_6063();
        this.updateHealth(player);
        player.method_6025(player.method_6063() - health);
        if (level <= 100) {
            this.runePointsMax += prop.rpIncrease();
            this.runePoints = (int)((float)this.runePoints + prop.rpIncrease());
        }
        this.str += prop.strIncrease();
        this.vit += prop.vitIncrease();
        this.intel += prop.intelIncrease();
    }

    private void updateHealth(class_1657 player) {
        this.setMaxHealth(player, (float)GeneralConfig.startingHealth + GeneralConfig.hpPerLevel * LevelCalc.getMultiplierInterval(this.level.getLevel(), 30, 30.0f, 0.5f) + (float)this.skillValLevelFunc((skillLvl, prop) -> {
            int skillHealthMultiplier = 1 + skillLvl / 25;
            return Float.valueOf((float)skillHealthMultiplier * prop.healthIncrease() * (float)skillLvl.intValue());
        }), true);
    }

    public void increaseStatBonus(class_1657 player, ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.strAdd += 1.0f;
                if (!(player instanceof class_3222)) break;
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, false), serverPlayer);
                break;
            }
            case INT: {
                this.intAdd += 1.0f;
                if (!(player instanceof class_3222)) break;
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, false), serverPlayer);
                break;
            }
            case VIT: {
                this.vitAdd += 1.0f;
                if (!(player instanceof class_3222)) break;
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, false), serverPlayer);
                break;
            }
            case HP: {
                class_1324 health = player.method_5996(class_5134.field_23716);
                class_1322 modifier = health.method_6199(LibConstants.MAX_HEALTH_ITEM_INCREASE);
                double val = modifier == null ? 0.0 : modifier.method_6186();
                health.method_6200(LibConstants.MAX_HEALTH_ITEM_INCREASE);
                health.method_26837(new class_1322(LibConstants.MAX_HEALTH_ITEM_INCREASE, "rf.item.hpModifier", val + 10.0, class_1322.class_1323.field_6328));
            }
        }
    }

    public void resetAllStatBoost(class_1657 player, ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.strAdd = 0.0f;
                if (!(player instanceof class_3222)) break;
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, true), serverPlayer);
                break;
            }
            case INT: {
                this.intAdd = 0.0f;
                if (!(player instanceof class_3222)) break;
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, true), serverPlayer);
                break;
            }
            case VIT: {
                this.vitAdd = 0.0f;
                if (!(player instanceof class_3222)) break;
                class_3222 serverPlayer = (class_3222)player;
                Platform.INSTANCE.sendToClient(new S2CItemStatBoost(type, true), serverPlayer);
                break;
            }
            case HP: {
                class_1324 health = player.method_5996(class_5134.field_23716);
                health.method_6200(LibConstants.MAX_HEALTH_ITEM_INCREASE);
            }
        }
    }

    public double getAttributeValue(class_1657 player, class_1320 att) {
        double val = 0.0;
        float vit = this.getVit() + this.vitAdd;
        if (att == class_5134.field_23721) {
            val += (double)(this.getStr() + this.strAdd);
            val += (double)class_1890.method_8218((class_1799)player.method_6047(), (class_1310)class_1310.field_6290);
        }
        if (att == ModAttributes.MAGIC.get()) {
            val += (double)(this.getIntel() + this.intAdd);
        }
        if (att == ModAttributes.DEFENCE.get()) {
            val += (double)vit * 0.5;
        }
        if (att == ModAttributes.MAGIC_DEFENCE.get()) {
            val += (double)vit * 0.5;
        }
        val += this.foodBuffs.getOrDefault(att, 0.0).doubleValue();
        class_5131 atts = player.method_6127();
        return val += atts.method_27306(att) ? atts.method_26852(att) : 0.0;
    }

    public InventorySpells getInv() {
        return this.spells;
    }

    public InventoryShippingBin getShippingInv() {
        return this.shipping;
    }

    public void refreshShop(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            for (NPCJob profession : ModNPCJobs.allJobs()) {
                Collection<ShopItemProperties> datapack = DataPackHandler.INSTANCE.shopItemsManager().get(profession);
                ArrayList shopItems = new ArrayList();
                datapack.forEach(shopProps -> {
                    boolean canAdd;
                    block7: {
                        boolean bl;
                        block6: {
                            if (!shopProps.predicate().method_8914(serverPlayer, (class_1297)serverPlayer)) break block6;
                            switch (shopProps.unlockType()) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case DEFAULT: {
                                    break block6;
                                }
                                case ALWAYS: {
                                    break;
                                }
                                case NEEDS_SHIPPING: {
                                    if (!this.shippedItems.containsKey(shopProps.stack().method_7909())) break block6;
                                }
                            }
                            bl = true;
                            break block7;
                        }
                        bl = canAdd = false;
                    }
                    if (canAdd) {
                        shopItems.add(shopProps.stack().method_7972());
                    }
                });
                class_2371 shop = class_2371.method_10211();
                if (!shopItems.isEmpty()) {
                    for (float chance = 1.5f + (float)shopItems.size() * 0.002f; player.field_6002.field_9229.nextFloat() < chance; chance -= 0.1f) {
                        class_1799 stack = (class_1799)shopItems.remove(player.field_6002.field_9229.nextInt(shopItems.size()));
                        shop.add((Object)stack);
                        if (shopItems.isEmpty() || profession == ModNPCJobs.RANDOM.getSecond() && shop.size() >= 30) break;
                    }
                }
                DataPackHandler.INSTANCE.shopItemsManager().getDefaultItems(profession).forEach(props -> shop.add((Object)props.stack()));
                this.shopItems.put(profession, (class_2371<class_1799>)shop);
            }
        }
    }

    public class_2371<class_1799> getShop(NPCJob shop) {
        class_2371 list = class_2371.method_10211();
        list.addAll((Collection)this.shopItems.getOrDefault(shop, (class_2371<class_1799>)class_2371.method_10213((int)0, (Object)class_1799.field_8037)));
        return list;
    }

    public void addShippingItem(class_1799 stack) {
        int level = ItemNBT.itemLevel(stack);
        this.shippedItems.compute(stack.method_7909(), (k, v) -> v == null ? new ShippedItemData(stack.method_7947(), level) : new ShippedItemData(v.amount + stack.method_7947(), Math.max(v.maxLevel, level)));
    }

    public ShippedItemData shippedItemData(class_1799 stack) {
        return this.shippedItems.get(stack.method_7909());
    }

    public int getShippedTypesAmount() {
        return this.shippedItems.size();
    }

    public RecipeKeeper getRecipeKeeper() {
        return this.keeper;
    }

    public class_1792 lastEatenFood() {
        return this.lastFoodBuff;
    }

    public void applyFoodEffect(class_1657 player, class_1799 stack) {
        FoodProperties food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
        if (food == null) {
            return;
        }
        Pair<Map<class_1320, Double>, Map<class_1320, Double>> foodStats = ItemNBT.foodStats(stack);
        Map gain = (Map)foodStats.getFirst();
        ((Map)foodStats.getSecond()).forEach((att, d) -> {
            float percent = (float)(d * (double)0.01f);
            double mult = 0.0;
            if (att == class_5134.field_23716) {
                mult += (double)(player.method_6063() * percent);
            } else if (att == ModAttributes.RPINCREASE.get()) {
                mult += (double)(this.runePointsMax * percent);
            } else if (att == class_5134.field_23721) {
                mult += (double)(this.str * percent);
            } else if (att == ModAttributes.DEFENCE.get()) {
                mult += (double)this.vit * 0.5 * (double)percent;
            } else if (att == ModAttributes.MAGIC.get()) {
                mult += (double)(this.intel * percent);
            } else if (att == ModAttributes.DEFENCE.get()) {
                mult += (double)this.vit * 0.5 * (double)percent;
            }
            gain.put(att, mult += gain.getOrDefault(att, 0.0).doubleValue());
        });
        if (!gain.isEmpty()) {
            this.removeFoodEffect(player);
            this.foodBuffs = gain;
            if (this.foodBuffs.containsKey(class_5134.field_23716)) {
                this.setFoodHealthBonus(player, this.foodBuffs.get(class_5134.field_23716));
            }
            this.foodDuration = food.duration();
            this.lastFoodBuff = stack.method_7909();
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CFoodPkt(stack), serverPlayer);
        }
    }

    public void removeFoodEffect(class_1657 player) {
        this.foodBuffs = Collections.emptyMap();
        this.foodDuration = -1;
        this.lastFoodBuff = null;
        this.setFoodHealthBonus(player, 0.0);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Platform.INSTANCE.sendToClient(new S2CFoodPkt(null), serverPlayer);
        }
    }

    public Map<class_1320, Double> foodEffects() {
        return this.foodBuffs;
    }

    public int foodBuffDuration() {
        return this.foodDuration;
    }

    public class_2487 foodBuffNBT() {
        class_2487 nbt = new class_2487();
        if (this.lastFoodBuff != null) {
            nbt.method_10582("LastFood", class_2378.field_11142.method_10221((Object)this.lastFoodBuff).toString());
        }
        class_2487 compound3 = new class_2487();
        for (Map.Entry<class_1320, Double> entry : this.foodBuffs.entrySet()) {
            compound3.method_10549(class_2378.field_23781.method_10221((Object)entry.getKey()).toString(), entry.getValue().doubleValue());
        }
        nbt.method_10566("FoodBuffs", (class_2520)compound3);
        nbt.method_10569("FoodBuffDuration", this.foodDuration);
        return nbt;
    }

    public void readFoodBuffFromNBT(class_2487 nbt) {
        this.lastFoodBuff = nbt.method_10545("LastFood") ? (class_1792)class_2378.field_11142.method_10223(new class_2960(nbt.method_10558("LastFood"))) : null;
        this.foodBuffs.clear();
        class_2487 tag = nbt.method_10562("FoodBuffs");
        for (String s : tag.method_10541()) {
            this.foodBuffs.put((class_1320)class_2378.field_23781.method_10223(new class_2960(s)), tag.method_10574(s));
        }
        this.foodDuration = nbt.method_10550("FoodBuffDuration");
    }

    public PlayerWeaponHandler getWeaponHandler() {
        return this.weaponHandler;
    }

    public void tick(class_1657 player) {
        this.weaponHandler.tick();
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.updater.tick(serverPlayer);
            if (serverPlayer.field_6012 % 10 == 0 && this.walkingTracker.tickWalkingTracker(serverPlayer)) {
                this.rpStillRegen = 200;
            }
            if (--this.rpStillRegen < 0 && serverPlayer.field_6012 % 20 == 0) {
                this.refreshRunePoints(player, 1);
            }
            if (--this.breakTick <= 0) {
                this.blockBreakPosForMsg = null;
            }
            class_1799 main = player.method_6047();
            class_1799 off = player.method_6079();
            if (main.method_31574((class_1792)ModItems.MOB_STAFF.get()) || off.method_31574((class_1792)ModItems.MOB_STAFF.get())) {
                if (this.entitySelector.poi != null) {
                    serverPlayer.method_14220().method_14166(serverPlayer, (class_2394)class_2398.field_11240, true, (double)this.entitySelector.poi.method_10263() + 0.5, (double)this.entitySelector.poi.method_10264() + 1.5, (double)this.entitySelector.poi.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    serverPlayer.method_14220().method_14166(serverPlayer, (class_2394)class_2398.field_11240, true, (double)this.entitySelector.poi.method_10263() + 0.5, (double)this.entitySelector.poi.method_10264() + 1.5, (double)this.entitySelector.poi.method_10260() + 0.5, 3, 0.0, 0.0, 0.0, 0.01);
                }
            } else {
                this.entitySelector.reset();
            }
            if (serverPlayer.method_6059((class_1291)ModEffects.BATH.get())) {
                if (!this.touchedWater && serverPlayer.method_5799()) {
                    this.touchedWater = true;
                } else if (this.touchedWater && !serverPlayer.method_5799()) {
                    serverPlayer.method_6016((class_1291)ModEffects.BATH.get());
                    this.touchedWater = false;
                }
            }
        }
        this.getInv().update(player);
        this.foodDuration = Math.max(--this.foodDuration, -1);
        if (this.foodDuration == 0) {
            this.removeFoodEffect(player);
        }
    }

    public DailyPlayerUpdater getDailyUpdater() {
        return this.updater;
    }

    public int getCraftingSeed(class_1657 player) {
        if (this.craftingSeed == 0) {
            this.craftingSeed = player.method_6051().nextInt();
        }
        return this.craftingSeed;
    }

    public void onCrafted(class_1657 player) {
        this.craftingSeed = player.method_6051().nextInt();
    }

    public int getBoughtBarns() {
        return this.boughtBarns;
    }

    public void onBuyBarn() {
        ++this.boughtBarns;
    }

    public boolean onBarnFailMine(class_2338 pos) {
        boolean start = !pos.equals((Object)this.blockBreakPosForMsg);
        this.blockBreakPosForMsg = pos;
        this.breakTick = 20;
        return start;
    }

    public void increaseMobFrom(class_3222 player, BaseMonster monster) {
        this.entityStatsTracker.killEntity((class_1297)monster);
        this.increaseMobLevel(monster.getProp().levelIncreaseFromKill(this.entityStatsTracker.getKillCount(monster.method_5864()), player));
    }

    public void increaseMobLevel(int increase) {
        this.mobLevelIncrease += increase;
    }

    public int getMobLevelIncrease() {
        return this.mobLevelIncrease;
    }

    public NPCData.Gender getGender() {
        return this.gender;
    }

    public void readFromNBT(class_2487 nbt, class_1657 player) {
        this.starting = nbt.method_10577("Starting");
        this.runePointsMax = nbt.method_10583("MaxRunePoints");
        this.runePoints = nbt.method_10550("RunePoints");
        this.money = nbt.method_10550("Money");
        this.str = nbt.method_10583("Strength");
        this.vit = nbt.method_10583("Vitality");
        this.intel = nbt.method_10583("Intelligence");
        this.level.read(nbt.method_10580("Level"));
        this.strAdd = nbt.method_10583("StrengthBonus");
        this.vitAdd = nbt.method_10583("VitalityBonus");
        this.intAdd = nbt.method_10583("IntelligenceBonus");
        class_2487 skillCompound = nbt.method_10562("Skills");
        for (EnumSkills skill : EnumSkills.values()) {
            this.skillLevels.get((Object)skill).read(skillCompound.method_10580(skill.toString()));
        }
        this.spells.load(nbt.method_10562("Inventory"));
        this.shipping.load(nbt.method_10562("Shipping"));
        class_2487 shipped = nbt.method_10562("ShippedItems");
        shipped.method_10541().forEach(key -> {
            class_2487 d = shipped.method_10562(key);
            this.shippedItems.put((class_1792)class_2378.field_11142.method_10223(new class_2960(key)), new ShippedItemData(d.method_10550("Amount"), d.method_10550("Level")));
        });
        class_2487 shops = nbt.method_10562("ShopItems");
        shops.method_10541().forEach(key -> {
            class_2371 items = class_2371.method_10211();
            shops.method_10554(key, 10).forEach(comp -> items.add((Object)class_1799.method_7915((class_2487)((class_2487)comp))));
            this.shopItems.put(ModNPCJobs.getFromID(new class_2960(key)), (class_2371<class_1799>)items);
        });
        this.keeper.read(nbt.method_10562("Recipes"));
        this.updater.read(nbt.method_10562("DailyUpdater"));
        this.readFoodBuffFromNBT(nbt.method_10562("FoodData"));
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (serverPlayer.field_13987 != null) {
                this.recalculateStats(serverPlayer, false);
            }
        }
        if (nbt.method_10545("RestoreHP") && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            float f = nbt.method_10583("RestoreHP");
            serverPlayer.method_5682().method_18858((Runnable)new class_3738(1, () -> player.method_6033(f)));
        }
        this.walkingTracker.read(nbt.method_10562("WalkingTracker"));
        this.party.load(nbt.method_10562("PartyTag"));
        this.craftingSeed = nbt.method_10550("CraftingSeed");
        this.boughtBarns = nbt.method_10550("BoughtBarns");
        this.mobLevelIncrease = nbt.method_10550("MobLevelIncrease");
    }

    public class_2487 writeToNBTPlain(class_2487 nbt) {
        return this.writeToNBT(nbt, null, false);
    }

    public class_2487 writeToNBT(class_2487 nbt, class_1657 player, boolean wasDead) {
        nbt.method_10556("Starting", this.starting);
        nbt.method_10548("MaxRunePoints", this.runePointsMax);
        if (player == null) {
            nbt.method_10569("RunePoints", this.runePoints);
        } else if (wasDead) {
            nbt.method_10548("RestoreHP", player.method_6063() * GeneralConfig.deathHpPercent);
            nbt.method_10569("RunePoints", (int)(this.runePointsMax * GeneralConfig.deathRpPercent));
        } else {
            nbt.method_10548("RestoreHP", player.method_6032());
            nbt.method_10569("RunePoints", this.runePoints);
        }
        nbt.method_10569("Money", this.money);
        nbt.method_10548("Strength", this.str);
        nbt.method_10548("Vitality", this.vit);
        nbt.method_10548("Intelligence", this.intel);
        nbt.method_10566("Level", (class_2520)this.level.save());
        nbt.method_10548("StrengthBonus", this.strAdd);
        nbt.method_10548("VitalityBonus", this.vitAdd);
        nbt.method_10548("IntelligenceBonus", this.intAdd);
        class_2487 skillCompound = new class_2487();
        for (EnumSkills skill : EnumSkills.values()) {
            skillCompound.method_10566(skill.toString(), (class_2520)this.skillLevels.get((Object)skill).save());
        }
        nbt.method_10566("Skills", (class_2520)skillCompound);
        nbt.method_10566("Inventory", (class_2520)this.spells.save());
        nbt.method_10566("Shipping", (class_2520)this.shipping.save());
        class_2487 ship = new class_2487();
        this.shippedItems.forEach((key, value) -> {
            class_2487 d = new class_2487();
            d.method_10569("Amount", value.amount);
            d.method_10569("Level", value.maxLevel);
            ship.method_10566(key.toString(), (class_2520)d);
        });
        nbt.method_10566("ShippedItems", (class_2520)ship);
        class_2487 shop = new class_2487();
        for (Map.Entry<NPCJob, class_2371<class_1799>> entry : this.shopItems.entrySet()) {
            class_2499 l = new class_2499();
            for (class_1799 stack : entry.getValue()) {
                l.add((Object)stack.method_7953(new class_2487()));
            }
            shop.method_10566(ModNPCJobs.getIDFrom(entry.getKey()).toString(), (class_2520)l);
        }
        nbt.method_10566("ShopItems", (class_2520)shop);
        nbt.method_10566("Recipes", (class_2520)this.keeper.save());
        nbt.method_10566("DailyUpdater", (class_2520)this.updater.save());
        nbt.method_10566("FoodData", (class_2520)this.foodBuffNBT());
        nbt.method_10566("WalkingTracker", (class_2520)this.walkingTracker.save());
        nbt.method_10566("TamedEntityTracker", (class_2520)this.entityStatsTracker.save());
        nbt.method_10566("PartyTag", (class_2520)this.party.save());
        nbt.method_10569("CraftingSeed", this.craftingSeed);
        nbt.method_10569("BoughtBarns", this.boughtBarns);
        nbt.method_10569("MobLevelIncrease", this.mobLevelIncrease);
        return nbt;
    }

    public void resetAll(class_3222 player) {
        PlayerData newData = new PlayerData((class_1657)player);
        newData.spells.load(this.spells.save());
        newData.shipping.load(this.shipping.save());
        this.readFromNBT(newData.writeToNBTPlain(new class_2487()), null);
        this.recalculateStats(player, false);
        this.refreshShop((class_1657)player);
        this.starting = false;
        this.entityStatsTracker.reset();
        this.mobLevelIncrease = 0;
    }

    public record ShippedItemData(int amount, int maxLevel) {
    }
}

