/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.network.S2CWeaponUse;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class PlayerWeaponHandler
implements AttackActionHandler {
    private static final int COOLDOWN = 6;
    private final class_1657 entity;
    private AttackAction currentAction = (AttackAction)((Object)ModAttackActions.NONE.get());
    private int comboCount;
    private boolean scheduledAction;
    private AnimatedAction currentAnimation;
    private AnimatedAction lastAnimation;
    private int timeSinceLastChange;
    private final Set<class_1309> hitEntityTracker = new HashSet<class_1309>();
    private final Map<DataKey<?>, Object> dataMap = new HashMap();

    public PlayerWeaponHandler(class_1657 entity) {
        this.entity = entity;
    }

    public boolean doWeaponAttack(AttackAction action, class_1799 stack) {
        return this.doWeaponAttack(action, stack, null);
    }

    @Override
    public boolean doWeaponAttack(AttackAction action, class_1799 stack, @Nullable Spell spell) {
        AttackAction.OverrideType overrideType = this.checkOverride(action, true);
        if (this.entity.field_6002.field_9236 || overrideType != AttackAction.OverrideType.NONE) {
            if (overrideType == AttackAction.OverrideType.SCHEDULE) {
                this.scheduledAction = true;
                return true;
            }
            action.onSetup((class_1309)this.entity, this);
            this.setAnimationBasedOnState(action, -1, true);
            this.store(DataKey.USED_WEAPON, stack);
            this.store(DataKey.USED_SPELL, spell);
            return true;
        }
        return false;
    }

    public boolean canExecuteAction(AttackAction action) {
        return this.canExecuteAction(action, true);
    }

    public boolean canExecuteAction(AttackAction action, boolean allowNone) {
        return this.checkOverride(action, allowNone) != AttackAction.OverrideType.NONE;
    }

    private AttackAction.OverrideType checkOverride(AttackAction action, boolean allowNone) {
        if (allowNone && (this.currentAction == ModAttackActions.NONE.get() || this.currentAnimation == null)) {
            return this.timeSinceLastChange < 6 ? AttackAction.OverrideType.NONE : AttackAction.OverrideType.REPLACE;
        }
        if (this.entity.method_5854() != null && !action.usableOnMounts(this.comboCount + 1)) {
            return AttackAction.OverrideType.NONE;
        }
        if (this.currentAction == action && action.combos() != null) {
            ComboContainer.ComboHandler combo = action.combos().get(this.comboCount - 1);
            return combo != null && combo.canExecute().test(this) ? AttackAction.OverrideType.SCHEDULE : AttackAction.OverrideType.NONE;
        }
        return AttackAction.OverrideType.NONE;
    }

    private void setAnimationBasedOnState(AttackAction action, int comboIdx, boolean packet) {
        AttackAction change = this.currentAction.onChange((class_1309)this.entity, this);
        if (change != null) {
            action = change;
        }
        if (comboIdx != -1) {
            this.comboCount = comboIdx;
        }
        if (action == ModAttackActions.NONE.get()) {
            this.resetStates();
        }
        this.lastAnimation = this.currentAnimation;
        this.timeSinceLastChange = 0;
        this.currentAction = action;
        this.scheduledAction = false;
        this.currentAnimation = action.getAnimation((class_1309)this.entity, this.getComboCount());
        if (this.currentAction != ModAttackActions.NONE.get()) {
            ++this.comboCount;
        }
        this.entity.field_6283 = this.entity.field_6241;
        this.resetHitEntityTracker();
        this.currentAction.onStart((class_1309)this.entity, this);
        if (!this.entity.field_6002.field_9236 && packet) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CWeaponUse(this.currentAction, this.get(DataKey.USED_WEAPON), this.comboCount - 1, (class_1309)this.entity), (class_1297)this.entity);
        }
    }

    public void clientSideUpdate(AttackAction action, class_1799 stack, int count) {
        if (!this.entity.field_6002.field_9236) {
            return;
        }
        this.comboCount = count;
        this.setAnimationBasedOnState(action, -1, false);
        this.store(DataKey.USED_WEAPON, stack);
    }

    private void resetStates() {
        this.comboCount = 0;
        this.hitEntityTracker.clear();
        Set.copyOf(this.dataMap.keySet()).forEach(this::clear);
    }

    @Override
    public void tick() {
        if (this.currentAnimation != null) {
            ComboContainer.ComboHandler handler;
            ComboContainer.ComboHandler comboHandler = handler = this.currentAction.combos() != null ? this.currentAction.combos().get(this.comboCount - 1) : null;
            if (this.scheduledAction && handler != null && handler.canAdvance().test(this)) {
                this.setAnimationBasedOnState(this.currentAction, handler.advanceTo().get(this), true);
                return;
            }
            if (this.currentAnimation.tick(1 + (int)(this.currentAnimation.getSpeed() * (float)(handler != null ? handler.resetTime() : 0)))) {
                this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1, false);
            } else {
                class_1799 weapon = this.get(DataKey.USED_WEAPON);
                class_1657 class_16572 = this.entity;
                if (class_16572 instanceof class_3222) {
                    boolean changedItem;
                    class_3222 player = (class_3222)class_16572;
                    PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player).orElse(null);
                    boolean bl = changedItem = this.entity.method_6047() != weapon;
                    if (changedItem && weapon.method_7909() instanceof ItemSpell && data != null) {
                        for (int i = 0; i < data.getInv().method_5439(); ++i) {
                            if (data.getInv().method_5438(i) != weapon) continue;
                            changedItem = false;
                            break;
                        }
                    }
                    if (changedItem) {
                        this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1, true);
                    }
                }
                this.currentAction.run((class_1309)this.entity, weapon, this, this.currentAnimation);
            }
        }
        ++this.timeSinceLastChange;
        if (this.lastAnimation != null && this.timeSinceLastChange > this.lastAnimation.getEndTransitionTime()) {
            this.lastAnimation = null;
        }
    }

    @Override
    public class_1309 getEntity() {
        return this.entity;
    }

    @Override
    public boolean isScheduledAction() {
        return this.scheduledAction;
    }

    @Override
    public <T> void store(DataKey<T> key, T value) {
        this.dataMap.put(key, value);
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return (T)this.dataMap.getOrDefault(key, key.defaultValue());
    }

    @Override
    public <T> void clearWith(DataKey<T> key, @Nullable Consumer<T> apply) {
        if (apply == null) {
            this.dataMap.remove(key);
        } else {
            apply.accept(this.dataMap.remove(key));
        }
    }

    @Override
    public AttackAction getCurrentAction() {
        return this.currentAction;
    }

    @Override
    public float getCurrentTransitionProgress(float partialTicks) {
        if (this.currentAnimation == null) {
            return 1.0f;
        }
        return this.currentAnimation.getStartTransitionProgress(partialTicks);
    }

    @Override
    public float getLastTransitionProgress(float partialTicks) {
        if (this.lastAnimation == null) {
            return 0.0f;
        }
        return 1.0f - class_3532.method_15363((float)(((float)(this.timeSinceLastChange - 1) + partialTicks) / (float)this.lastAnimation.getEndTransitionTime()), (float)0.0f, (float)1.0f);
    }

    @Override
    public AnimatedAction getAnimation() {
        return this.currentAnimation;
    }

    @Override
    public AnimatedAction getLastAnimation() {
        return this.lastAnimation;
    }

    @Override
    public void setComboCount(int count) {
        this.comboCount = count;
    }

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    public float movementReduction() {
        return this.currentAction.movementReduction(this.currentAnimation);
    }

    public boolean isItemSwapBlocked() {
        return this.currentAction.disableItemSwitch();
    }

    @Override
    public Set<class_1309> getHitEntityTracker() {
        return this.hitEntityTracker;
    }
}

