/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.network.S2CRecipe;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class RecipeKeeper {
    private final Set<class_2960> unlockedRecipes = new HashSet<class_2960>();

    public void unlockRecipe(class_1657 player, class_1860<?> recipe) {
        this.unlockRecipesRes(player, Sets.newHashSet((Object[])new class_2960[]{recipe.method_8114()}));
    }

    public void unlockRecipe(class_1657 player, class_2960 res) {
        this.unlockRecipesRes(player, Sets.newHashSet((Object[])new class_2960[]{res}));
    }

    public void unlockRecipes(class_1657 player, Collection<? extends class_1860<?>> recipes) {
        this.unlockRecipesRes(player, recipes.stream().map(class_1860::method_8114).collect(Collectors.toSet()));
    }

    public void unlockRecipesRes(class_1657 player, Collection<class_2960> recipes) {
        this.unlockedRecipes.addAll(recipes);
        if (player instanceof class_3222) {
            Platform.INSTANCE.sendToClient(new S2CRecipe(recipes, false), (class_3222)player);
        }
    }

    public void lockRecipe(class_1657 player, class_1860<?> recipe) {
        this.lockRecipesRes(player, Sets.newHashSet((Object[])new class_2960[]{recipe.method_8114()}));
    }

    public void lockRecipe(class_1657 player, class_2960 res) {
        this.lockRecipesRes(player, Sets.newHashSet((Object[])new class_2960[]{res}));
    }

    public void lockRecipes(class_1657 player, Collection<? extends class_1860<?>> recipes) {
        this.lockRecipesRes(player, recipes.stream().map(class_1860::method_8114).collect(Collectors.toSet()));
    }

    public void lockRecipesRes(class_1657 player, Collection<class_2960> recipes) {
        recipes.forEach(this.unlockedRecipes::remove);
        if (player instanceof class_3222) {
            Platform.INSTANCE.sendToClient(new S2CRecipe(recipes, true), (class_3222)player);
        }
    }

    public boolean isUnlocked(class_1860<?> recipe) {
        if (GeneralConfig.recipeSystem.lockIsIgnored()) {
            return true;
        }
        return this.unlockedRecipes.contains(recipe.method_8114());
    }

    public boolean isUnlockedForCrafting(class_1860<?> recipe) {
        if (GeneralConfig.recipeSystem == GeneralConfig.RecipeSystem.SKILLBLOCKLOCK || GeneralConfig.recipeSystem == GeneralConfig.RecipeSystem.BASEBLOCKLOCK) {
            return this.isUnlocked(recipe);
        }
        return true;
    }

    public Collection<class_2960> unlockedRecipes() {
        return ImmutableSet.copyOf(this.unlockedRecipes);
    }

    public class_2487 save() {
        class_2487 nbt = new class_2487();
        class_2499 recipes = new class_2499();
        this.unlockedRecipes.forEach(res -> recipes.add((Object)class_2519.method_23256((String)res.toString())));
        nbt.method_10566("Unlocked", (class_2520)recipes);
        return nbt;
    }

    public void read(class_2487 nbt) {
        this.unlockedRecipes.clear();
        class_2499 recipes = nbt.method_10554("Unlocked", 8);
        recipes.forEach(inbt -> this.unlockedRecipes.add(new class_2960(inbt.method_10714())));
    }

    public void clientUpdate(Collection<class_2960> recipes) {
        this.unlockedRecipes.clear();
        this.unlockedRecipes.addAll(recipes);
    }
}

