/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_4050;
import net.minecraft.class_5134;

public class AxelDisasterAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.AXEL_DISASTER.create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        class_243 dir;
        if (anim.isAt("move_1")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
            entity.method_5783((class_3414)ModSounds.SPELL_GENERIC_LEAP.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.2f);
        }
        if (anim.isAt("move_2")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.5));
        }
        if (anim.isAt("move_3")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.5).method_1031(0.0, -0.5, 0.0));
        }
        if (anim.isAt("move_done")) {
            handler.store(DataKey.MOVE_DIRECTION, null);
        }
        handler.applyMoveDirection();
        if (anim.isPast("attack_start") && !anim.isPast("attack_end") && !entity.field_6002.field_9236) {
            if (anim.isAt("reset")) {
                handler.resetHitEntityTracker();
            }
            handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1014(0.75).method_1012(0.0, 0.0, 0.5))).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return true;
    }

    @Override
    public class_4050 getPose(class_1309 entity, AttackActionHandler handler) {
        if (handler.getAnimation().isPast("move_1") && !handler.getAnimation().isPast("move_done")) {
            return class_4050.field_18080;
        }
        return null;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

