/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class DualBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), EnumSkills.DUAL, 20), 0).build();

    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.DUAL_BLADES.get(comboIdx).create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() != 5 && handler.getComboCount() != 6 && handler.getComboCount() != 8 && anim.isAt("attack")) {
            if (!entity.field_6002.field_9236) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(IAOEWeapon.createOBB((class_1309)entity, (class_1799)stack, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, handler.getComboCount() == 7 ? 1.0 : 0.0)))).executeAttack();
            }
            entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.15));
                break;
            }
            case 2: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.2));
                break;
            }
            case 3: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.25));
                break;
            }
            case 4: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.3));
                break;
            }
            case 5: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("step")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(0.3));
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 360.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                break;
            }
            case 6: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454() - 90.0f));
                    entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(0.3));
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 360.0f, 0.0f)) != null) {
                    handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f + 360.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                break;
            }
            case 7: {
                class_243 dir;
                if (anim.isAt("leap")) {
                    dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(1.1).method_1031(0.0, 0.6, 0.0));
                }
                if (!anim.isAt("down")) break;
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.9).method_1031(0.0, -0.4, 0.0));
                break;
            }
            case 8: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454() + 120.0f));
                    entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                }
                if (anim.isAt("last")) {
                    entity.method_5783((class_3414)ModSounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.5f);
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() - 1440.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        if (handler.getComboCount() != 8 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(d -> LevelCalc.useRP((class_1657)player, d, GeneralConfig.dualBladeUltimate, true, 0.0f, false, new EnumSkills[0]));
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return handler.getComboCount() == 8;
    }

    @Override
    public float movementReduction(AnimatedAction current) {
        return GeneralConfig.moveSpeedAttack.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo < 5;
    }
}

