/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;

public class NaiveBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("prepared")).build();

    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return PlayerModelAnimations.NAIVE_BLADE_SUCCESS.create(speed);
        }
        return PlayerModelAnimations.NAIVE_BLADE.create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() == 2) {
            if (anim.isAt("jump")) {
                entity.method_18799(new class_243(0.0, 0.37, 0.0));
            }
            if (anim.isAt("attack_1")) {
                entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                if (!entity.field_6002.field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.circleTargets(entity.method_36454() - 150.0f, entity.method_36454() + 150.0f, 0.0f)).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.3f)).executeAttack();
                    if (entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        player.method_7263();
                    }
                }
            }
            if (anim.isAt("attack_2")) {
                entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                if (!entity.field_6002.field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, 3.0, 0.0, false)).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).executeAttack();
                }
            }
        } else if (anim.isAt("prepared")) {
            entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_24063, entity.method_5634(), 1.5f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            entity.method_5783((class_3414)ModSounds.SPELL_NAIVE_BLADE.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return handler.getComboCount() == 2;
    }

    public static boolean canCounter(AttackActionHandler handler) {
        AnimatedAction anim = handler.getAnimation();
        return handler.getCurrentAction() instanceof NaiveBladeAttack && anim != null && handler.getComboCount() == 1 && anim.isPast("prepared") && !anim.done(0);
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

