/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_4051;
import net.minecraft.class_5134;

public class RapidMoveAttack
extends AttackAction {
    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.RAPID_MOVE.create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        class_1297 target = (class_1297)handler.get(DataKey.TARGET);
        if (target != null) {
            class_243 dir = target.method_19538().method_1020(entity.method_19538());
            double width = 0.5 * (double)entity.method_17681();
            double targetWidth = 0.5 * (double)target.method_17681();
            double closeDist = width * width + targetWidth * targetWidth;
            closeDist += 1.0;
            if (dir.method_1027() < closeDist) {
                entity.method_18799(class_243.field_1353);
            } else {
                class_243 motion = dir.method_1029().method_1021(1.0 + entity.method_26825(class_5134.field_23719) * 2.0);
                if (dir.method_1027() < closeDist * 2.0) {
                    motion = dir.method_1021(0.1);
                }
                entity.method_18799(motion);
            }
            class_243 direct = EntityUtils.getStraightProjectileTarget(entity.method_33571(), target);
            entity.method_5702(class_2183.class_2184.field_9851, direct);
            entity.field_6037 = true;
        }
        if (anim.isAt("attack")) {
            entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
            if (!entity.field_6002.field_9236) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1014(0.5).method_1012(0.0, 0.0, 1.0))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).executeAttack());
            }
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        class_1309 target;
        super.onStart(entity, handler);
        if (!entity.field_6002.method_8608() && (target = entity.field_6002.method_21726(class_1309.class, class_4051.method_36625(), entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_5829().method_1009(20.0, 10.0, 20.0))) != null) {
            handler.store(DataKey.TARGET, target);
        }
    }
}

