/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;

public class RushAttack
extends AttackAction {
    private final ComboContainer combo;

    public RushAttack() {
        Predicate<AttackActionHandler> MAIN = handler -> handler.getAnimation().isPast("chain_1_start") && !handler.getAnimation().isPast("chain_1_end") || handler.getAnimation().isPast("chain_2_start") && !handler.getAnimation().isPast("chain_2_end");
        Function<Integer, ComboContainer.ComboGetter> IDX = idx -> handler -> !handler.getAnimation().isPast("chain_1_end") ? idx : 6;
        this.combo = ComboContainer.Builder.builder().addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(handler -> handler.getAnimation().isPast("chain_2_start") && !handler.getAnimation().isPast("chain_2_end"), 0).build();
    }

    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        comboIdx = comboIdx < 6 ? 0 : 1;
        return PlayerModelAnimations.RUSH_ATTACK.get(comboIdx).create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() == 7) {
            if (anim.isAt("leap")) {
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(1.6).method_1031(0.0, -0.6, 0.0));
            }
            if (anim.isAt("attack_start")) {
                entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
            }
            entity.field_6017 = 0.0f;
            if (!entity.field_6002.field_9236 && anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, CombatUtils.getWidth(entity, 1.5), -1.0, false)).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 0.8f)).executeAttack());
            }
        } else {
            class_243 dir;
            if (anim.isAt("step")) {
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.2));
            }
            if (anim.isAt("jump")) {
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
                entity.method_6092(new class_1293(class_1294.field_5906, 12, 2, true, false, false));
            }
            entity.field_6017 = 0.0f;
            if (anim.isAt("attack")) {
                if (!entity.field_6002.field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, CombatUtils.getWidth(entity, 0.5), 0.5, false)).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).executeAttack();
                }
                entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public void onSetup(class_1309 entity, AttackActionHandler handler) {
        if (handler.getAnimation() != null && handler.getComboCount() < 7 && handler.getAnimation().isPast("chain_2_start")) {
            handler.setComboCount(6);
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

