/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;

public class SpearAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), EnumSkills.SPEAR, 20), 0).build();

    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.SPEAR.get(comboIdx).create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        if (handler.getComboCount() != 5 && anim.isAt("attack")) {
            if (!entity.field_6002.field_9236) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(IAOEWeapon.createOBB((class_1309)entity, (class_1799)stack, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0)))).executeAttack();
            }
            entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
        }
        class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
        switch (handler.getComboCount()) {
            case 1: 
            case 3: 
            case 4: {
                if (!anim.isAt("step")) break;
                entity.method_18799(dir.method_1021(0.3));
                break;
            }
            case 2: {
                if (!anim.isAt("step")) break;
                entity.method_18799(dir.method_1021(0.15));
                break;
            }
            case 5: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
                    handler.resetHitEntityTracker();
                    entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
                }
                if ((attack = SpearAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 1260.0f, -1.0f)) != null) {
                    handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
                if (anim.isAt("leap")) {
                    entity.method_18799(dir.method_1021(1.3).method_1031(0.0, 0.4, 0.0));
                }
                if (!anim.isAt("slam")) break;
                class_243 look = entity.method_5720();
                look = new class_243(look.method_10216(), 0.0, look.method_10215()).method_1021(1.2);
                class_243 attackPos = entity.method_19538().method_1031(0.0, 0.2, 0.0).method_1019(look);
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new class_238(-1.0, -1.2, 0.0, 1.0, 1.2, 2.5), false)).executeAttack();
                class_243 pos = entity.method_19538().method_1031(0.0, -1.0, 0.0);
                class_2338.class_2339 mut = new class_2338.class_2339();
                class_243 axis = new class_243(0.0, 1.0, 0.0);
                class_243 dir2 = new class_243(0.0, 0.0, 1.0).method_1021(1.0);
                for (int i = -180; i < 180; i += 15) {
                    class_1937 class_19372;
                    class_243 scaled = MathUtils.rotate((class_243)axis, (class_243)dir2, (float)i);
                    mut.method_10103(class_3532.method_15357((double)(pos.method_10216() + dir2.method_10216())), class_3532.method_15357((double)pos.method_10214()), class_3532.method_15357((double)(pos.method_10215() + dir2.method_10215())));
                    class_2680 state = entity.field_6002.method_8320((class_2338)mut);
                    if (state.method_26217() == class_2464.field_11455 || !((class_19372 = entity.method_37908()) instanceof class_3218)) continue;
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, state), attackPos.method_10216() + scaled.method_10216() + entity.method_18798().method_10216(), entity.method_23318() + 0.1, attackPos.method_10215() + scaled.method_10215() + entity.method_18798().method_10215(), 0, (double)((float)scaled.method_10216()), 1.5, (double)((float)scaled.method_10215()), 1.0);
                }
                entity.method_5783(class_3417.field_14803, 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (handler.getComboCount() == 5) {
            handler.store(DataKey.FIXED_LOOK, anim.isPast("leap") && !anim.isPast("leap_end"));
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 5 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(d -> LevelCalc.useRP((class_1657)player, d, GeneralConfig.spearUltimate, true, 0.0f, false, new EnumSkills[0]));
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return handler.getComboCount() == 5;
    }

    @Override
    public float movementReduction(AnimatedAction current) {
        return GeneralConfig.moveSpeedAttack.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo != 5;
    }
}

