/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class WaterLaserAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> true, 0).build();
    private final int type;

    public WaterLaserAttack(int type) {
        this.type = type;
    }

    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return PlayerModelAnimations.WATER_LASER_END.create(speed);
        }
        return switch (this.type) {
            case 2 -> PlayerModelAnimations.WATER_LASER_THREE.create(speed);
            case 1 -> PlayerModelAnimations.WATER_LASER_TWO.create(speed);
            default -> PlayerModelAnimations.WATER_LASER_ONE.create(speed);
        };
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        block6: {
            block7: {
                if (handler.getComboCount() != 1) break block6;
                class_1937 class_19372 = entity.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    if (anim.isAt("attack")) {
                        Spell spell;
                        entity.method_6104(class_1268.field_5808);
                        if (handler.get(DataKey.USED_SPELL) != null && (spell = handler.get(DataKey.USED_SPELL)).use(serverLevel, entity, stack) && entity instanceof class_3222) {
                            class_3222 player = (class_3222)entity;
                            spell.levelSkill(player);
                        }
                    }
                }
                if (entity.field_6002.field_9236 || !anim.isPast("continue")) break block6;
                if (!(entity instanceof class_3222)) break block7;
                class_3222 player = (class_3222)entity;
                if (!entity.method_6030().method_7960() || !Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> d.getInv().getInUseStack() != handler.get(DataKey.USED_WEAPON)).orElse(false).booleanValue()) break block6;
            }
            handler.doWeaponAttack(this, handler.get(DataKey.USED_WEAPON), handler.get(DataKey.USED_SPELL));
        }
    }

    @Override
    public AttackAction onChange(class_1309 entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 1) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Spell spell = handler.get(DataKey.USED_SPELL);
                class_1799 stack = handler.get(DataKey.USED_WEAPON);
                if (stack.method_7909() instanceof ItemSpell) {
                    player.method_7357().method_7906(stack.method_7909(), spell.coolDown());
                }
            }
            return this;
        }
        return null;
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

