/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_5134;

public class WindSlashAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("chain_start") && !handler.getAnimation().isPast("spin_end")).build();

    @Override
    public AnimatedAction getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)ItemNBT.attackSpeedModifier(entity);
        return PlayerModelAnimations.WIND_SLASH.get(comboIdx).create(speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimatedAction anim) {
        class_243 dir;
        handler.store(DataKey.FIXED_LOOK, true);
        if (anim.isAt("spin_start")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
            handler.resetHitEntityTracker();
            entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14550, entity.method_5634(), 0.7f, 0.5f);
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.35));
        }
        if (anim.isAt("reset")) {
            handler.resetHitEntityTracker();
            entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14550, entity.method_5634(), 1.0f, 0.7f);
        }
        if (anim.isAt("leap")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.35).method_1031(0.0, 0.3, 0.0));
        }
        if (anim.isAt("spin_end")) {
            handler.store(DataKey.MOVE_DIRECTION, null);
        }
        if (anim.isPast("spin_start") && !anim.isPast("spin_end")) {
            entity.method_38785();
            if (!entity.field_6002.field_9236) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1014(0.75))).withBonusAttributesMultiplier(class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
        handler.applyMoveDirection();
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
            handler.resetHitEntityTracker();
            entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14550, entity.method_5634(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 0.7f);
            class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.35));
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

