/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.blocks.tile.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixinhelper.LevelSnapshotHandler;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2465;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_4643;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import org.jetbrains.annotations.Nullable;

public class BlockTreeBase
extends class_2465
implements class_2343,
Growable {
    public static final int MAX_AGE = 4;
    public static final class_2758 AGE = class_2741.field_12497;
    private final Supplier<class_2975<?, ?>> stump;
    private final Supplier<class_2975<class_4643, ?>> tree1;
    private final Supplier<class_2975<class_4643, ?>> tree2;
    private final Supplier<class_1792> seedItem;

    public BlockTreeBase(class_4970.class_2251 properties, Supplier<class_2975<?, ?>> stump, Supplier<class_2975<class_4643, ?>> tree1, Supplier<class_2975<class_4643, ?>> tree2, Supplier<class_1792> seedItem) {
        super(properties);
        this.stump = stump;
        this.tree1 = tree1;
        this.tree2 = tree2;
        this.seedItem = seedItem;
    }

    public static boolean isAirOrReplaceable(class_2680 state) {
        return state.method_26215() || state.method_26207() == class_3614.field_15956 || state.method_26164(class_3481.field_15503);
    }

    public boolean growTree(class_3218 level, class_2338 pos, class_2680 state, Random rand) {
        return switch ((Integer)state.method_11654((class_2769)AGE)) {
            case 2 -> {
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().takeSnapshot(null);
                class_2586 var6_5 = level.method_8321(pos);
                if (var6_5 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)var6_5;
                    tree.onRemove((class_1937)level, false);
                }
                boolean result = this.tree2.get().method_12862((class_5281)level, level.method_14178().method_12129(), rand, pos);
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().popSnapshots(result);
                yield result;
            }
            case 1 -> {
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().takeSnapshot(null);
                class_2586 var6_6 = level.method_8321(pos);
                if (var6_6 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)var6_6;
                    tree.onRemove((class_1937)level, false);
                }
                boolean result = this.tree1.get().method_12862((class_5281)level, level.method_14178().method_12129(), rand, pos);
                ((LevelSnapshotHandler)level).runecraftory$getSnapshotHandler().popSnapshots(result);
                yield result;
            }
            case 0 -> this.stump.get().method_12862((class_5281)level, level.method_14178().method_12129(), rand, pos);
            default -> {
                class_2586 var6_7 = level.method_8321(pos);
                if (var6_7 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)var6_7;
                    tree.update(level);
                }
                yield false;
            }
        };
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (!newState.method_27852(state.method_26204())) {
                FarmlandHandler.get(serverLevel.method_8503()).getData(serverLevel, pos.method_10074()).ifPresent(d -> d.onCropRemove(serverLevel, pos, newState));
                class_2586 class_25862 = serverLevel.method_8321(pos);
                if (class_25862 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)class_25862;
                    tree.onRemove(level, true);
                }
            }
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TreeBlockEntity(pos, state);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)this.seedItem.get());
    }

    @Override
    public int runecraftory$getGrowableMaxAge() {
        return 4;
    }

    @Override
    public boolean canGrow(class_3218 level, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)AGE) == 5) {
            return class_2338.method_20437((class_2338)pos.method_10069(-1, 0, -1), (class_2338)pos.method_10069(1, 2, 1)).allMatch(p -> p.equals((Object)pos) || BlockTreeBase.isAirOrReplaceable(level.method_8320(p)));
        }
        return Growable.super.canGrow(level, pos, state);
    }

    @Override
    public class_2680 runecraftory$getGrowableStateForAge(class_2680 current, int age) {
        int newAge = current.method_28500((class_2769)AGE).map(i -> class_3532.method_15340((int)(age - 1), (int)0, (int)(i + 1))).orElse(age - 1);
        return (class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(newAge));
    }

    @Override
    public boolean runecraftory$isAtMaxAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 4;
    }

    @Override
    public void onGrow(class_3218 level, class_2338 pos, class_2680 state, class_2680 old) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (!old.method_27852((class_2248)this) || !Objects.equals(old.method_11654((class_2769)AGE), age) || this.runecraftory$isAtMaxAge(state)) {
            if (age == 0 || old.method_28500((class_2769)AGE).orElse(0) == 2) {
                Growable.super.onGrow(level, pos, state, old);
            }
            if (this.growTree(level, pos, state, level.method_8409())) {
                Growable.super.onGrow(level, pos, state, old);
                level.method_8652(pos.method_10074(), ((class_2248)ModBlocks.TREE_SOIL.get()).method_9564(), 3);
            }
        }
    }
}

