/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.common.blocks.BlockBossSpawner;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_156;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2048;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_3730;
import net.minecraft.class_5312;
import net.minecraft.class_5425;

public class BossSpawnerBlockEntity
extends class_2586 {
    private int lastUpdateDay = -1;
    private int ticker;
    private class_2960 spawnListId;
    private StructureBossManager.BossSpawnList spawnList;
    private class_1299<?> nextSpawn;
    private class_2960 structureID;
    private class_3449 structure;
    private final Random random = new Random();

    public BossSpawnerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlocks.BOSS_SPAWNER_TILE.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, BossSpawnerBlockEntity blockEntity) {
        ++blockEntity.ticker;
        if (blockEntity.ticker % 5 != 0) {
            return;
        }
        class_243 pos = class_243.method_24953((class_2382)blockPos.method_10086(2));
        List<class_3222> nearby = LevelCalc.playersAround((class_1924)level, pos, 20.0);
        if (!nearby.isEmpty() && blockEntity.nextSpawn != null) {
            boolean flag;
            EntityProperties prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(blockEntity.nextSpawn);
            boolean canSpawn = false;
            if (prop.spawnerPredicate != class_2048.field_9599) {
                ArrayList<class_3222> removed = new ArrayList<class_3222>();
                for (class_3222 player : nearby) {
                    if (!prop.spawnerPredicate.method_8914(player, (class_1297)player)) {
                        removed.add(player);
                        if (!player.method_19538().method_24802((class_2374)pos, 16.0)) continue;
                        class_243 opposite = player.method_19538().method_1020(pos).method_1029();
                        player.field_6017 = 0.0f;
                        player.method_18799(opposite);
                        player.method_14254((class_2561)new class_2588("runecraftory.misc.spawner.entry.deny").method_27692(class_124.field_1064), class_2556.field_11733, class_156.field_25140);
                        player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                        continue;
                    }
                    if (!player.method_19538().method_24802((class_2374)pos, 10.0)) continue;
                    canSpawn = true;
                }
                nearby.removeAll(removed);
            } else {
                canSpawn = true;
            }
            boolean bl = flag = blockEntity.lastUpdateDay != WorldUtils.day(level);
            if (canSpawn && flag) {
                blockEntity.spawnEntity(nearby, pos);
            }
        }
    }

    public class_3449 getStructure() {
        class_1937 class_19372;
        if (this.structureID != null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.structure = serverLevel.method_27056().method_28388(this.method_11016(), this.field_11863.method_30349().method_33310(class_2378.field_25915).map(r -> (class_5312)r.method_10223(this.structureID)).orElseThrow());
        }
        return this.structure;
    }

    public void spawnEntity(List<class_3222> nearby, class_243 pos) {
        class_1297 e;
        if (!this.field_11863.field_9236 && this.nextSpawn != null && (e = this.nextSpawn.method_5883(this.field_11863)) != null) {
            IBaseMob mob;
            this.lastUpdateDay = WorldUtils.day(this.field_11863);
            if (e instanceof EnsembleMonsters) {
                EnsembleMonsters ensemble = (EnsembleMonsters)e;
                if (!ensemble.canSpawnerSpawn((class_3218)this.field_11863, this.field_11867, 32)) {
                    return;
                }
                ensemble.setLevel(LevelCalc.levelFromPos((class_3218)this.field_11863, class_243.method_24953((class_2382)this.field_11867), nearby));
                ensemble.setRestrictRadius(13);
                switch ((class_2350)this.method_11010().method_11654((class_2769)BlockBossSpawner.FACING)) {
                    case field_11035: {
                        ensemble.withDirection(class_2470.field_11464);
                        break;
                    }
                    case field_11039: {
                        ensemble.withDirection(class_2470.field_11465);
                        break;
                    }
                    case field_11034: {
                        ensemble.withDirection(class_2470.field_11463);
                        break;
                    }
                    default: {
                        ensemble.withDirection(class_2470.field_11467);
                        break;
                    }
                }
            } else if (!this.noNearby()) {
                return;
            }
            if (e instanceof IBaseMob) {
                mob = (IBaseMob)e;
                mob.setLevel(LevelCalc.levelFromPos((class_3218)this.field_11863, class_243.method_24953((class_2382)this.field_11867), nearby));
            }
            e.method_5808((double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 5), (double)this.field_11867.method_10260() + 0.5, this.field_11863.field_9229.nextFloat() * 360.0f, 0.0f);
            if (e instanceof class_1308) {
                mob = (class_1308)e;
                mob.method_18408(this.field_11867, 13);
                mob.method_5943((class_5425)this.field_11863, this.field_11863.method_8404(e.method_24515()), class_3730.field_16469, null, null);
            }
            this.field_11863.method_8649(e);
            this.updateEntity();
        }
    }

    public void setEntity(class_1299<?> entity) {
        this.nextSpawn = entity;
    }

    private void updateEntity() {
        if (this.spawnList != null) {
            this.spawnList.getRandom(this.random).ifPresent(this::setEntity);
        }
    }

    private boolean noNearby() {
        return this.field_11863.method_8390(class_1308.class, new class_238(this.field_11867).method_1014(32.0), e -> e.method_5864() == this.nextSpawn || this.spawnList != null && this.spawnList.has(e.method_5864())).isEmpty();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.lastUpdateDay = tag.method_10550("LastUpdate");
        if (tag.method_10545("SpawnListId")) {
            this.spawnListId = new class_2960(tag.method_10558("SpawnListId"));
            this.spawnList = DataPackHandler.INSTANCE.structureBossManager().getBoss(new class_2960(tag.method_10558("SpawnListId")));
            this.updateEntity();
        }
        if (tag.method_10545("Entity")) {
            this.nextSpawn = (class_1299)class_2378.field_11145.method_10223(new class_2960(tag.method_10558("Entity")));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("LastUpdate", this.lastUpdateDay);
        if (this.spawnListId != null) {
            tag.method_10582("SpawnListId", this.spawnListId.toString());
        }
        if (this.nextSpawn != null) {
            tag.method_10582("Entity", class_2378.field_11145.method_10221(this.nextSpawn).toString());
        }
    }

    public static class_2487 creatTagFor(class_2960 spawnListId) {
        class_2487 tag = new class_2487();
        tag.method_10582("SpawnListId", spawnListId.toString());
        tag.method_10569("LastUpdate", -1);
        return tag;
    }
}

