/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.tile;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.BlockFruitTreeLeaf;
import io.github.flemmli97.runecraftory.common.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.apache.logging.log4j.Logger;

public class TreeBlockEntity
extends class_2586 {
    private static final int MAX_HEALTH = 50;
    private int health;
    private List<class_2338> logs = new ArrayList<class_2338>();
    private List<class_2338> leaves = new ArrayList<class_2338>();
    private List<class_2338> fruits = new ArrayList<class_2338>();

    public TreeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlocks.TREE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void updateTreeLogs(Collection<class_2338> pos) {
        this.logs = new ArrayList<class_2338>(pos.stream().filter(p -> !p.equals((Object)this.method_11016().method_10074())).toList());
        this.method_5431();
    }

    public void updateTreeLeaves(Collection<class_2338> pos) {
        this.leaves = new ArrayList<class_2338>(pos);
        this.method_5431();
    }

    public void updateTreeFruits(Collection<class_2338> pos) {
        this.fruits = new ArrayList<class_2338>(pos);
        this.method_5431();
    }

    public int getHealth() {
        return this.health;
    }

    public void onBreak() {
        this.health = Math.max(0, this.health - 5);
    }

    public void dailyUpdate() {
        this.health = Math.min(50, this.health + 3);
    }

    public void update(class_3218 level) {
        for (class_2338 pos : this.fruits) {
            class_2680 state = level.method_8320(pos);
            if (!(state.method_26204() instanceof BlockFruitTreeLeaf)) continue;
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)BlockFruitTreeLeaf.HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.health = tag.method_10550("Health");
        class_2499 logs = tag.method_10554("Logs", 11);
        logs.forEach(t -> this.logs.add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
        class_2499 leaves = tag.method_10554("Leaves", 11);
        leaves.forEach(t -> this.leaves.add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
        class_2499 fruits = tag.method_10554("Fruits", 11);
        fruits.forEach(t -> this.fruits.add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Health", this.health);
        class_2499 logs = new class_2499();
        this.logs.forEach(p -> logs.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, p).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)))));
        tag.method_10566("Logs", (class_2520)logs);
        class_2499 leaves = new class_2499();
        this.leaves.forEach(p -> leaves.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, p).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)))));
        tag.method_10566("Leaves", (class_2520)leaves);
        class_2499 fruits = new class_2499();
        this.fruits.forEach(p -> fruits.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, p).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)))));
        tag.method_10566("Fruits", (class_2520)fruits);
    }

    public void onRemove(class_1937 level, boolean particle) {
        this.logs.forEach(p -> this.removeBlock(level, (class_2338)p, particle));
        this.leaves.forEach(p -> this.removeBlock(level, (class_2338)p, particle));
        this.fruits.forEach(p -> this.removeBlock(level, (class_2338)p, particle));
    }

    private void removeBlock(class_1937 level, class_2338 pos, boolean particle) {
        class_2680 blockState = level.method_8320(pos);
        if (particle) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
        }
        level.method_8652(pos, blockState.method_26227().method_15759(), 2);
    }
}

