/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeather;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.commands.SpellArgumentType;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;

public class RunecraftoryCommand {
    public static void reg(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"runecraftory").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"skill").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9264(Stream.concat(Stream.of(EnumSkills.values()).map(Object::toString), Stream.of("ALL")), (SuggestionsBuilder)builder)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillLevel)))).then(class_2170.method_9247((String)"xp").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillXP))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setSkillLevel))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"level").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setLevel)))).then(class_2170.method_9247((String)"xp").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addLevelXP)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlockRecipes").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"all").executes(RunecraftoryCommand::unlockRecipes))).then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(RunecraftoryCommand::allRecipes).executes(RunecraftoryCommand::unlockRecipe)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"recalcStats").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(RunecraftoryCommand::recalcStats)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"weather").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"weather", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9264(Stream.of(EnumWeather.values()).map(Object::toString), (SuggestionsBuilder)builder)).executes(RunecraftoryCommand::setWeather)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"all").executes(RunecraftoryCommand::resetAll))).then(class_2170.method_9247((String)"recipes").executes(RunecraftoryCommand::resetRecipes))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spell").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"cast").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<class_2168>)ctx, Set.of(((class_2168)ctx.getSource()).method_9229())))).then(class_2170.method_9244((String)"for", (ArgumentType)class_2186.method_9306()).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<class_2168>)ctx, class_2186.method_9317((CommandContext)ctx, (String)"as"))))))).then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<class_2168>)ctx, Set.of(((class_2168)ctx.getSource()).method_9229())))).then(class_2170.method_9244((String)"for", (ArgumentType)class_2186.method_9306()).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<class_2168>)ctx, class_2186.method_9317((CommandContext)ctx, (String)"as")))))))));
    }

    private static int addSkillLevel(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                    for (EnumSkills skill : EnumSkills.values()) {
                        LevelExpPair skLvl = data.getSkillLevel(skill);
                        data.setSkillLevel(skill, (class_1657)player, skLvl.getLevel() + amount, skLvl.getXp(), true);
                    }
                });
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.lvl.add", new Object[]{s, player.method_5477(), amount}), false);
                ++ret;
            }
            return ret;
        }
        EnumSkills skill = EnumSkills.read(s);
        if (skill == null) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.no", new Object[]{s}), false);
            return 0;
        }
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                LevelExpPair skLvl = data.getSkillLevel(skill);
                data.setSkillLevel(skill, (class_1657)player, skLvl.getLevel() + amount, skLvl.getXp(), true);
            });
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.lvl.add", new Object[]{s, player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addSkillXP(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                    for (EnumSkills skill : EnumSkills.values()) {
                        data.increaseSkill(skill, (class_1657)player, amount);
                    }
                });
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.lvl.add", new Object[]{s, player.method_5477(), amount}), false);
                ++ret;
            }
            return ret;
        }
        EnumSkills skill = EnumSkills.read(s);
        if (skill == null) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.no", new Object[]{s}), false);
            return 0;
        }
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.increaseSkill(skill, (class_1657)player, amount));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.xp.add", new Object[]{s, player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setSkillLevel(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                    for (EnumSkills skill : EnumSkills.values()) {
                        data.setSkillLevel(skill, (class_1657)player, amount, 0.0f, true);
                    }
                });
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.lvl.set", new Object[]{s, player.method_5477(), amount}), false);
                ++ret;
            }
            return ret;
        }
        EnumSkills skill = EnumSkills.read(s);
        if (skill == null) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.no", new Object[]{s}), false);
            return 0;
        }
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.setSkillLevel(skill, (class_1657)player, amount, 0.0f, true));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.skill.lvl.set", new Object[]{new class_2588(skill.getTranslation()), player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addLevelXP(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.addXp((class_1657)player, amount));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.lvl.xp.add", new Object[]{player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setLevel(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.setPlayerLevel((class_1657)player, amount, 0.0f, true));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.lvl.set", new Object[]{player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetAll(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                data.resetAll(player);
                Platform.INSTANCE.sendToClient(new S2CCapSync((PlayerData)data), player);
            });
            QuestHandler.getData(player).resetAll();
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.reset.all", new Object[]{player.method_5477()}), false);
            ++ret;
        }
        return ret;
    }

    private static CompletableFuture<Suggestions> allRecipes(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)((class_2168)ctx.getSource()).method_9207()).orElse(null);
        if (data != null) {
            for (SextupleRecipe r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.FORGE.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.method_8114());
            }
            for (SextupleRecipe r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.CHEMISTRY.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.method_8114());
            }
            for (SextupleRecipe r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.ARMOR.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.method_8114());
            }
            for (SextupleRecipe r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.COOKING.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.method_8114());
            }
        }
        return class_2172.method_9264(allRecipes.stream().map(class_2960::toString), (SuggestionsBuilder)builder);
    }

    private static int unlockRecipe(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2960 res = class_2232.method_9443(ctx, (String)"id");
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getRecipeKeeper().unlockRecipesRes((class_1657)player, List.of(res)));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.unlock.recipe", new Object[]{player.method_5477(), res.toString()}), false);
            ++ret;
        }
        return ret;
    }

    private static int unlockRecipes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.FORGE.get()).forEach(r -> allRecipes.add(r.method_8114()));
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.CHEMISTRY.get()).forEach(r -> allRecipes.add(r.method_8114()));
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.ARMOR.get()).forEach(r -> allRecipes.add(r.method_8114()));
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)ModCrafting.COOKING.get()).forEach(r -> allRecipes.add(r.method_8114()));
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getRecipeKeeper().unlockRecipesRes((class_1657)player, allRecipes));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.unlock.recipes", new Object[]{player.method_5477()}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetRecipes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> data.getRecipeKeeper().lockRecipesRes((class_1657)player, data.getRecipeKeeper().unlockedRecipes()));
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.reset.recipe", new Object[]{player.method_5477()}), false);
            ++ret;
        }
        return ret;
    }

    private static int setWeather(CommandContext<class_2168> ctx) {
        EnumWeather weather;
        String s = StringArgumentType.getString(ctx, (String)"weather");
        try {
            weather = EnumWeather.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)new class_2588("runecraftory.command.weather.no", new Object[]{s}));
            return 0;
        }
        WorldHandler.get(((class_2168)ctx.getSource()).method_9211()).updateWeatherTo(((class_2168)ctx.getSource()).method_9225(), weather);
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.set.weather", new Object[]{new class_2588(weather.translation)}), false);
        return 1;
    }

    private static int recalcStats(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection entities = class_2186.method_9317(ctx, (String)"entities");
        int i = 0;
        for (class_1297 e : entities) {
            if (e instanceof class_3222) {
                class_3222 player = (class_3222)e;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(d -> d.recalculateStats(player, false));
                ++i;
                continue;
            }
            if (e instanceof EntityNPCBase) {
                EntityNPCBase npc = (EntityNPCBase)e;
                npc.recalcStatsFull();
                ++i;
                continue;
            }
            if (!(e instanceof BaseMonster)) continue;
            BaseMonster monster = (BaseMonster)e;
            monster.recalcStatsFull();
            ++i;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("runecraftory.command.recalc.stats", new Object[]{i}), false);
        return i;
    }

    private static int castSpell(CommandContext<class_2168> ctx, Collection<? extends class_1297> entities) {
        int success = 0;
        Spell spell = SpellArgumentType.getSpell(ctx, "spell");
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1309)) continue;
            class_1309 living = (class_1309)class_12972;
            spell.use(living);
            ++success;
        }
        return success;
    }

    private static int applySpellTo(CommandContext<class_2168> ctx, Collection<? extends class_1297> entities) {
        int success = 0;
        Spell spell = SpellArgumentType.getSpell(ctx, "spell");
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        for (class_1297 class_12972 : entities) {
            class_1309 living;
            class_1799 stack;
            if (!(class_12972 instanceof class_1309) || !((stack = (living = (class_1309)class_12972).method_6047()).method_7909() instanceof ItemStaffBase)) continue;
            Platform.INSTANCE.getStaffData(stack).ifPresent(data -> {
                switch (tier) {
                    case 3: {
                        data.setTier3Spell(spell);
                        break;
                    }
                    case 2: {
                        data.setTier2Spell(spell);
                        break;
                    }
                    default: {
                        data.setTier1Spell(spell);
                    }
                }
            });
            ++success;
        }
        return success;
    }
}

