/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class RecipeBuilder {
    private final class_1799 result;
    private final int level;
    private final int addCost;
    private final List<class_1856> ingredients = new ArrayList<class_1856>();
    private final class_1865<?> serializer;
    private final EnumCrafting type;
    private String group;

    private RecipeBuilder(EnumCrafting type, class_1799 item, int level, int addCost, class_1865<?> serializer) {
        this.type = type;
        this.result = item;
        this.level = level;
        this.addCost = addCost;
        this.serializer = serializer;
    }

    public static RecipeBuilder create(EnumCrafting type, class_1935 item, int level) {
        return RecipeBuilder.create(type, item, 1, level);
    }

    public static RecipeBuilder create(EnumCrafting type, class_1935 item, int count, int level) {
        return RecipeBuilder.create(type, new class_1799(item, count), level, 1);
    }

    public static RecipeBuilder create(EnumCrafting type, class_1935 item, int count, int level, int addCost) {
        return RecipeBuilder.create(type, new class_1799(item, count), level, addCost);
    }

    public static RecipeBuilder create(EnumCrafting type, class_1799 item, int level, int addCost) {
        class_1865 serializer = switch (type) {
            case EnumCrafting.FORGE -> (class_1865)ModCrafting.FORGING_SERIALIZER.get();
            case EnumCrafting.ARMOR -> (class_1865)ModCrafting.ARMOR_SERIALIZER.get();
            case EnumCrafting.CHEM -> (class_1865)ModCrafting.CHEMISTRY_SERIALIZER.get();
            default -> (class_1865)ModCrafting.COOKING_SERIALIZER.get();
        };
        return new RecipeBuilder(type, item, level, addCost, serializer);
    }

    public RecipeBuilder addIngredient(class_6862<class_1792> tag) {
        return this.addIngredient(class_1856.method_8106(tag));
    }

    public RecipeBuilder addIngredient(class_1935 item) {
        return this.addIngredient(item, 1);
    }

    public RecipeBuilder addIngredient(class_1935 item, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
        return this;
    }

    public RecipeBuilder addIngredient(class_1856 ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public RecipeBuilder addIngredient(class_1856 ingredient, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public RecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<class_2444> cons) {
        this.build(cons, class_2378.field_11142.method_10221((Object)this.result.method_7909()));
    }

    public void build(Consumer<class_2444> cons, String string) {
        this.build(cons, new class_2960(string));
    }

    public void build(Consumer<class_2444> cons, class_2960 res) {
        this.validate(res);
        cons.accept(new Result(new class_2960(res.method_12836(), this.type.getId() + "/" + res.method_12832()), this.result, this.level, this.addCost, this.group == null ? "" : this.group, this.ingredients){

            @Override
            public class_1865<?> method_17800() {
                return RecipeBuilder.this.serializer;
            }
        });
    }

    private void validate(class_2960 res) {
        if (this.ingredients.size() > 6) {
            throw new IllegalStateException("Recipe " + String.valueOf(res) + " too big. Max size is 6");
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1799 result;
        private final int level;
        private final int cost;
        private final String group;
        private final List<class_1856> ingredients;

        public Result(class_2960 res, class_1799 output, int level, int cost, String group, List<class_1856> ingredients) {
            this.id = res;
            this.result = output;
            this.level = level;
            this.cost = cost;
            this.group = group;
            this.ingredients = ingredients;
        }

        public void method_10416(JsonObject obj) {
            if (!this.group.isEmpty()) {
                obj.addProperty("group", this.group);
            }
            obj.addProperty("level", (Number)this.level);
            obj.addProperty("additional_cost", (Number)this.cost);
            JsonArray jsonarray = new JsonArray();
            for (class_1856 ingredient : this.ingredients) {
                jsonarray.add(ingredient.method_8089());
            }
            obj.add("ingredients", (JsonElement)jsonarray);
            obj.add("result", this.itemStackToJson(this.result));
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return class_1865.field_9031;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }

        private JsonElement itemStackToJson(class_1799 stack) {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", class_2378.field_11142.method_10221((Object)stack.method_7909()).toString());
            if (stack.method_7947() > 1) {
                obj.addProperty("count", (Number)stack.method_7947());
            }
            if (stack.method_7985()) {
                class_2487.field_25128.encode((Object)stack.method_7969(), (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).result().ifPresent(e -> obj.add("nbt", e));
            }
            return obj;
        }
    }
}

