/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public abstract class SextupleRecipe
implements class_1860<PlayerContainerInv> {
    private final class_2960 id;
    private final String group;
    private final class_1799 recipeOutput;
    private final class_2371<class_1856> recipeItems;
    private final int craftingLevel;
    private final int baseCost;

    public SextupleRecipe(class_2960 id, String group, int level, int baseCost, class_1799 result, class_2371<class_1856> ingredients) {
        this.id = id;
        this.group = group;
        this.recipeOutput = result;
        this.recipeItems = ingredients;
        this.craftingLevel = level;
        this.baseCost = baseCost;
    }

    public boolean matches(PlayerContainerInv inv, class_1937 world) {
        return this.checkMatch(inv, world, false);
    }

    public boolean checkMatch(PlayerContainerInv inv, class_1937 world, boolean exact) {
        if (inv.method_5439() < 6) {
            return false;
        }
        boolean unlocked = Platform.INSTANCE.getPlayerData(inv.getPlayer()).map(cap -> cap.getRecipeKeeper().isUnlockedForCrafting(this)).orElse(false);
        if (!unlocked) {
            return false;
        }
        class_2371 stacks = class_2371.method_10211();
        for (int j = 0; j < 6; ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (itemStack.method_7960()) continue;
            stacks.add((Object)itemStack);
        }
        Pair<class_2371<class_1799>, class_2371<class_1799>> result = SextupleRecipe.matchingStacks(this, (class_2371<class_1799>)stacks);
        int matches = ((class_2371)result.getFirst()).size();
        if (matches != this.method_8117().size()) {
            return false;
        }
        return !exact || ((class_2371)result.getSecond()).isEmpty();
    }

    public class_1799 assemble(PlayerContainerInv inv) {
        return this.getCraftingOutput(inv).serverResult();
    }

    public RecipeOutput getCraftingOutput(PlayerContainerInv inv) {
        if (inv.method_5439() < 6) {
            return new RecipeOutput(class_1799.field_8037, class_1799.field_8037, (class_2371<class_1799>)class_2371.method_10211());
        }
        boolean unlocked = Platform.INSTANCE.getPlayerData(inv.getPlayer()).map(cap -> cap.getRecipeKeeper().isUnlocked(this)).orElse(false);
        class_2371 stacks = class_2371.method_10211();
        for (int j = 0; j < 6; ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (itemStack.method_7960()) continue;
            stacks.add((Object)itemStack);
        }
        Pair<class_2371<class_1799>, class_2371<class_1799>> ing = SextupleRecipe.matchingStacks(this, (class_2371<class_1799>)stacks);
        EnumCrafting type = EnumCrafting.FORGE;
        if (this.method_17716() == ModCrafting.ARMOR.get()) {
            type = EnumCrafting.ARMOR;
        }
        if (this.method_17716() == ModCrafting.CHEMISTRY.get()) {
            type = EnumCrafting.CHEM;
        }
        if (this.method_17716() == ModCrafting.COOKING.get()) {
            type = EnumCrafting.COOKING;
        }
        class_1799 trueOutput = CraftingUtils.getCraftingOutput(this.recipeOutput.method_7972(), inv, ing, type);
        return new RecipeOutput(trueOutput, unlocked ? trueOutput : new class_1799((class_1935)ModItems.UNKNOWN.get()), (class_2371<class_1799>)((class_2371)ing.getSecond()));
    }

    public static Pair<class_2371<class_1799>, class_2371<class_1799>> matchingStacks(SextupleRecipe recipe, class_2371<class_1799> inv) {
        if (inv.size() > 6) {
            return Pair.of((Object)class_2371.method_10211(), (Object)class_2371.method_10211());
        }
        for (class_1799 s : inv) {
            if (recipe.areItemsFitting(s)) continue;
            return Pair.of((Object)class_2371.method_10211(), (Object)class_2371.method_10211());
        }
        class_2371 list = class_2371.method_10211();
        class_2371 bonus = class_2371.method_10211();
        block1: for (class_1856 ing : recipe.method_8117()) {
            for (class_1799 stack : inv) {
                if (!ing.method_8093(stack) || list.contains((Object)stack)) continue;
                list.add((Object)stack);
                continue block1;
            }
        }
        for (class_1799 stack : inv) {
            if (list.contains((Object)stack)) continue;
            bonus.add((Object)stack);
        }
        return Pair.of((Object)list, (Object)bonus);
    }

    public boolean areItemsFitting(class_1799 stack) {
        return true;
    }

    public boolean method_8113(int x, int y) {
        return x * y > this.recipeItems.size();
    }

    public class_1799 method_8110() {
        return this.recipeOutput.method_7972();
    }

    public class_2371<class_1856> method_8117() {
        return this.recipeItems;
    }

    public String method_8112() {
        return this.group;
    }

    public abstract class_1799 method_17447();

    public class_2960 method_8114() {
        return this.id;
    }

    public abstract class_1865<?> method_8119();

    public abstract class_3956<?> method_17716();

    public int getCraftingLevel() {
        return this.craftingLevel;
    }

    public int getAdditionalCost() {
        return this.baseCost;
    }

    public String toString() {
        return String.format("Result: %s; Required Level: %d; ID: %s", this.recipeOutput, this.craftingLevel, this.id);
    }

    public record RecipeOutput(class_1799 serverResult, class_1799 clientResult, class_2371<class_1799> bonusItems) {
    }

    public static abstract class Serializer<T extends SextupleRecipe>
    extends CustomRegistryEntry<Serializer<T>>
    implements class_1865<T> {
        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public T fromJson(class_2960 res, JsonObject obj) {
            String s = class_3518.method_15253((JsonObject)obj, (String)"group", (String)"");
            class_2371<class_1856> nonnulllist = Serializer.readIngredients(class_3518.method_15261((JsonObject)obj, (String)"ingredients"));
            int level = class_3518.method_15282((JsonObject)obj, (String)"level", (int)1);
            int baseCost = class_3518.method_15282((JsonObject)obj, (String)"additional_cost", (int)1);
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 6) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 6");
            }
            class_1799 itemstack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)obj, (String)"result"));
            return this.get(res, s, level, baseCost, itemstack, nonnulllist);
        }

        public T fromNetwork(class_2960 res, class_2540 buffer) {
            int level = buffer.readInt();
            int cost = buffer.readInt();
            String s = buffer.method_10800(Short.MAX_VALUE);
            int i = buffer.method_10816();
            class_2371 nonnulllist = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            nonnulllist.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 itemstack = buffer.method_10819();
            return this.get(res, s, level, cost, itemstack, (class_2371<class_1856>)nonnulllist);
        }

        public void toNetwork(class_2540 buffer, T recipe) {
            buffer.writeInt(((SextupleRecipe)recipe).getCraftingLevel());
            buffer.writeInt(((SextupleRecipe)recipe).getAdditionalCost());
            buffer.method_10814(((SextupleRecipe)recipe).method_8112());
            buffer.method_10804(((SextupleRecipe)recipe).method_8117().size());
            for (class_1856 ingredient : ((SextupleRecipe)recipe).method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(((SextupleRecipe)recipe).method_8110());
        }

        public abstract T get(class_2960 var1, String var2, int var3, int var4, class_1799 var5, class_2371<class_1856> var6);
    }
}

