/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.utils.MiscUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CropManager
extends class_4309 {
    public static final String DIRECTORY = "crop_properties";
    private Map<class_1792, CropProperties> crops = ImmutableMap.of();
    private boolean resolved;
    private Map<class_6862<class_1792>, CropProperties> tagCrops = ImmutableMap.of();

    public CropManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    @Nullable
    public CropProperties get(class_1792 item) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.crops.get(item);
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap<class_1792, CropProperties> itemEntries = new HashMap<class_1792, CropProperties>(this.crops);
            this.tagCrops.entrySet().stream().sorted(Comparator.comparing(e -> ((class_6862)e.getKey()).comp_327())).forEach(entry -> MiscUtils.expandTag(class_2378.field_11142, (class_6862)entry.getKey()).forEach(item -> {
                if (!itemEntries.containsKey(item)) {
                    itemEntries.put((class_1792)item, (CropProperties)entry.getValue());
                }
            }));
            this.crops = ImmutableMap.copyOf(itemEntries);
        }
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.resolved = false;
        ImmutableMap.Builder itemEntries = ImmutableMap.builder();
        ImmutableMap.Builder tagEntries = ImmutableMap.builder();
        data.forEach((fres, el) -> {
            try {
                JsonObject obj = el.getAsJsonObject();
                String key = class_3518.method_15265((JsonObject)obj, (String)"item");
                if (key.startsWith("#")) {
                    class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(key.substring(1)));
                    CropProperties props = (CropProperties)CropProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                    props.setID((class_2960)fres);
                    tagEntries.put((Object)tag, (Object)props);
                } else {
                    class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(key));
                    if (item != class_1802.field_8162) {
                        CropProperties props = (CropProperties)CropProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                        props.setID((class_2960)fres);
                        itemEntries.put((Object)item, (Object)props);
                    }
                }
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldn't parse crop properties json {} {}", fres, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.crops = itemEntries.build();
        this.tagCrops = tagEntries.build();
    }

    public void toPacket(class_2540 buffer) {
        this.resolveTags(false);
        buffer.writeInt(this.crops.size());
        this.crops.forEach((item, prop) -> {
            buffer.method_10812(class_2378.field_11142.method_10221(item));
            prop.toPacket(buffer);
        });
    }

    public void fromPacket(class_2540 buffer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)((class_1792)class_2378.field_11142.method_10223(buffer.method_10810())), (Object)CropProperties.fromPacket(buffer));
        }
        this.crops = builder.build();
    }
}

