/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GateSpawnData;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2048;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3486;
import net.minecraft.class_3695;
import net.minecraft.class_4076;
import net.minecraft.class_4309;
import net.minecraft.class_5312;
import net.minecraft.class_5425;
import net.minecraft.class_5458;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;

public class GateSpawnsManager
extends class_4309 {
    public static final String DIRECTORY = "gate_spawning";
    private Map<class_6862<class_1959>, List<SpawnResource>> biomeSpawns = new HashMap<class_6862<class_1959>, List<SpawnResource>>();
    private Map<class_5312<?, ?>, List<SpawnResource>> structureSpawns = new HashMap();

    public GateSpawnsManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public List<class_1299<?>> pickRandomMobs(class_3218 level, GateEntity gate, class_6880<class_1959> biome, Random rand, int amount, class_2338 pos, List<class_3222> players) {
        List<SpawnResource> list = level.method_27056().method_41035(class_4076.method_18682((class_2338)pos), this.structureSpawns::containsKey).stream().filter(start -> start.method_14969().method_14662((class_2382)pos)).map(start -> this.structureSpawns.get(start.method_16656())).flatMap(Collection::stream).collect(Collectors.toList());
        if (list.isEmpty()) {
            biome.method_40228().forEach(tag -> {
                List<SpawnResource> l = this.biomeSpawns.get(tag);
                if (l != null) {
                    list.addAll(l);
                }
            });
        }
        list.removeIf(w -> w.playerPredicate != class_2048.field_9599 && players.stream().noneMatch(p -> w.playerPredicate.method_8914(p, (class_1297)p)));
        if (list.isEmpty()) {
            return new ArrayList();
        }
        double dist = pos.method_10262((class_2382)level.method_27911());
        class_2680 state = level.method_8320(pos);
        list.removeIf(w -> !w.matches(level, pos, state, dist, gate));
        ArrayList ret = new ArrayList();
        if (amount > list.size()) {
            list.forEach(w -> ret.add(w.entity));
        } else {
            class_1299 type;
            int totalWeight = class_6011.method_34984(list);
            for (int i = amount; i > 0 && !ret.contains(type = (class_1299)class_6011.method_34987((Random)rand, list, (int)totalWeight).map(w -> w.entity).orElse(null)); --i) {
                if (type == null) continue;
                ret.add(type);
            }
        }
        return ret;
    }

    public boolean hasSpawns(class_5425 level, class_2338 pos, class_2680 state) {
        if (level.method_23753(pos).method_40228().anyMatch(t -> {
            List<SpawnResource> l = this.biomeSpawns.get(t);
            return l != null && l.stream().anyMatch(r -> r.canSpawn(level.method_8410(), pos, state));
        })) {
            return true;
        }
        return this.hasStructureSpawns(level.method_8410(), pos);
    }

    public boolean hasStructureSpawns(class_3218 world, class_2338 pos) {
        return world.method_27056().method_41035(class_4076.method_18682((class_2338)pos), this.structureSpawns::containsKey).stream().anyMatch(start -> start.method_14969().method_14662((class_2382)pos));
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        LinkedHashMap biomeSpawns = new LinkedHashMap();
        LinkedHashMap structureSpawns = new LinkedHashMap();
        data.forEach((fres, el) -> {
            try {
                GateSpawnData spawnData = (GateSpawnData)GateSpawnData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                Optional optType = class_2378.field_11145.method_17966(spawnData.entity());
                optType.ifPresentOrElse(type -> {
                    spawnData.biomes().forEach((key, weight) -> {
                        SpawnResource resource = new SpawnResource((class_1299<?>)type, spawnData, (int)weight);
                        biomeSpawns.computeIfAbsent(key, o -> new ArrayList()).add(resource);
                    });
                    spawnData.structures().forEach((key, weight) -> {
                        Optional optFeat = class_5458.field_25930.method_17966(key);
                        optFeat.ifPresentOrElse(feat -> {
                            SpawnResource resource = new SpawnResource((class_1299<?>)type, spawnData, (int)weight);
                            structureSpawns.computeIfAbsent(feat, o -> new ArrayList()).add(resource);
                        }, () -> RuneCraftory.LOGGER.error("No such feature {} for spawn data {}", key, fres));
                    });
                }, () -> RuneCraftory.LOGGER.error("No such entity {} for spawn data {}", (Object)spawnData.entity(), fres));
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldnt parse spawn data json {} {}", fres, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.biomeSpawns = ImmutableMap.copyOf(biomeSpawns);
        this.structureSpawns = ImmutableMap.copyOf(structureSpawns);
    }

    public static class SpawnResource
    extends class_6008.class_6009 {
        private final class_1299<?> entity;
        private final int distToSpawnSq;
        private final int minGateLevel;
        private final boolean allowWater;
        private final class_2048 gatePredicate;
        private final class_2048 playerPredicate;

        public SpawnResource(class_1299<?> entity, GateSpawnData spawnData, int weight) {
            super(weight);
            this.entity = entity;
            this.distToSpawnSq = spawnData.minDistanceFromSpawn() * spawnData.minDistanceFromSpawn();
            this.minGateLevel = spawnData.minGateLevel();
            this.allowWater = spawnData.canSpawnInWater();
            this.gatePredicate = spawnData.gatePredicate();
            this.playerPredicate = spawnData.playerPredicate();
        }

        public boolean canSpawn(class_3218 serverLevel, class_2338 pos, class_2680 state) {
            return pos.method_10262((class_2382)serverLevel.method_27911()) >= (double)this.distToSpawnSq && (state.method_26227().method_15769() || this.allowWater && state.method_26227().method_15767(class_3486.field_15517) && serverLevel.method_22348(pos));
        }

        public boolean matches(class_3218 serverLevel, class_2338 pos, class_2680 state, double dist, GateEntity gate) {
            return dist >= (double)this.distToSpawnSq && (state.method_26227().method_15769() || this.allowWater && state.method_26227().method_15767(class_3486.field_15517) && serverLevel.method_22348(pos)) && gate.level().getLevel() >= this.minGateLevel && this.gatePredicate.method_8909(serverLevel, gate.method_19538(), (class_1297)gate);
        }

        public String toString() {
            return String.format("Entity: %s, MinSpawnSq: %d, Weight: %s, MinGateLevel: %s", class_2378.field_11145.method_10221(this.entity), this.distToSpawnSq, this.method_34979(), this.minGateLevel);
        }
    }
}

