/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.ModCrafting;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_3956;
import net.minecraft.server.MinecraftServer;

public class ItemCraftingLevelManager {
    private static Map<class_1792, Pair<Integer, EnumSkills>> craftingLevelCache;

    public static void reload(MinecraftServer server) {
        craftingLevelCache = new HashMap<class_1792, Pair<Integer, EnumSkills>>();
        ItemCraftingLevelManager.add(server.method_3772().method_30027((class_3956)ModCrafting.FORGE.get()), EnumSkills.FORGING);
        ItemCraftingLevelManager.add(server.method_3772().method_30027((class_3956)ModCrafting.CHEMISTRY.get()), EnumSkills.CHEMISTRY);
        ItemCraftingLevelManager.add(server.method_3772().method_30027((class_3956)ModCrafting.ARMOR.get()), EnumSkills.CRAFTING);
        ItemCraftingLevelManager.add(server.method_3772().method_30027((class_3956)ModCrafting.COOKING.get()), EnumSkills.COOKING);
    }

    private static void add(Collection<SextupleRecipe> recipes, EnumSkills skills) {
        for (SextupleRecipe recipe : recipes) {
            craftingLevelCache.compute(recipe.method_8110().method_7909(), (item, old) -> {
                if (old != null && (Integer)old.getFirst() <= recipe.getCraftingLevel()) {
                    return old;
                }
                return Pair.of((Object)recipe.getCraftingLevel(), (Object)((Object)skills));
            });
        }
    }

    public static Pair<Integer, EnumSkills> getLowestLevel(MinecraftServer server, class_1792 item) {
        if (craftingLevelCache == null) {
            ItemCraftingLevelManager.reload(server);
        }
        return craftingLevelCache.get(item);
    }

    public static void reset() {
        craftingLevelCache = null;
    }
}

