/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.SkillProperties;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.logging.log4j.Logger;

public class SkillPropertiesManager
extends class_4080<Map<class_2960, JsonElement>> {
    public static final String DIRECTORY = "skills";
    private Map<EnumSkills, SkillProperties> propertiesMap = new EnumMap<EnumSkills, SkillProperties>(EnumSkills.class);

    public SkillProperties getPropertiesFor(EnumSkills skills) {
        return this.propertiesMap.getOrDefault((Object)skills, SkillProperties.DEFAULT);
    }

    protected Map<class_2960, JsonElement> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap map = Maps.newHashMap();
        int i = DIRECTORY.length() + 1;
        for (class_2960 resourceLocation : resourceManager.method_14488(DIRECTORY, string -> string.endsWith(".json"))) {
            if (!resourceLocation.method_12836().equals("runecraftory")) continue;
            String path = resourceLocation.method_12832();
            path = path.substring(i, path.length() - ".json".length());
            class_2960 res = new class_2960(resourceLocation.method_12836(), path);
            try {
                class_3298 resource = resourceManager.method_14486(resourceLocation);
                try {
                    InputStream inputStream = resource.method_14482();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonElement element = (JsonElement)class_3518.method_15276((Gson)GsonInstances.GSON, (Reader)reader, JsonElement.class);
                        if (element == null) continue;
                        map.put(res, element);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RuneCraftory.LOGGER.error("Couldn't parse data file {} {}", (Object)res, (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        EnumMap<EnumSkills, SkillProperties> propertiesBuilder = new EnumMap<EnumSkills, SkillProperties>(EnumSkills.class);
        data.forEach((key, el) -> {
            try {
                SkillProperties props = (SkillProperties)SkillProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                EnumSkills skills = EnumSkills.valueOf(key.method_12832().toUpperCase(Locale.ROOT));
                propertiesBuilder.put(skills, props);
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldnt parse skill properties json {} {}", key, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        ArrayList<EnumSkills> missing = new ArrayList<EnumSkills>();
        for (EnumSkills skill : EnumSkills.values()) {
            if (propertiesBuilder.containsKey((Object)skill)) continue;
            missing.add(skill);
        }
        if (!missing.isEmpty()) {
            throw new IllegalStateException("Some skills are missing their properties. " + String.valueOf(missing));
        }
        this.propertiesMap = propertiesBuilder;
    }
}

