/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class StructureBossManager
extends class_4309 {
    public static final String DIRECTORY = "runecraftory_bosses";
    private Map<class_2960, BossSpawnList> spawnList = new HashMap<class_2960, BossSpawnList>();

    public StructureBossManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    @Nullable
    public BossSpawnList getBoss(class_2960 id) {
        return this.spawnList.get(id);
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        data.forEach((key, el) -> {
            try {
                BossSpawnList list = (BossSpawnList)BossSpawnList.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                builder.put(key, (Object)list);
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldn't parse boss spawn list json {} {}", key, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.spawnList = builder.build();
    }

    public static class BossSpawnList {
        public static final Codec<BossSpawnList> CODEC = class_6005.method_34972((Codec)class_2378.field_11145.method_39673()).xmap(BossSpawnList::new, b -> b.list);
        private final class_6005<class_1299<?>> list;
        private final Set<class_1299<?>> direct;

        public BossSpawnList(class_6005<class_1299<?>> list) {
            this.list = list;
            this.direct = this.list.method_34994().stream().map(class_6008.class_6010::method_34983).collect(Collectors.toUnmodifiableSet());
        }

        public static BossSpawnList of(class_1299<?> type) {
            return new BossSpawnList(class_6005.method_38061(type));
        }

        public Optional<class_1299<?>> getRandom(Random random) {
            return this.list.method_34973(random);
        }

        public boolean has(class_1299<?> type) {
            return this.direct.contains(type);
        }
    }
}

