/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.actions.NPCAttackActions;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.Logger;

public class NPCActionManager
extends class_4309 {
    public static final String DIRECTORY = "npc_actions";
    public static final class_2960 DEFAULT_ID = new class_2960("runecraftory", "default_action");
    private Map<class_2960, NPCAttackActions> keyData = ImmutableMap.of();
    private Map<NPCAttackActions, class_2960> dataKey = ImmutableMap.of();
    private List<NPCAttackActions> actions = List.of();

    public NPCActionManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public NPCAttackActions get(class_2960 res) {
        return this.keyData.getOrDefault(res, NPCAttackActions.DEFAULT);
    }

    public class_2960 getId(NPCAttackActions data) {
        return this.dataKey.getOrDefault(data, DEFAULT_ID);
    }

    public NPCAttackActions getRandom(Random random) {
        if (this.actions.isEmpty()) {
            return NPCAttackActions.DEFAULT;
        }
        return this.actions.get(random.nextInt(this.actions.size()));
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((fres, el) -> {
            if (!fres.equals((Object)DEFAULT_ID)) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    builder.put(fres, (Object)((NPCAttackActions)NPCAttackActions.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
                }
                catch (Exception ex) {
                    RuneCraftory.LOGGER.error("Couldnt parse npc actions json {} {}", fres, (Object)ex);
                    ex.fillInStackTrace();
                }
            }
        });
        this.keyData = builder.build();
        ImmutableMap.Builder reverse = ImmutableMap.builder();
        this.keyData.forEach((resourceLocation, data) -> reverse.put(data, resourceLocation));
        this.dataKey = reverse.build();
        this.actions = this.keyData.values().stream().toList();
    }
}

