/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.WeightedList;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class NPCDataManager
extends class_4309 {
    public static final String DIRECTORY = "npc_data";
    public static final class_2960 DEFAULT_ID = new class_2960("runecraftory", "default_npc");
    private Map<class_2960, NPCData> keyData = ImmutableMap.of();
    private Map<NPCData, class_2960> dataKey = ImmutableMap.of();
    private final WeightedList<NPCData> view = new WeightedList();
    private final WeightedList<NPCData> viewNoJobDef = new WeightedList();

    public NPCDataManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public NPCData get(class_2960 res) {
        return this.keyData.getOrDefault(res, NPCData.DEFAULT_DATA);
    }

    public boolean has(class_2960 res) {
        return this.keyData.containsKey(res);
    }

    public class_2960 getId(NPCData data) {
        return this.dataKey.getOrDefault(data, DEFAULT_ID);
    }

    public NPCData getRandom(Random random, Predicate<NPCData> func, @Nullable Predicate<NPCData> other) {
        return this.view.getRandom(random, NPCData.DEFAULT_DATA, func, other);
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((fres, el) -> {
            if (!fres.equals((Object)DEFAULT_ID)) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    builder.put(fres, (Object)((NPCData)NPCData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(true, s -> RuneCraftory.LOGGER.error("NPC: {} - {}", fres, s))));
                }
                catch (Exception ex) {
                    RuneCraftory.LOGGER.error("Couldnt parse npc data json {} {}", fres, (Object)ex);
                    ex.fillInStackTrace();
                }
            }
        });
        this.keyData = builder.build();
        ImmutableMap.Builder reverse = ImmutableMap.builder();
        this.keyData.forEach((resourceLocation, data) -> reverse.put(data, resourceLocation));
        this.dataKey = reverse.build();
        this.view.setList(this.keyData.values().stream().map(d -> class_6008.method_34980((Object)d, (int)d.weight())).toList());
        this.viewNoJobDef.setList(this.keyData.values().stream().filter(d -> d.profession().isEmpty()).map(d -> class_6008.method_34980((Object)d, (int)d.weight())).toList());
    }
}

