/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.Logger;

public class NPCLookManager
extends class_4309 {
    public static final String DIRECTORY = "npc_looks";
    public static final class_2960 DEFAULT_ID = new class_2960("runecraftory", "default_look");
    private Map<class_2960, NPCLook> keyData = ImmutableMap.of();
    private Map<NPCLook, class_2960> dataKey = ImmutableMap.of();
    private List<NPCLook> selectable = ImmutableList.of();

    public NPCLookManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public NPCLook get(class_2960 res) {
        return this.keyData.getOrDefault(res, NPCLook.DEFAULT_LOOK);
    }

    public class_2960 getId(NPCLook data) {
        return this.dataKey.getOrDefault(data, DEFAULT_ID);
    }

    public NPCLook getRandom(Random random, boolean male) {
        if (this.selectable.isEmpty()) {
            return NPCLook.DEFAULT_LOOK;
        }
        List<NPCLook> looks = this.selectable.stream().filter(l -> l.gender() == NPCData.Gender.UNDEFINED || l.gender() == (male ? NPCData.Gender.MALE : NPCData.Gender.FEMALE)).toList();
        if (looks.isEmpty()) {
            return NPCLook.DEFAULT_LOOK;
        }
        return looks.get(random.nextInt(looks.size()));
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((fres, el) -> {
            if (!fres.equals((Object)DEFAULT_ID)) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    builder.put(fres, (Object)((NPCLook)NPCLook.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
                }
                catch (Exception ex) {
                    RuneCraftory.LOGGER.error("Couldnt parse npc look json {} {}", fres, (Object)ex);
                    ex.fillInStackTrace();
                }
            }
        });
        builder.put((Object)NPCLook.DEFAULT_LOOK_ID, (Object)NPCLook.DEFAULT_LOOK);
        this.keyData = builder.build();
        ImmutableMap.Builder reverse = ImmutableMap.builder();
        this.keyData.forEach((resourceLocation, data) -> reverse.put(data, resourceLocation));
        this.dataKey = reverse.build();
        ImmutableList.Builder selectable = ImmutableList.builder();
        this.keyData.entrySet().stream().filter(e -> ((NPCLook)e.getValue()).weight() > 0).forEach(e -> selectable.add((Object)((NPCLook)e.getValue())));
        this.selectable = selectable.build();
    }
}

