/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.ai.FollowOwnerGoalMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.HurtByTargetPredicate;
import io.github.flemmli97.runecraftory.common.entities.ai.LookAtAliveGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.RandomLookGoalAlive;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.RiderAttackTargetGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.StayGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.TendCropsGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.control.MoveControlerEx;
import io.github.flemmli97.runecraftory.common.entities.data.MobUpdateHandler;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.DailyMonsterUpdater;
import io.github.flemmli97.runecraftory.common.entities.utils.ExtendedEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IExtendedMob;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.network.S2COpenCompanionGui;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.TamingTracker;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.mixin.CombatTrackerAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AoeAttackEntity;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1370;
import net.minecraft.class_1379;
import net.minecraft.class_1400;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1839;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_47;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5569;
import net.minecraft.class_5575;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMonster
extends class_1314
implements class_1569,
IAnimated,
IExtendedMob,
ExtendedEntity,
SleepingEntity,
TargetableOpponent,
AoeAttackEntity,
MobUpdateHandler,
MobAttackExt {
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> BEHAVIOUR_DATA = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> PLAY_DEATH_STATE = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FRIEND_POINTS_SYNC = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13327);
    private static boolean TESTING = false;
    public final Predicate<class_1309> targetPred = e -> {
        if (e != this) {
            class_1308 mob;
            if (this.method_5642() instanceof class_1657) {
                return false;
            }
            if (this.isTamed()) {
                return e instanceof class_1569 && EntityUtils.canAttackOwned(e, false, true, this.targetPred);
            }
            if (e instanceof class_1657) {
                return e.method_33190();
            }
            if (e instanceof class_1308 && this == (mob = (class_1308)e).method_5968()) {
                return true;
            }
            return EntityUtils.canMonsterTargetNPC((class_1297)e) || EntityUtils.canAttackOwned(e, false, false, entity -> entity instanceof class_1657 ? entity.method_33190() : this.targetPred.test((class_1309)entity));
        }
        return false;
    };
    public final Predicate<class_1309> defendPred = e -> {
        if (e != this) {
            if (this.method_5642() instanceof class_1657) {
                return false;
            }
            if (this.isTamed()) {
                return !e.method_5667().equals(this.method_6139()) && !this.method_6139().equals(EntityUtils.tryGetOwner(e));
            }
            return true;
        }
        return false;
    };
    private final EntityProperties prop;
    public class_1400<class_1657> targetPlayer = this.createTargetGoalPlayer();
    public class_1400<class_1308> targetMobs = this.createTargetGoalMobs();
    public class_1347 swimGoal = new class_1347((class_1308)this);
    public FollowOwnerGoalMonster followOwnerGoal = new FollowOwnerGoalMonster(this, 1.05, 9.0f, 2.0f, 20.0f);
    public class_1379 wander = new RestrictedWaterAvoidingStrollGoal(this, 1.0);
    public HurtByTargetPredicate hurt = new HurtByTargetPredicate(this, this.defendPred);
    public TendCropsGoal farm = new TendCropsGoal(this);
    private MobAttackExt.TargetPosition targetPosition;
    private class_2338 seedInventory;
    private class_2338 cropInventory;
    public final Predicate<class_1309> hitPred = e -> {
        if (e != this) {
            if (this.method_5626((class_1297)e) || !e.method_33190()) {
                return false;
            }
            if (e instanceof class_1308 && this == ((class_1308)e).method_5968()) {
                return true;
            }
            class_1297 controller = this.method_5642();
            if (this.isTamed()) {
                UUID owner = EntityUtils.tryGetOwner(e);
                if (owner != null && (!this.attackOtherTamedMobs() || owner.equals(this.method_6139()))) {
                    return false;
                }
                if (e == this.method_5968()) {
                    return true;
                }
                if (controller instanceof class_1657) {
                    return true;
                }
                return e instanceof class_1569 || e instanceof class_1308 && ((class_1308)e).method_5968() == this;
            }
            boolean riderTarget = false;
            if (controller != null) {
                class_1308 mob;
                if (controller instanceof BaseMonster) {
                    BaseMonster baseMonster = (BaseMonster)controller;
                    return baseMonster.hitPred.test((class_1309)e);
                }
                riderTarget = controller instanceof class_1308 && e == (mob = (class_1308)controller).method_5968();
            }
            return riderTarget || e == this.method_5968() || EntityUtils.canMonsterTargetNPC((class_1297)e) || EntityUtils.canAttackOwned(e, false, false, this.targetPred) || e instanceof class_1657;
        }
        return false;
    };
    private int playDeathTick;
    private final LevelExpPair levelPair = new LevelExpPair();
    protected int tamingTick = -1;
    private int brushCount;
    private int loveAttCount;
    private Runnable delayedTaming;
    protected int feedTimeOut;
    private boolean doJumping = false;
    private int foodBuffTick;
    private class_1657 owner;
    private int tpCooldown;
    private Behaviour behaviour = Behaviour.WANDER;
    private final LevelExpPair friendlyPoints = new LevelExpPair();
    private final DailyMonsterUpdater updater = new DailyMonsterUpdater(this);
    private BarnData assignedBarn;
    private int moveTick;
    public static final int MOVE_TICK_MAX = 3;
    private boolean initAnim;

    public BaseMonster(class_1299<? extends BaseMonster> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new MoveControlerEx((class_1308)this);
        this.prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(type);
        this.applyAttributes();
        if (!level.field_9236) {
            this.addGoal();
        }
    }

    public static class_5132.class_5133 createAttributes() {
        class_5132.class_5133 map = class_1588.method_26918().method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23718, 1.0);
        for (RegistryEntrySupplier<class_1320> att : ModAttributes.ENTITY_ATTRIBUTES) {
            map.method_26867((class_1320)att.get());
        }
        return map;
    }

    protected void applyAttributes() {
        for (Map.Entry<class_1320, Double> att : this.prop.getBaseValues().entrySet()) {
            class_1324 inst = this.method_5996(att.getKey());
            if (inst == null) continue;
            inst.method_6192(att.getValue().doubleValue());
            if (att.getKey() != class_5134.field_23716) continue;
            this.method_6033(this.method_6063());
        }
    }

    public void addGoal() {
        this.field_6185.method_6277(1, this.targetPlayer);
        this.field_6185.method_6277(2, this.targetMobs);
        this.field_6185.method_6277(0, (class_1352)this.hurt);
        this.field_6185.method_6277(3, (class_1352)new RiderAttackTargetGoal((class_1308)this, 15));
        this.field_6201.method_6277(0, (class_1352)this.swimGoal);
        this.field_6201.method_6277(0, new StayGoal<BaseMonster>(this, StayGoal.CANSTAYMONSTER));
        this.field_6201.method_6277(1, (class_1352)this.followOwnerGoal);
        this.field_6201.method_6277(2, (class_1352)new LookAtAliveGoal((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)this.wander);
        this.field_6201.method_6277(7, (class_1352)new RandomLookGoalAlive((class_1308)this));
    }

    protected void method_20417() {
        boolean flag1 = !(this.method_5854() instanceof class_1690);
        this.field_6201.method_6276(class_1352.class_4134.field_18405, true);
        this.field_6201.method_6276(class_1352.class_4134.field_18407, flag1);
        this.field_6201.method_6276(class_1352.class_4134.field_18406, true);
    }

    private void updateAI(boolean forced, boolean load) {
        if (forced || this.isTamed()) {
            this.method_5942().method_6340();
            if (this.behaviourState() != Behaviour.FARM) {
                this.seedInventory = null;
                this.cropInventory = null;
                if (this.behaviourState() != Behaviour.STAY) {
                    this.field_6185.method_6277(1, this.targetPlayer);
                    this.field_6185.method_6277(2, this.targetMobs);
                    this.field_6185.method_6277(0, (class_1352)this.hurt);
                }
                this.field_6201.method_6280((class_1352)this.farm);
                class_1937 class_19372 = this.field_6002;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    FarmlandHandler.get(serverLevel.method_8503()).removeIrrigationPOI(serverLevel, this.method_5667());
                }
            }
            this.wander.method_6303(120);
            switch (this.behaviourState()) {
                case WANDER_HOME: {
                    if (this.getOwner() == null) break;
                    if (this.findNearestBarn(load)) {
                        this.restrictToBasedOnBehaviour(null, load);
                        class_2338 pos = this.assignedBarn.pos.method_19446();
                        if (this.field_6002.method_27983() == this.assignedBarn.pos.method_19442()) {
                            TeleportSpell.safeTeleportTo((class_1297)this, pos.method_10263(), pos.method_10264(), pos.method_10260());
                        } else {
                            class_3218 serverLevel = this.method_5682().method_3847(this.assignedBarn.pos.method_19442());
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((class_1297)this, serverLevel, pos.method_10263(), pos.method_10264(), pos.method_10260());
                            }
                        }
                    } else {
                        if (this.field_6012 > 20) {
                            this.getOwner().method_9203((class_2561)new class_2588("runecraftory.monster.interact.barn.no.ext", new Object[]{this.method_5476(), this.method_24515().method_23854()}), class_156.field_25140);
                        }
                        this.setBehaviour(Behaviour.WANDER);
                    }
                    this.field_6201.method_6277(6, (class_1352)this.wander);
                    this.wander.method_6303(40);
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((class_1297)this));
                    break;
                }
                case FOLLOW: {
                    boolean party;
                    boolean bl = party = this.getOwner() == null || Platform.INSTANCE.getPlayerData(this.getOwner()).map(d -> !d.party.isPartyFull() || d.party.isPartyMember((class_1297)this)).orElse(false) != false;
                    if (!party) break;
                    this.method_35055();
                    this.field_6201.method_6280((class_1352)this.wander);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.addPartyMember((class_1297)this));
                    break;
                }
                case FOLLOW_DISTANCE: {
                    this.method_35055();
                    this.field_6201.method_6280((class_1352)this.wander);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.addPartyMember((class_1297)this));
                    break;
                }
                case STAY: {
                    this.field_6201.method_6277(6, (class_1352)this.wander);
                    this.field_6185.method_6280(this.targetPlayer);
                    this.field_6185.method_6280(this.targetMobs);
                    this.field_6185.method_6280((class_1352)this.hurt);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.addPartyMember((class_1297)this));
                    break;
                }
                case WANDER: {
                    this.restrictToBasedOnBehaviour(this.method_24515(), load);
                    this.field_6201.method_6277(6, (class_1352)this.wander);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((class_1297)this));
                    break;
                }
                case FARM: {
                    this.restrictToBasedOnBehaviour(this.method_24515(), load);
                    this.field_6201.method_6277(3, (class_1352)this.farm);
                    this.field_6185.method_6280(this.targetPlayer);
                    this.field_6185.method_6280(this.targetMobs);
                    this.field_6185.method_6280((class_1352)this.hurt);
                    this.field_6201.method_6280((class_1352)this.wander);
                    class_2338 nearestInv = this.nearestBlockEntityWithInv();
                    this.setSeedInventory(nearestInv);
                    this.setCropInventory(nearestInv);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((class_1297)this));
                }
            }
        }
    }

    public void restrictToBasedOnBehaviour(@Nullable class_2338 pos, boolean keepPos) {
        if (this.behaviourState() == Behaviour.WANDER_HOME && this.assignBarn() && this.field_6002.method_27983() == this.assignedBarn.pos.method_19442()) {
            this.method_18408(this.assignedBarn.pos.method_19446(), this.assignedBarn.getSize() + 1);
        }
        if (pos == null) {
            return;
        }
        if (keepPos) {
            pos = this.method_18412();
        }
        if (this.behaviourState() == Behaviour.FARM) {
            this.method_18408(pos, MobConfig.farmRadius + 3);
            class_1937 class_19372 = this.field_6002;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                FarmlandHandler.get(serverLevel.method_8503()).addIrrigationPOI(serverLevel, this.method_5667(), this.method_24515());
            }
        } else if (this.behaviourState() == Behaviour.WANDER) {
            this.method_18408(pos, 9);
        }
    }

    private class_2338 nearestBlockEntityWithInv() {
        class_2338 blockPos = this.method_18412();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int radius = (int)this.method_18413();
        for (int y = -1; y < 2; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutableBlockPos.method_25504((class_2382)blockPos, x, y, z);
                    if (!Platform.INSTANCE.matchingInventory(this.field_6002.method_8321((class_2338)mutableBlockPos), s -> true)) continue;
                    return mutableBlockPos.method_10062();
                }
            }
        }
        return null;
    }

    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new class_1400((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    protected class_1400<class_1308> createTargetGoalMobs() {
        return new class_1400((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(MOVE_FLAGS, (Object)0);
        this.field_6011.method_12784(BEHAVIOUR_DATA, (Object)0);
        this.field_6011.method_12784(PLAY_DEATH_STATE, (Object)false);
        this.field_6011.method_12784(FRIEND_POINTS_SYNC, (Object)1);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.field_6002.field_9236) {
            if (key.equals(BEHAVIOUR_DATA)) {
                try {
                    this.behaviour = Behaviour.values()[(Integer)this.field_6011.method_12789(BEHAVIOUR_DATA)];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (key.equals(PLAY_DEATH_STATE) && ((Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE)).booleanValue() && !this.getAnimationHandler().hasAnimation()) {
                this.playDeathAnimation(true);
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 10) {
            this.playTameEffect(true);
        } else if (id == 11) {
            this.playTameEffect(false);
        } else if (id == 34) {
            for (int i = 0; i < 5; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11231, this.method_23317() - (double)this.method_17681() * 0.25 + (double)(this.field_5974.nextFloat() * this.method_17681() * 0.25f), this.method_23318() + (double)this.method_17682() + (double)this.field_5974.nextFloat() * 0.3, this.method_23321() - (double)this.method_17681() * 0.25 + (double)(this.field_5974.nextFloat() * this.method_17681() * 0.25f), 0.0, 0.0, 0.0);
            }
        } else if (id == 64) {
            this.field_6002.method_8466((class_2394)class_2398.field_11224, true, this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.3, this.method_23321(), 0.0, 0.0, 0.0);
        } else if (id == 65) {
            this.field_6002.method_8466((class_2394)class_2398.field_11201, true, this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.3, this.method_23321(), 0.0, 0.0, 0.0);
        }
        super.method_5711(id);
    }

    public void method_5773() {
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                if (anim != null) {
                    this.setupAttack((AnimatedAction)anim);
                }
                return false;
            });
            this.initAnim = true;
        }
        super.method_5773();
        class_243 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            float[] clamp = this.targetLookClamp();
            this.method_36456(MathsHelper.rotlerp(this.method_36454(), yxRot[0], clamp[0]));
            this.method_36457(MathsHelper.rotlerp(this.method_36455(), yxRot[1], clamp[1]));
            this.field_6283 = this.method_36454();
            this.field_6241 = this.method_36454();
        }
        this.moveTick = this.getMoveFlag() != MoveType.NONE ? Math.min(3, ++this.moveTick) : Math.max(0, --this.moveTick);
        if (!this.field_6002.field_9236) {
            this.updater.tick();
            if (this.tamingTick > 0 || this.method_5987()) {
                if (this.getMoveFlag() != MoveType.NONE) {
                    this.setMovingFlag(MoveType.NONE);
                    this.method_18799(class_243.field_1353);
                }
                if (this.tamingTick > 0) {
                    --this.tamingTick;
                }
            }
            if (this.tamingTick == 0) {
                if (this.delayedTaming != null) {
                    this.delayedTaming.run();
                    this.delayedTaming = null;
                }
                this.tamingTick = -1;
            }
            if (this.feedTimeOut > 0) {
                --this.feedTimeOut;
            }
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.assignedBarn != null && this.assignedBarn.isInvalidFor(this)) {
                this.assignedBarn = null;
            }
            if (this.isTamed() && this.assignedBarn == null && MobConfig.monsterNeedBarn && this.behaviourState() != Behaviour.STAY) {
                this.setBehaviour(Behaviour.STAY);
            }
            this.handleTestingTick();
        } else if (!this.playDeath() && TendCropsGoal.cantTendToCropsAnymore(this) && this.behaviour == Behaviour.FARM && this.field_6012 % 20 == 0) {
            this.field_6002.method_8406((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.3, this.method_23321(), 0.0, 0.0, 0.0);
        }
        if (this.getAnimationHandler().getAnimation() == null) {
            this.targetPosition = null;
        }
    }

    public void method_6007() {
        super.method_6007();
        this.getAnimationHandler().tick();
        boolean teleported = false;
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_1657 owner;
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (owner = this.getOwner()) != null) {
                serverLevel.method_14178().method_17297(WorldUtils.ENTITY_LOADER, this.method_31476(), 3, (Object)this.method_31476());
                if (owner.field_6002.method_27983() != this.field_6002.method_27983()) {
                    TeleportUtils.safeDimensionTeleport((class_1308)this, (class_3218)owner.field_6002, owner.method_24515());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (owner.method_5858((class_1297)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((class_1308)this, (class_1297)owner);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
        }
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.field_6002.field_9236) {
                if (teleported) {
                    this.method_6025(1.0f);
                }
                if ((double)this.method_6032() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("MobLevel", (class_2520)this.level().save());
        if (this.isTamed()) {
            compound.method_25927("Owner", this.method_6139());
        }
        compound.method_10569("Behaviour", this.behaviourState().ordinal());
        compound.method_10569("FeedTime", this.feedTimeOut);
        if (this.method_18410()) {
            compound.method_10539("Home", new int[]{this.method_18412().method_10263(), this.method_18412().method_10264(), this.method_18412().method_10260(), (int)this.method_18413()});
        }
        compound.method_10569("FoodBuffTick", this.foodBuffTick);
        compound.method_10566("FriendlyPoints", (class_2520)this.friendlyPoints.save());
        compound.method_10566("DailyUpdater", (class_2520)this.updater.save());
        compound.method_10556("PlayDeath", ((Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE)).booleanValue());
        if (this.seedInventory != null) {
            compound.method_10539("SeedInventory", new int[]{this.seedInventory.method_10263(), this.seedInventory.method_10264(), this.seedInventory.method_10260()});
        }
        if (this.cropInventory != null) {
            compound.method_10539("CropInventory", new int[]{this.cropInventory.method_10263(), this.cropInventory.method_10264(), this.cropInventory.method_10260()});
        }
        if (this.assignedBarn != null && !this.assignedBarn.isInvalidFor(this)) {
            class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.assignedBarn.pos).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> compound.method_10566("AssignedBarnLocation", t));
        }
    }

    public void method_5749(class_2487 compound) {
        int[] arr;
        super.method_5749(compound);
        this.levelPair.read((class_2520)compound.method_10562("MobLevel"));
        if (compound.method_10545("Owner")) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(compound.method_25926("Owner")));
        }
        this.feedTimeOut = compound.method_10550("FeedTime");
        if (compound.method_10545("Home")) {
            int[] home = compound.method_10561("Home");
            this.method_18408(new class_2338(home[0], home[1], home[2]), home[3]);
        }
        this.foodBuffTick = compound.method_10550("FoodBuffTick");
        this.friendlyPoints.read((class_2520)compound.method_10562("FriendlyPoints"));
        this.field_6011.method_12778(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel());
        this.updater.read(compound.method_10562("DailyUpdater"));
        this.setPlayDeath(compound.method_10577("PlayDeath"));
        if (compound.method_10545("SeedInventory") && (arr = compound.method_10561("SeedInventory")).length == 3) {
            this.seedInventory = new class_2338(arr[0], arr[1], arr[2]);
        }
        if (compound.method_10545("CropInventory") && (arr = compound.method_10561("CropInventory")).length == 3) {
            this.cropInventory = new class_2338(arr[0], arr[1], arr[2]);
        }
        if (compound.method_10545("AssignedBarnLocation") && this.method_5682() != null) {
            class_4208.field_25066.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)compound.method_10580("AssignedBarnLocation"))).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(p -> {
                this.assignedBarn = WorldHandler.get(this.method_5682()).barnAt((class_4208)p);
            });
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.method_10550("Behaviour")], true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.isTamed();
    }

    public boolean method_17326() {
        return super.method_17326() || this.isTamed();
    }

    public void method_5958() {
        super.method_5958();
        if (!this.method_5956() && this.method_5962().field_6374 != class_1335.class_1336.field_6377 && this.method_18798().method_1027() > 0.004) {
            double d0 = this.method_5962().method_6242();
            MoveType move = d0 > this.sprintSpeedThreshold() ? MoveType.RUN : (d0 <= this.crouchSpeedThreshold() ? MoveType.SNEAK : MoveType.WALK);
            if (this.method_6062()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
            this.updateMoveAnimation();
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.method_5660(false);
            this.method_5728(false);
        }
    }

    public double crouchSpeedThreshold() {
        return 0.6;
    }

    public double sprintSpeedThreshold() {
        return 1.0;
    }

    protected void method_5964(class_1266 difficulty) {
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.method_5964(difficulty);
        this.setLevel(class_3532.method_15340((int)this.level().getLevel(), (int)this.prop.minLevel, (int)10000));
        return spawnData;
    }

    public boolean method_5956() {
        return this.isTamed() && this.rideable() && this.method_5642() instanceof class_1657;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean clientSide = this.field_6002.field_9236;
        class_1799 stack = player.method_5998(hand);
        if (this.isTamed()) {
            if (!player.method_5667().equals(this.method_6139())) {
                if (!clientSide) {
                    player.method_9203((class_2561)new class_2588("runecraftory.monster.interact.notowner"), class_156.field_25140);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (player.method_5715() && stack.method_7909() == class_1802.field_8600) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.field_13987.method_14364((class_2596)new class_2767(class_3417.field_15008, class_3419.field_15254, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f));
                    this.untameEntity();
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (!clientSide && MobConfig.monsterNeedBarn && this.assignedBarn == null && !this.assignBarn()) {
                player.method_9203((class_2561)new class_2588("runecraftory.monster.interact.barn.no", new Object[]{this.method_5476()}), class_156.field_25140);
                return class_1269.field_21466;
            }
            if (stack.method_7909() == ModItems.BRUSH.get()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    int day = WorldUtils.day(this.field_6002);
                    if (this.updater.getLastUpdateBrush() == day) {
                        return class_1269.field_5811;
                    }
                    serverPlayer.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14704, class_3419.field_15254, player.method_23317(), player.method_23318(), player.method_23321(), 0.7f, 1.0f));
                    this.updater.setLastUpdateBrush(day);
                    this.onBrushing();
                    this.increaseFriendPoints(15);
                    this.field_6002.method_8421((class_1297)this, (byte)64);
                    player.method_6104(hand);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (hand == class_1268.field_5808 && !this.playDeath() && player.method_5715()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    EntityUtils.sendAttributesTo((class_1309)this, serverPlayer);
                    Platform.INSTANCE.sendToClient(new S2COpenCompanionGui(this, serverPlayer), serverPlayer);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            return class_1269.field_5811;
        }
        if (player.method_5715() && !stack.method_7960()) {
            if (stack.method_7909() == ModItems.TAME.get()) {
                if (!clientSide) {
                    this.tameEntity(player);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (stack.method_7909() == ModItems.BRUSH.get() && this.method_5805()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (this.tamingTick == -1) {
                        return class_1269.field_5811;
                    }
                    serverPlayer.field_13987.method_14364((class_2596)new class_2767(class_3417.field_14704, class_3419.field_15254, player.method_23317(), player.method_23318(), player.method_23321(), 0.7f, 1.0f));
                    this.brushCount = Math.min(10, this.brushCount + 1);
                    this.tamingTick = 40;
                    this.field_6002.method_8421((class_1297)this, (byte)64);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
        }
        return class_1269.field_5811;
    }

    public void increaseFriendPoints(int xp) {
        boolean leveledUp = this.friendlyPoints.addXP(xp, 10, LevelCalc::friendPointsForNext, () -> this.field_6011.method_12778(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel()));
        if (leveledUp) {
            this.updateFriendPointAttributeBonus();
        }
    }

    private void updateFriendPointAttributeBonus() {
        List<class_1320> increasable = List.of(class_5134.field_23716, class_5134.field_23721, (class_1320)ModAttributes.DEFENCE.get(), (class_1320)ModAttributes.MAGIC.get(), (class_1320)ModAttributes.MAGIC_DEFENCE.get());
        for (class_1320 att : increasable) {
            class_1324 inst = this.method_5996(att);
            if (inst == null) continue;
            double inc = (double)(this.friendlyPoints.getLevel() - 1) * 0.03;
            inst.method_6200(LibConstants.ATTRIBUTE_FRIEND_MOD);
            inst.method_26837(new class_1322(LibConstants.ATTRIBUTE_FRIEND_MOD, "rf.friend.mod", inc, class_1322.class_1323.field_6330));
        }
    }

    public void onBrushing() {
        class_1320 toIncrease = switch (this.field_5974.nextInt(4)) {
            case 1 -> (class_1320)ModAttributes.DEFENCE.get();
            case 2 -> (class_1320)ModAttributes.MAGIC.get();
            case 3 -> (class_1320)ModAttributes.MAGIC_DEFENCE.get();
            default -> class_5134.field_23721;
        };
        class_1324 inst = this.method_5996(toIncrease);
        if (inst != null) {
            class_1322 mod = inst.method_6199(LibConstants.ATTRIBUTE_BRUSH_MOD);
            double inc = 1.0;
            if (mod != null) {
                inc += mod.method_6186();
            }
            inst.method_6200(LibConstants.ATTRIBUTE_BRUSH_MOD);
            inst.method_26837(new class_1322(LibConstants.ATTRIBUTE_BRUSH_MOD, "rf.brush.mod", inc, class_1322.class_1323.field_6328));
        }
    }

    public boolean method_5787() {
        return this.method_5956() && !this.field_6002.field_9236;
    }

    public boolean method_6121(class_1297 entity) {
        return CombatUtils.mobAttack((class_1309)this, entity, this.damageSourceAttack());
    }

    public CustomDamage.Builder damageSourceAttack() {
        return new CustomDamage.Builder((class_1297)this).hurtResistant(5);
    }

    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 25 + diffAdd;
        }
        return this.method_6051().nextInt(20) + 15 + diffAdd;
    }

    public int difficultyCooldown() {
        int diffAdd = 12;
        class_1267 diff = this.field_6002.method_8407();
        if (this.field_6002.method_8407() == class_1267.field_5807) {
            diffAdd = 0;
        } else if (diff == class_1267.field_5802) {
            diffAdd = 7;
        }
        return diffAdd;
    }

    @Override
    public class_6862<class_1792> tamingItem() {
        return RunecraftoryTags.tamingTag(this.method_5864());
    }

    public class_2960 dailyDropTable() {
        class_2960 def = this.method_5991();
        return new class_2960(def.method_12836(), def.method_12832() + "_tamed_drops");
    }

    @Override
    public float tamingChance() {
        return this.prop.tamingChance;
    }

    @Override
    public boolean isTamed() {
        return this.method_6139() != null;
    }

    @Override
    public boolean rideable() {
        return this.prop.rideable;
    }

    public boolean attackOtherTamedMobs() {
        return false;
    }

    public EntityProperties getProp() {
        return this.prop;
    }

    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public class_1657 getOwner() {
        UUID uuid = this.method_6139();
        if (uuid != null) {
            if (this.owner == null || !this.owner.method_5805()) {
                this.owner = this.field_6002.field_9236 ? this.field_6002.method_18470(uuid) : this.field_6002.method_8503().method_3760().method_14602(uuid);
            }
        } else {
            this.owner = null;
        }
        return this.owner;
    }

    @Override
    public void setOwner(class_1657 player) {
        if (player != null) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(player.method_5667()));
        } else {
            this.field_6011.method_12778(OWNER_UUID, Optional.empty());
        }
    }

    @Override
    public boolean isFlyingEntity() {
        return this.prop.flying;
    }

    @Override
    public LevelExpPair level() {
        return this.levelPair;
    }

    @Override
    public void setLevel(int level) {
        this.levelPair.setLevel(class_3532.method_15340((int)level, (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void method_5837(class_3222 player) {
        Platform.INSTANCE.sendToClient(S2CEntityLevelPkt.create(this), player);
    }

    @Override
    public int baseXP() {
        return this.prop.xp;
    }

    @Override
    public int baseMoney() {
        return this.prop.money;
    }

    @Override
    public boolean applyFoodEffect(class_1799 stack) {
        FoodProperties food;
        if (this.field_6002.field_9236) {
            return false;
        }
        if (stack.method_7909() == ModItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((class_1309)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909())) == null) {
            class_4174 mcFood = stack.method_7909().method_19264();
            this.method_18866(this.field_6002, stack);
            if (mcFood != null) {
                this.method_6025((float)mcFood.method_19230() * 0.5f);
                return true;
            }
            return false;
        }
        this.method_18866(this.field_6002, stack);
        Pair<Map<class_1320, Double>, Map<class_1320, Double>> foodStats = ItemNBT.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            class_1324 inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.method_5996((class_1320)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_UUID_MULTI);
                inst.method_26837(new class_1322(LibConstants.FOOD_UUID_MULTI, "foodBuffMulti_" + ((class_1320)entry.getKey()).method_26830(), ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6330));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.method_5996((class_1320)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_UUID);
                inst.method_26837(new class_1322(LibConstants.FOOD_UUID, "foodBuff_" + ((class_1320)entry.getKey()).method_26830(), ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6328));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((class_1309)this, food.getHPGain());
        EntityUtils.foodHealing((class_1309)this, this.method_6063() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (class_1291 class_12912 : food.potionHeals()) {
                this.method_6016(class_12912);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.method_6092(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.method_6127()).getAttributes().values().forEach(inst -> {
            inst.method_6200(LibConstants.FOOD_UUID);
            inst.method_6200(LibConstants.FOOD_UUID_MULTI);
        });
    }

    @Override
    public boolean onGivingItem(class_1657 player, class_1799 stack) {
        if (this.isTamed()) {
            if (!player.method_5667().equals(this.method_6139())) {
                return false;
            }
            if (this.method_5626((class_1297)player)) {
                return false;
            }
            if (this.feedTimeOut <= 0) {
                boolean favorite = stack.method_31573(this.tamingItem());
                int count = stack.method_7947();
                class_3414 sound = switch (stack.method_7976()) {
                    case class_1839.field_8946 -> stack.method_21832();
                    case class_1839.field_8950 -> stack.method_21833();
                    default -> class_3417.field_14622;
                };
                boolean food = this.applyFoodEffect(stack);
                if (food || !this.playDeath()) {
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        serverPlayer.field_13987.method_14364((class_2596)new class_2767(sound, class_3419.field_15254, player.method_23317(), player.method_23318(), player.method_23321(), 0.7f, 1.0f));
                        Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).ifPresent(data -> data.getDailyUpdater().onGiveMonsterItem(serverPlayer));
                    }
                    stack.method_7939(count);
                    this.feedTimeOut = 7;
                    int day = WorldUtils.day(this.field_6002);
                    if (this.updater.getLastUpdateFood() != day) {
                        this.updater.setLastUpdateFood(day);
                        this.increaseFriendPoints(favorite ? 50 : 30);
                        if (favorite) {
                            this.field_6002.method_8421((class_1297)this, (byte)65);
                        } else {
                            this.field_6002.method_8421((class_1297)this, (byte)64);
                        }
                        DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).ifPresent(s -> s.getMonsterGiftIncrease().forEach((att, d) -> {
                            class_1324 inst = this.method_5996((class_1320)att);
                            if (inst != null) {
                                class_1322 mod = inst.method_6199(LibConstants.MONSTER_ITEM_BONUS);
                                double val = d;
                                if (mod != null) {
                                    val += mod.method_6186();
                                    inst.method_6202(mod);
                                }
                                inst.method_26837(new class_1322(LibConstants.MONSTER_ITEM_BONUS, "item_bonus_" + att.method_26830(), val, class_1322.class_1323.field_6328));
                            }
                        }));
                    }
                    stack.method_7934(1);
                }
                return true;
            }
        } else if (this.tamingTick == -1 && this.method_5805()) {
            class_3414 sound;
            switch (stack.method_7976()) {
                case field_8946: {
                    class_3414 class_34142 = stack.method_21832();
                    break;
                }
                case field_8950: {
                    class_3414 class_34142 = stack.method_21833();
                    break;
                }
                default: {
                    class_3414 class_34142 = sound = class_3417.field_14622;
                }
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)new class_2767(sound, class_3419.field_15254, player.method_23317(), player.method_23318(), player.method_23321(), 0.7f, 1.0f));
            }
            float rightItemMultiplier = this.tamingMultiplier(stack);
            int count = stack.method_7947();
            this.applyFoodEffect(stack);
            if (count == stack.method_7947() && !player.method_7337()) {
                stack.method_7934(1);
            }
            this.tamingTick = 60;
            float chance = EntityUtils.tamingChance(this, player, rightItemMultiplier, this.brushCount, this.loveAttCount);
            if (!(this.method_5682() == null || MobConfig.monsterNeedBarn && WorldHandler.get(this.method_5682()).findFittingBarn(this, player.method_5667()) == null)) {
                this.delayedTaming = () -> {
                    if (chance == 0.0f) {
                        this.field_6002.method_8421((class_1297)this, (byte)34);
                    } else if (this.field_5974.nextFloat() < chance) {
                        this.tameEntity(player);
                    } else {
                        this.field_6002.method_8421((class_1297)this, (byte)11);
                    }
                };
            }
            return true;
        }
        return false;
    }

    public void recalcStatsFull() {
        this.applyAttributes();
        this.updateStatsToLevel();
        this.updateFriendPointAttributeBonus();
    }

    public void updateStatsToLevel() {
        if (!this.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (class_1297)this);
        }
        float preHealthDiff = this.method_6063() - this.method_6032();
        this.prop.getAttributeGains().forEach((att, val) -> {
            class_1324 inst = this.method_5996((class_1320)att);
            if (inst != null) {
                val = val * 0.01;
                inst.method_6200(LibConstants.ATTRIBUTE_LEVEL_MOD);
                float multiplier = 1.0f;
                multiplier = att == class_5134.field_23716 ? (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.15f) * 0.02f) : (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.0f) * 0.015f);
                inst.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "rf.levelMod", (double)(this.level().getLevel() - 1) * val * (double)multiplier, class_1322.class_1323.field_6328));
                if (att == class_5134.field_23716) {
                    this.method_6033(this.method_6063() - preHealthDiff);
                }
            }
        });
    }

    public void increaseLevel() {
        this.levelPair.setLevel(class_3532.method_15340((int)(this.level().getLevel() + 1), (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        LevelExpPair pair = this.level();
        boolean res = pair.addXP(amount, 10000, LevelCalc::xpAmountForLevelUp, () -> {});
        Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (class_1297)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateMoveAnimation() {
    }

    public LevelExpPair getFriendlyPoints() {
        return this.friendlyPoints;
    }

    @Override
    public int friendPoints(UUID player) {
        if (player.equals(this.method_6139())) {
            return (Integer)this.field_6011.method_12789(FRIEND_POINTS_SYNC);
        }
        return 0;
    }

    public void onDailyUpdate() {
        if (this.field_6002 instanceof class_3218 && this.isTamed() && !this.playDeath() && (!MobConfig.monsterNeedBarn || this.assignBarn())) {
            class_2960 resourceLocation = this.dailyDropTable();
            this.dropAsDailyDrop(resourceLocation);
        }
    }

    protected void dropAsDailyDrop(class_2960 resourceLocation) {
        class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(resourceLocation);
        lootTable.method_320(this.dailyDropContext().method_309(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((BaseMonster)this).method_5775(arg_0));
    }

    protected class_47.class_48 dailyDropContext() {
        class_47.class_48 builder = new class_47.class_48((class_3218)this.field_6002).method_311(this.field_5974).method_312(class_181.field_1226, (Object)this).method_312(class_181.field_24424, (Object)this.method_19538());
        if (this.method_6139() != null) {
            builder.method_306(LootCtxParameters.UUID_CONTEXT, (Object)this.method_6139());
        }
        return builder;
    }

    public int moveTick() {
        return this.moveTick;
    }

    public float interpolatedMoveTick(float partialTicks) {
        return class_3532.method_15363((float)(((float)this.moveTick + (this.getMoveFlag() != MoveType.NONE ? partialTicks : -partialTicks)) / 3.0f), (float)0.0f, (float)1.0f);
    }

    public void setMovingFlag(MoveType type) {
        this.field_6011.method_12778(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveFlag() {
        return MoveType.values()[(Byte)this.field_6011.method_12789(MOVE_FLAGS)];
    }

    public void setDoJumping(boolean jump) {
        this.doJumping = jump;
    }

    public boolean doJumping() {
        return this.doJumping;
    }

    private void playTameEffect(boolean play) {
        class_2400 particle = class_2398.field_11201;
        int amount = 13;
        if (!play) {
            particle = class_2398.field_11251;
            amount += 9;
        }
        for (int i = 0; i < amount; ++i) {
            double d0 = this.field_5974.nextGaussian() * 0.02;
            double d2 = this.field_5974.nextGaussian() * 0.02;
            double d3 = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8466((class_2394)particle, true, this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d2, d3);
        }
    }

    public void method_6078(class_1282 cause) {
        if (!this.field_6002.field_9236) {
            if (this.field_6002.method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
                this.getOwner().method_9203(this.method_6066().method_5548(), class_156.field_25140);
            }
            if (this.method_5682() != null && this.method_6139() != null) {
                WorldHandler.get(this.method_5682()).removeMonsterFromPlayer(this.method_6139(), this);
                this.assignedBarn = null;
            }
            this.getAnimationHandler().setAnimation(null);
            List<class_1281> entries = ((CombatTrackerAccessor)this.method_6066()).getEntries();
            HashMap merged = new HashMap();
            entries.forEach(e -> {
                class_1297 patt57349$temp = e.method_35038();
                if (patt57349$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt57349$temp;
                    merged.compute(player.method_5667(), (id, o) -> o == null ? new CombatRecord(player, e.method_5499(), e.method_5503()) : new CombatRecord(player, e.method_5499(), o.totalDamage() + e.method_5503()));
                }
            });
            merged.values().forEach(rec -> this.onDeathDamageRecord(rec.player, rec.lastSource, rec.totalDamage));
        }
        super.method_6078(cause);
    }

    public void onDeathDamageRecord(class_3222 player, class_1282 source, float damage) {
        if ((double)damage > (double)this.method_6063() * 0.05) {
            Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(d -> d.increaseMobFrom(player, this));
        }
    }

    protected void method_6108() {
        if (!this.field_6002.field_9236 && this.field_6213 == 0) {
            this.playDeathAnimation(false);
            this.method_5942().method_6340();
        }
        ++this.field_6213;
        if (this.field_6213 == this.maxDeathTime() - 5 && !this.field_6002.field_9236 && this.method_6065() != null) {
            LevelCalc.addXP(this.method_6065(), this.baseXP(), this.baseMoney(), this.level().getLevel());
        }
        if (this.field_6213 >= this.maxDeathTime()) {
            if (!this.field_6002.field_9236) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_5974.nextGaussian() * 0.02;
                double d1 = this.field_5974.nextGaussian() * 0.02;
                double d2 = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d0, d1, d2);
            }
        }
    }

    public void method_6015(@Nullable class_1309 livingBase) {
        if (this.method_29504() && this.field_6213 > 0) {
            return;
        }
        super.method_6015(livingBase);
    }

    public boolean playDeath() {
        return (Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE);
    }

    public void setPlayDeath(boolean flag) {
        this.field_6011.method_12778(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            if (!this.field_6002.field_9236 && this.field_6002.method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
                this.getOwner().method_9203(this.getKnockoutMessage(), class_156.field_25140);
            }
            this.field_6002.method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> this.equals(e.method_5968())).forEach(m -> m.method_5980(null));
            this.method_5942().method_6340();
            this.playDeathAnimation(false);
            this.setMovingFlag(MoveType.NONE);
            this.method_5660(false);
            this.method_5728(false);
            this.method_18375();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private class_2561 getKnockoutMessage() {
        class_1282 source = this.method_6081();
        if (source instanceof class_1285 && source.method_5529() != null) {
            return new class_2588("runecraftory.tamed.monster.knockout.by", new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260(), source.method_5529().method_5476()});
        }
        return new class_2588("runecraftory.tamed.monster.knockout", new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260()});
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public boolean method_33190() {
        return super.method_33190() && !this.playDeath();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5667().equals(this.method_6139()) && !player.method_5715()) {
            return false;
        }
        if (this.playDeath() && source != class_1282.field_5849) {
            return false;
        }
        return (source.method_5529() == null || this.canAttackFrom(source.method_5529().method_19538())) && super.method_5643(source, amount);
    }

    protected void method_6074(class_1282 damageSrc, float damageAmount) {
        CustomDamage dmg;
        super.method_6074(damageSrc, damageAmount);
        if (!this.isTamed() && damageSrc instanceof CustomDamage && (dmg = (CustomDamage)damageSrc).method_5529() instanceof class_1657 && dmg.getElement() == EnumElement.LOVE) {
            this.loveAttCount = Math.min(100, this.loveAttCount + 1);
        }
        if (damageSrc != class_1282.field_5849 && this.isTamed() && this.method_6032() <= 0.0f) {
            this.method_6033(0.01f);
            this.setPlayDeath(true);
        }
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        if (this.isFlyingEntity() || this.method_5962() instanceof class_1331) {
            return false;
        }
        return super.method_5747(fallDistance, multiplier, source);
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5956() || this.playDeath() || this.tamingTick > 0;
    }

    protected float method_6120() {
        return 0.83f;
    }

    public void method_5865(class_1297 passenger) {
        if (this.method_5626(passenger)) {
            class_243 offset = this.passengerOffset(passenger).method_1031(0.0, passenger.method_5678(), 0.0).method_1024(-this.field_6283 * ((float)Math.PI / 180));
            passenger.method_5814(this.method_23317() + offset.method_10216(), this.method_23318() + offset.method_10214(), this.method_23321() + offset.method_10215());
            if (passenger instanceof class_1309) {
                class_1309 living = (class_1309)passenger;
                living.field_6283 = this.field_6283;
            }
        }
    }

    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, this.method_5621(), 0.0);
    }

    public void method_6091(class_243 vec) {
        class_1297 class_12972;
        if (this.shouldFreezeTravel()) {
            this.field_6212 = 0.0f;
            this.field_6227 = 0.0f;
            this.field_6250 = 0.0f;
            return;
        }
        if (this.method_5956() && (class_12972 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.handlePlayerInput(player, this.method_5740(), this::handleLandTravel);
        } else {
            this.handleLandTravel(vec);
        }
    }

    public void handleLandTravel(class_243 vec) {
        this.field_6281 = 0.02f;
        if (!this.method_5805() || this.playDeath()) {
            vec = class_243.field_1353;
        }
        super.method_6091(vec);
    }

    public void handleFreeTravel(class_243 vec) {
        class_1297 class_12972;
        if (this.shouldFreezeTravel()) {
            this.field_6212 = 0.0f;
            this.field_6227 = 0.0f;
            this.field_6250 = 0.0f;
            return;
        }
        if (this.method_5956() && (class_12972 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.handlePlayerInput(player, true, this::freeTravel);
        } else {
            this.freeTravel(vec);
        }
    }

    private void freeTravel(class_243 vec) {
        boolean currentNophysics = this.field_5960;
        if (!this.method_5805() || this.playDeath()) {
            this.field_5960 = false;
            vec = class_243.field_1353;
        }
        this.method_5724(this.method_6029() * 0.2f, vec);
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.91));
        this.field_5960 = currentNophysics;
    }

    protected void handlePlayerInput(class_1657 player, boolean hovers, Consumer<class_243> cons) {
        if (this.getAnimationHandler().hasAnimation()) {
            this.setMovingFlag(MoveType.NONE);
            this.method_5728(false);
            cons.accept(class_243.field_1353);
            this.method_29242((class_1309)this, false);
            return;
        }
        if (!this.method_5787()) {
            this.method_18799(class_243.field_1353);
            this.setDoJumping(false);
            this.method_29242((class_1309)this, false);
            return;
        }
        if (!this.field_6002.field_9236) {
            if (this.adjustRotFromRider((class_1309)player)) {
                this.method_36456(this.rotateClamped(this.method_36454(), player.method_36454(), this.method_20240() * 2));
                this.method_36457(this.rotateClamped(this.method_36455(), player.method_36455(), this.method_5978()));
            }
            this.field_6241 = this.field_6283 = this.method_36454();
        }
        double attrSpeed = !this.method_24828() && this.method_6127().method_27306(class_5134.field_23720) ? this.method_26825(class_5134.field_23720) : this.method_26825(class_5134.field_23719);
        float speed = (float)(attrSpeed / 1.3 * this.ridingSpeedModifier());
        float strafing = player.field_6212 / 0.98f * speed * 0.8f;
        if (player.field_6212 < 0.0f) {
            strafing *= -1.0f;
        }
        float forward = player.field_6250 / 0.98f * speed;
        if (player.field_6250 < 0.0f) {
            forward *= -0.5f;
        }
        float vertical = 0.0f;
        this.field_6281 = speed * 0.2f;
        if (hovers && forward > 0.0f) {
            vertical = (float)Math.min(0.0, player.method_5720().field_1351 + 0.45) * speed;
            if (player.method_36455() > 85.0f) {
                forward = 0.0f;
            } else if (vertical < 0.0f) {
                forward = (float)Math.sqrt(forward * forward - vertical * vertical);
            }
        }
        if (this.doJumping()) {
            if (this.field_5952 && !this.isFlyingEntity()) {
                this.field_6007 = true;
                this.method_6043();
                if (forward > 0.0f) {
                    float x = -class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
                    float z = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
                    this.method_18799(this.method_18798().method_1031(0.3 * (double)x, 0.0, 0.3 * (double)z));
                }
            } else if (this.isFlyingEntity()) {
                vertical = speed * 0.7f;
                if (this.method_18798().method_10214() < (double)vertical) {
                    this.method_18799(new class_243(this.method_18798().field_1352, this.method_18798().field_1351 + 0.1, this.method_18798().field_1350));
                }
            }
        }
        this.method_6125(speed);
        MoveType type = forward > 0.0f ? MoveType.RUN : (forward != 0.0f || strafing != 0.0f ? MoveType.WALK : MoveType.NONE);
        this.setMovingFlag(type);
        this.method_5728(type == MoveType.RUN);
        cons.accept(new class_243((double)strafing, (double)vertical, (double)forward));
        this.setDoJumping(false);
        this.method_29242((class_1309)this, false);
    }

    private float rotateClamped(float current, float target, float maxChange) {
        float f = class_3532.method_15381((float)current, (float)target);
        float g = class_3532.method_15363((float)f, (float)(-maxChange), (float)maxChange);
        return current + g;
    }

    public double ridingSpeedModifier() {
        return 1.3;
    }

    public boolean shouldFreezeTravel() {
        return false;
    }

    public int maxDeathTime() {
        return 20;
    }

    protected void playDeathAnimation(boolean load) {
        if (this.getDeathAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getDeathAnimation());
            if (load && this.field_6002.field_9236) {
                AnimatedAction anim = this.getAnimationHandler().getAnimation();
                while (!anim.done(0)) {
                    anim.tick();
                }
            }
        }
    }

    public AnimatedAction getDeathAnimation() {
        return null;
    }

    public void method_18402(class_2338 pos) {
        super.method_18402(pos);
        this.setSleeping(true);
    }

    public void method_18399() {
        super.method_18399();
        this.setSleeping(false);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.onSleeping(sleeping);
    }

    @Override
    public boolean hasSleepingAnimation() {
        return this.getSleepAnimation() != null;
    }

    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            if (this.getSleepAnimation() != null) {
                this.getAnimationHandler().setAnimation(this.getSleepAnimation());
                if (this.field_5953 && this.field_6002.field_9236) {
                    AnimatedAction anim = this.getAnimationHandler().getAnimation();
                    while (!anim.done(0)) {
                        anim.tick();
                    }
                }
            }
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    public AnimatedAction getSleepAnimation() {
        return null;
    }

    private boolean canAttackFrom(class_243 pos) {
        boolean result;
        if (this.isTamed()) {
            return true;
        }
        boolean bl = result = this.method_18413() == -1.0f || this.method_18412().method_10268(pos.method_10216(), pos.method_10214(), pos.method_10215()) < (double)(this.method_18413() * this.method_18413());
        if (!result) {
            this.field_6002.method_8449(null, (class_1297)this, class_3417.field_14785, this.method_5634(), 0.7f, 0.9f);
            class_1937 class_19372 = this.field_6002;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                for (int i = 0; i < 6; ++i) {
                    serverLevel.method_14199((class_2394)class_2398.field_11208, this.method_23322(1.2), this.method_23319(), this.method_23325(1.2), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return result;
    }

    public void setupAttack(AnimatedAction anim) {
        if (this.method_5968() != null) {
            this.setTargetPosition(this.method_5968());
        }
    }

    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{this.getDeathAnimation(), this.getSleepAnimation()})) {
            return;
        }
        this.method_5942().method_6340();
        if (anim.isAt("attack")) {
            this.mobAttack(anim, this.method_5968(), this::method_6121);
        }
    }

    protected class_243 directionToLookAt() {
        return this.getAnimationHandler().hasAnimation() && this.targetPosition != null ? this.targetPosition.asVec(this.method_19538()).method_1020(this.method_19538()) : null;
    }

    protected float[] targetLookClamp() {
        return new float[]{60.0f, 30.0f};
    }

    public void setTargetPosition(class_1309 target) {
        this.setTargetPosition(MobAttackExt.TargetPosition.of(target));
    }

    public void setTargetPosition(MobAttackExt.TargetPosition position) {
        this.targetPosition = position;
        if (!this.field_6002.field_9236) {
            S2CMobUpdate.send(this, SyncableDatas.TARGET_POS, this.targetPosition);
        }
    }

    @Override
    public MobAttackExt.TargetPosition getTargetPosition() {
        return this.targetPosition;
    }

    @Nullable
    public class_243 tryGetTargetPosition(class_1309 target) {
        if (this.getTargetPosition() != null) {
            return this.getTargetPosition().asVec(this.method_19538());
        }
        return target != null ? target.method_19538() : null;
    }

    public void mobAttack(AnimatedAction anim, class_1309 target, Consumer<class_1309> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.tryGetTargetPosition(target), 0.0);
        this.field_6002.method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.hitPred.test((class_1309)entity) && obb.intersects(entity.method_5829())).forEach(cons);
        if (!this.field_6002.field_9236) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
    }

    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, @Nullable class_243 target, double grow) {
        float yRot = this.method_36454();
        float xRot = this.method_36455();
        if (target != null && !this.method_5956()) {
            class_243 dir = target.method_1020(this.method_19538()).method_1029();
            float[] xYRot = MathsHelper.YXRotFrom(dir);
            yRot = xYRot[0];
            xRot = -xYRot[1];
        } else {
            class_1297 class_12972 = this.method_5642();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                yRot = player.method_36454();
                xRot = player.method_36455();
            }
        }
        double off = (double)this.method_17682() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).method_1009(grow, 0.0, grow).method_989(0.0, -off, grow), yRot, class_3532.method_15363((float)xRot, (float)-15.0f, (float)15.0f), this.method_19538().method_1031(0.0, off, 0.0));
    }

    public OrientedBoundingBox prepareAttackBox(AnimatedAction anim, class_1309 target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, target.method_19538(), grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (class_1297)this);
        }
        return obb;
    }

    public class_238 attackBB(AnimatedAction anim) {
        double range = 1.0;
        return new class_238(-range * 0.5, -0.02, 0.0, range * 0.5, (double)this.method_17682() + 0.02, range);
    }

    public abstract void handleRidingCommand(int var1);

    public boolean isStaying() {
        return this.behaviour == Behaviour.STAY;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.setBehaviour(behaviour, false);
    }

    private void setBehaviour(Behaviour behaviour, boolean load) {
        this.field_6011.method_12778(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.field_6002.field_9236) {
            this.updateAI(false, load);
        }
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean doStartRide(class_3222 player) {
        if (this.rideable()) {
            player.method_5804((class_1297)this);
            return true;
        }
        player.method_9203((class_2561)new class_2588("runecraftory.monster.interact.ride.no"), class_156.field_25140);
        return false;
    }

    protected float tamingMultiplier(class_1799 stack) {
        boolean flag = stack.method_31573(this.tamingItem());
        return flag ? 2.0f : 1.0f;
    }

    protected void tameEntity(class_1657 owner) {
        if (!this.method_5805()) {
            return;
        }
        this.method_18408(this.method_24515(), -1);
        this.setOwner(owner);
        this.field_6189.method_6340();
        this.method_5980(null);
        this.field_6002.method_8421((class_1297)this, (byte)10);
        this.updater.setLastUpdateDay(WorldUtils.day(this.field_6002));
        if (Platform.INSTANCE.getPlayerData(owner).map(d -> d.party.isPartyFull()).orElse(true).booleanValue()) {
            this.setBehaviour(Behaviour.WANDER);
        } else {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        this.field_6002.method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> {
            if (e == this) return false;
            if (!(e instanceof class_6025)) return false;
            class_6025 ownable = (class_6025)e;
            if (!this.method_6139().equals(ownable.method_6139())) return false;
            if (e.method_5968() != this) return false;
            return true;
        }).forEach(e -> {
            e.method_5980(null);
            if (e.method_6065() == this) {
                e.method_6015(null);
            }
        });
        this.method_6015(null);
        if (owner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)owner;
            Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).ifPresent(data -> {
                data.entityStatsTracker.tameEntity(this);
                ModCriteria.TAME_MONSTER_TRIGGER.trigger(serverPlayer, this, data.entityStatsTracker);
                LevelCalc.levelSkill(serverPlayer, data, EnumSkills.TAMING, 10.0f);
            });
            QuestHandler.getData(serverPlayer).trigger(TamingTracker.KEY, this);
        }
        if (this.method_5682() != null) {
            this.assignBarn();
        }
    }

    private boolean findNearestBarn(boolean load) {
        if (load) {
            return this.assignBarn();
        }
        BarnData nearest = WorldHandler.get(this.method_5682()).findNearestFittingBarn(this, 5);
        if (nearest != null) {
            if (this.assignedBarn != null && this.assignedBarn != nearest) {
                this.assignedBarn.removeMonster(this);
            }
            this.assignedBarn = nearest;
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return this.assignBarn();
    }

    private boolean assignBarn() {
        if (!this.method_5805()) {
            return false;
        }
        if (this.assignedBarn == null || this.assignedBarn.isInvalidFor(this)) {
            this.assignedBarn = WorldHandler.get(this.method_5682()).findFittingBarn(this);
        }
        if (this.assignedBarn != null) {
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return false;
    }

    public BarnData getAssignedBarn() {
        this.assignBarn();
        return this.assignedBarn;
    }

    protected void untameEntity() {
        this.field_6002.method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> e != this && e.method_5968() == this).forEach(e -> {
            e.method_5980(null);
            if (e.method_6065() == this) {
                e.method_6015(null);
            }
        });
        if (this.method_5682() != null && this.method_6139() != null) {
            WorldHandler.get(this.method_5682()).removeMonsterFromPlayer(this.method_6139(), this);
            if (this.getOwner() != null) {
                Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((class_1297)this));
            } else {
                WorldHandler.get(this.method_5682()).toRemovePartyMember((class_1309)this);
            }
            this.assignedBarn = null;
        }
        this.setOwner(null);
        this.method_6015(null);
        if (this.playDeath()) {
            this.method_6025(this.method_6063());
        }
        this.setBehaviour(Behaviour.WANDER);
        this.updateAI(true, false);
        this.method_5980(null);
        this.method_5942().method_6340();
    }

    public class_2338 getSeedInventory() {
        if (this.seedInventory != null && !this.method_18407(this.seedInventory)) {
            return null;
        }
        return this.seedInventory;
    }

    public class_2338 getCropInventory() {
        if (this.cropInventory != null && !this.method_18407(this.cropInventory)) {
            return null;
        }
        return this.cropInventory;
    }

    public void setSeedInventory(class_2338 seedInventory) {
        this.seedInventory = seedInventory;
    }

    public void setCropInventory(class_2338 cropInventory) {
        this.cropInventory = cropInventory;
    }

    protected void method_5627(class_1297 passenger) {
        this.method_5942().method_6340();
        this.method_18799(class_243.field_1353);
        this.method_5976(0.0f);
        this.method_5930(0.0f);
        this.method_5938(0.0f);
        this.method_5980(null);
        super.method_5627(passenger);
    }

    protected void method_5793(class_1297 passenger) {
        if (passenger == this.getOwner()) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        super.method_5793(passenger);
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    public boolean method_5788() {
        return this.method_6094();
    }

    public boolean adjustRotFromRider(class_1309 rider) {
        return true;
    }

    public abstract void playInteractionAnimation();

    @Override
    public boolean canBeAttackedBy(class_1309 entity) {
        if (entity instanceof class_1308) {
            class_1308 m = (class_1308)entity;
            if (entity.method_5864().method_20210(RunecraftoryTags.TAMED_MONSTER_IGNORE) && this.method_5968() != m && m.method_6065() != this) {
                return !this.isTamed();
            }
        }
        return true;
    }

    public void method_31744(class_5569 levelCallback) {
        super.method_31744(WorldUtils.wrappedCallbackFor(this, this::getOwner, levelCallback));
    }

    @Override
    public Predicate<class_1309> validTargetPredicate() {
        return this.hitPred;
    }

    public boolean allowAnimation(String prev, @Nullable AnimatedAction other) {
        return true;
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        data.runIf(SyncableDatas.TARGET_POS, pos -> {
            this.targetPosition = pos;
        });
    }

    private void handleTestingTick() {
        if (!TESTING) {
            return;
        }
        AnimatedAction anim = null;
        if (anim != null && !this.getAnimationHandler().isCurrent(new AnimatedAction[]{anim})) {
            this.getAnimationHandler().setAnimation(anim);
        }
    }

    public static enum Behaviour {
        WANDER("runecraftory.monster.interact.wander", false),
        WANDER_HOME("runecraftory.monster.interact.home", false),
        FOLLOW("runecraftory.monster.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.monster.interact.follow.distance", true),
        STAY("runecraftory.monster.interact.stay", true),
        FARM("runecraftory.monster.interact.farm", false);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }

    public static enum MoveType {
        NONE,
        WALK,
        RUN,
        SNEAK;

    }

    public record CombatRecord(class_3222 player, class_1282 lastSource, float totalDamage) {
    }
}

