/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IOverlayEntityRender;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public abstract class BossMonster
extends BaseMonster
implements IOverlayEntityRender {
    protected static final List<Supplier<class_1320>> STAT_INCREASE = List.of(() -> class_5134.field_23721, ModAttributes.DEFENCE, ModAttributes.MAGIC, ModAttributes.MAGIC_DEFENCE);
    protected static final UUID STAT_INCREASE_ID = UUID.fromString("fc5aaf23-4e83-4f7d-a4f0-675350d6e5e7");
    private static final class_2940<Boolean> ENRAGED = class_2945.method_12791(BossMonster.class, (class_2941)class_2943.field_13323);
    protected final RunecraftoryBossbar bossInfo = this.createBossBar();
    private int combatTick;
    private int noPlayerRegenTick;
    private int fullHealDelay;
    private class_5321<class_1937> restrictDimension;

    public BossMonster(class_1299<? extends BossMonster> type, class_1937 level) {
        super(type, level);
    }

    public static <T extends BaseMonster> ImmutableMap<String, BiConsumer<AnimatedAction, T>> createAnimationHandler(Consumer<ImmutableMap.Builder<AnimatedAction, BiConsumer<AnimatedAction, T>>> cons) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        cons.accept(builder);
        return (ImmutableMap)builder.build().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((AnimatedAction)e.getKey()).getID(), Map.Entry::getValue));
    }

    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ENRAGED, (Object)false);
    }

    public void method_5670() {
        super.method_5670();
        if (!this.field_6002.field_9236) {
            if (!this.isTamed() && this.method_5805()) {
                this.updatePlayers();
                this.updateBossBar();
                if (this.method_5968() == null && this.bossInfo.method_14092().isEmpty()) {
                    if (++this.combatTick > 400 && ++this.noPlayerRegenTick > 40) {
                        this.method_6025(this.method_6063() * 0.1f);
                        if (this.method_6032() >= this.method_6063()) {
                            this.fullyHeal();
                        }
                        this.noPlayerRegenTick = 0;
                    }
                    if (this.combatTick > 600 && this.method_18410() && !this.method_18411() && this.restrictDimension != null) {
                        class_2338 restrict = this.method_18412();
                        if (this.field_6002.method_27983().equals(this.restrictDimension)) {
                            TeleportSpell.safeTeleportTo((class_1297)this, restrict.method_10263(), restrict.method_10264(), restrict.method_10260());
                        } else {
                            class_3218 serverLevel = this.method_5682().method_3847(this.restrictDimension);
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((class_1297)this, serverLevel, restrict.method_10263(), restrict.method_10264(), restrict.method_10260());
                            }
                        }
                    }
                } else {
                    this.combatTick = 0;
                    this.noPlayerRegenTick = 0;
                }
            }
            if (--this.fullHealDelay == 1) {
                this.fullyHeal();
            }
        }
    }

    public void method_18408(@Nullable class_2338 pos, int distance) {
        super.method_18408(pos, distance);
        this.restrictDimension = this.field_6002.method_27983();
    }

    public void method_35055() {
        super.method_35055();
        this.restrictDimension = null;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Enraged", this.isEnraged());
        compound.method_10569("FullHealDelay", this.fullHealDelay);
        if (this.restrictDimension != null) {
            compound.method_10582("RestrictDim", this.restrictDimension.method_29177().toString());
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setEnraged(compound.method_10577("Enraged"), true);
        this.fullHealDelay = compound.method_10550("FullHealDelay");
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
        if (compound.method_10545("RestrictDim")) {
            this.restrictDimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(compound.method_10558("RestrictDim")));
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    @Override
    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void setOwner(class_1657 player) {
        super.setOwner(player);
        if (player != null) {
            this.bossInfo.method_14094();
        }
    }

    @Override
    protected void method_6108() {
        super.method_6108();
        if (!this.field_6002.field_9236 && this.field_6213 == 1) {
            this.updateBossBar();
        }
        if (this.field_6002.field_9236 && this.field_6213 > 1) {
            if (this.field_6213 < 40) {
                if (this.field_6213 % 10 == 0) {
                    this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.method_23317() + (this.field_5974.nextDouble() - 0.5) * (double)this.method_17681(), this.method_23318() + this.field_5974.nextDouble() * (double)this.method_17682(), this.method_23321() + (this.field_5974.nextDouble() - 0.5) * (double)this.method_17681(), this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02);
                }
            } else if (this.field_6213 < 80) {
                if (this.field_6213 % 2 == 0) {
                    this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.method_23317() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 2.0f), this.method_23318() + this.field_5974.nextDouble() * (double)(this.method_17682() + 1.0f), this.method_23321() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 2.0f), this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02);
                }
            } else {
                int amount = (this.field_6213 - 80) / 10;
                for (int i = 0; i < amount; ++i) {
                    this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.method_23317() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 3.0f), this.method_23318() + this.field_5974.nextDouble() * (double)(this.method_17682() + 1.0f), this.method_23321() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 3.0f), this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02);
                }
            }
        }
    }

    @Override
    public int maxDeathTime() {
        return 200;
    }

    @Override
    protected float tamingMultiplier(class_1799 stack) {
        boolean flag = stack.method_31573(this.tamingItem());
        return flag ? 1.0f : 0.0f;
    }

    @Override
    protected void tameEntity(class_1657 owner) {
        super.tameEntity(owner);
        this.setEnraged(false, false);
    }

    public boolean isEnraged() {
        return this.method_5805() && !this.isTamed() && (Boolean)this.field_6011.method_12789(ENRAGED) != false;
    }

    public void setEnraged(boolean flag, boolean load) {
        this.field_6011.method_12778(ENRAGED, (Object)flag);
        if (!load) {
            if (flag) {
                STAT_INCREASE.forEach(att -> {
                    class_1324 inst = this.method_5996((class_1320)att.get());
                    if (inst.method_6199(STAT_INCREASE_ID) == null) {
                        inst.method_26837(new class_1322(STAT_INCREASE_ID, "rf.boss_stat_increase", 0.1, class_1322.class_1323.field_6331));
                    }
                });
            } else {
                STAT_INCREASE.forEach(att -> this.method_5996((class_1320)att.get()).method_6200(STAT_INCREASE_ID));
            }
        }
        if (flag && !load && this.method_5805()) {
            this.playAngrySound();
        }
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 25 + this.method_6051().nextInt(20) : 30 + this.method_6051().nextInt(25)) + diffAdd;
    }

    protected void updateBossBar() {
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
    }

    @Override
    protected void method_6074(class_1282 damageSrc, float damageAmount) {
        super.method_6074(damageSrc, damageAmount);
        this.combatTick = 0;
        if (!this.isTamed() && this.checkRage()) {
            this.setEnraged(true, false);
        }
    }

    @Override
    public void onDeathDamageRecord(class_3222 player, class_1282 source, float damage) {
        super.onDeathDamageRecord(player, source, damage);
        if (!this.isTamed() && (double)damage > (double)this.method_6063() * 0.05 && (this.field_6232 <= 0 || player != this.method_6124())) {
            player.method_5716((class_1297)this, this.field_6232, source);
        }
    }

    protected boolean checkRage() {
        return (double)(this.method_6032() / this.method_6063()) < 0.5 && !this.isEnraged();
    }

    protected void fullyHeal() {
        this.method_6025(this.method_6063());
        this.setEnraged(false, false);
    }

    private void updatePlayers() {
        HashSet<class_3222> set = new HashSet<class_3222>();
        for (class_3222 serverPlayer : this.field_6002.method_8390(class_3222.class, this.arenaAABB(), e -> true)) {
            this.bossInfo.method_14088(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set2 = Sets.newHashSet((Iterable)this.bossInfo.method_14092());
        set2.removeAll(set);
        for (class_3222 serverPlayer : set2) {
            this.bossInfo.removePlayerFading(serverPlayer);
        }
    }

    public class_238 arenaAABB() {
        if (this.method_18410()) {
            return new class_238(this.method_18412()).method_1014((double)(this.method_18413() + 1.0f));
        }
        return this.method_5829().method_1014(Math.max(48.0, this.method_26825(class_5134.field_23717) + 1.0));
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        for (class_3222 player : this.bossInfo.method_14092()) {
            this.method_5742(player);
        }
    }

    @Override
    public void method_5837(class_3222 player) {
        super.method_5837(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
        if (this.method_5805() && !this.isTamed() && player.method_31481() && this.bossInfo.method_14092().isEmpty()) {
            this.fullHealDelay = 10;
        }
    }

    public int overlayU(int orig) {
        return this.isEnraged() ? (int)(Math.sin((float)this.field_6012 / 7.0f) * 5.0 + 5.0) : orig;
    }

    public int overlayV(int orig) {
        return this.isEnraged() ? 0 : orig;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (other == null) {
            return super.allowAnimation(prev, null);
        }
        return !prev.equals(other.getID());
    }

    public void playAngrySound() {
        this.method_5783(class_3417.field_14854, 1.0f, (this.method_6051().nextFloat() - this.method_6051().nextFloat()) * 0.2f + 0.8f);
    }
}

