/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_243;

public abstract class ChargingMonster
extends BaseMonster {
    protected List<class_1309> hitEntity;
    private class_243 chargeMotion;
    private float prevStepHeight = -1.0f;
    private final Consumer<AnimatedAction> chargingAnim = this.animatedActionConsumer();
    private boolean initAnim;

    public ChargingMonster(class_1299<? extends ChargingMonster> type, class_1937 level) {
        super(type, level);
    }

    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            if (!this.field_6002.field_9236) {
                if (anim != null && this.isChargingAnim((AnimatedAction)anim)) {
                    this.prevStepHeight = this.field_6013;
                    this.field_6013 = Math.max(1.5f, 1.0f + this.field_6013);
                } else if (this.prevStepHeight != -1.0f) {
                    this.field_6013 = this.prevStepHeight;
                    this.prevStepHeight = -1.0f;
                }
                if (this.isChargingAnimation()) {
                    this.hitEntity = null;
                } else {
                    this.chargeMotion = null;
                }
            }
        };
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                this.chargingAnim.accept((AnimatedAction)anim);
                return false;
            });
            this.initAnim = true;
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.fixedYaw()) {
            return this.chargeMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (this.isChargingAnim(anim)) {
            if (this.chargeMotion == null) {
                this.setChargeMotion(this.getChargeTo(anim));
            }
            this.method_5942().method_6340();
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (!this.handleChargeMovement(anim)) {
                    return;
                }
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<class_1309>();
                }
                this.mobAttack(anim, this.method_5968(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
                this.doWhileCharge();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected abstract boolean isChargingAnim(AnimatedAction var1);

    protected boolean fixedYaw() {
        return this.isChargingAnimation();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (!this.isChargingAnim(anim)) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double width = this.method_17681();
        double speed = Math.max(width, this.method_18798().method_1033() - width);
        float yRot = 0.0f;
        if (this.chargeMotion != null) {
            yRot = MathsHelper.YRotFrom(this.chargeMotion);
        }
        return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2).method_1014(grow).method_1012(0.0, 0.0, speed), yRot, 0.0f, this.method_19538());
    }

    @Override
    public boolean adjustRotFromRider(class_1309 rider) {
        return !this.isChargingAnimation();
    }

    public void setChargeMotion(class_243 chargeMotion) {
        this.chargeMotion = chargeMotion;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    public class_243 getChargeMotion() {
        return this.chargeMotion;
    }

    public void method_5697(class_1297 entity) {
        if (this.isChargingAnimation()) {
            return;
        }
        super.method_5697(entity);
    }

    public boolean handleChargeMovement(AnimatedAction anim) {
        if (this.chargeMotion != null) {
            this.method_18800(this.chargeMotion.field_1352, this.method_18798().field_1351, this.chargeMotion.field_1350);
            return true;
        }
        return false;
    }

    public void doWhileCharge() {
    }

    public double chargingSpeed() {
        return 0.4;
    }

    public class_243 getChargeTo(AnimatedAction anim) {
        return EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(this.chargingSpeed());
    }

    private boolean isChargingAnimation() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        return anim != null && this.isChargingAnim(anim);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, charge -> {
            this.chargeMotion = charge;
        });
    }
}

