/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public abstract class LeapingMonster
extends BaseMonster {
    protected List<class_1309> hitEntity;
    private final Consumer<AnimatedAction> chargingAnim = this.animatedActionConsumer();
    private class_243 leapingDir;
    private boolean initAnim;

    public LeapingMonster(class_1299<? extends LeapingMonster> type, class_1937 level) {
        super(type, level);
    }

    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            if (this.isLeapingAnimation()) {
                this.hitEntity = null;
            } else {
                this.leapingDir = null;
            }
        };
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                this.chargingAnim.accept((AnimatedAction)anim);
                return false;
            });
            this.initAnim = true;
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().hasAnimation() && this.isLeapingAnim(this.getAnimationHandler().getAnimation())) {
            if (this.method_18798().method_1027() > 0.01) {
                return this.method_18798();
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (this.isLeapingAnim(anim)) {
            this.method_5942().method_6340();
            if (anim.isAt("attack_start")) {
                class_243 vec32 = this.getLeapVec(this.tryGetTargetPosition(this.method_5968()));
                this.method_18800(vec32.field_1352, this.leapHeightMotion(), vec32.field_1350);
                this.leapingDir = this.method_18798();
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<class_1309>();
                }
                this.mobAttack(anim, this.method_5968(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected abstract boolean isLeapingAnim(AnimatedAction var1);

    public class_243 getLeapVec(@Nullable class_243 target) {
        if (target != null) {
            return new class_243(target.field_1352 - this.method_23317(), 0.0, target.field_1350 - this.method_23321()).method_1029();
        }
        return this.method_5720();
    }

    public double leapHeightMotion() {
        return 0.1f;
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (!this.isLeapingAnim(anim)) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double width = this.method_17681();
        double speed = Math.max(width, this.method_18798().method_1033() - width);
        float yRot = 0.0f;
        if (this.leapingDir != null) {
            yRot = MathsHelper.YRotFrom(this.leapingDir);
        }
        return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2).method_1014(grow).method_1012(0.0, 0.0, speed), yRot, 0.0f, this.method_19538());
    }

    @Override
    public boolean adjustRotFromRider(class_1309 rider) {
        return !this.isLeapingAnimation();
    }

    public void method_5697(class_1297 entity) {
        if (this.isLeapingAnimation()) {
            return;
        }
        super.method_5697(entity);
    }

    private boolean isLeapingAnimation() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        return anim != null && this.isLeapingAnim(anim);
    }
}

