/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai;

import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7;

public abstract class FollowEntityGoal<T extends class_1308>
extends class_1352 {
    public static final double TP_DISTANCE_SQRT = 225.0;
    protected final T mob;
    private final double speedModifier;
    protected float stopDistance;
    protected float startDistance;
    protected final float ignoreTargetDist;
    private class_1309 owner;
    private int timeToRecalcPath;
    private float oldWaterCost;
    protected double tpDistanceSqrt = 225.0;

    public FollowEntityGoal(T mob, double speed, float startDist, float stopDist, float ignoreTargetDist) {
        this.mob = mob;
        this.speedModifier = speed;
        this.startDistance = startDist;
        this.stopDistance = stopDist;
        this.ignoreTargetDist = ignoreTargetDist;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public abstract class_1309 getEntityToFollow();

    public abstract boolean canFollow();

    public boolean method_6264() {
        class_1309 livingEntity = this.getEntityToFollow();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.method_7325()) {
            return false;
        }
        if (!this.canFollow()) {
            return false;
        }
        if (this.mob.method_5968() != null) {
            if (this.mob.method_5858((class_1297)livingEntity) < (double)(this.ignoreTargetDist * this.ignoreTargetDist)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }
        if (this.mob.method_5858((class_1297)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean method_6266() {
        if (this.mob.method_5942().method_6357()) {
            return false;
        }
        if (!this.canFollow()) {
            return false;
        }
        return !(this.mob.method_5858((class_1297)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.method_5944(class_7.field_18);
        this.mob.method_5941(class_7.field_18, 0.0f);
    }

    public void method_6270() {
        this.owner = null;
        this.mob.method_5942().method_6340();
        this.mob.method_5941(class_7.field_18, this.oldWaterCost);
    }

    public void method_6268() {
        this.mob.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.mob.method_5978());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.method_38847(10);
        if (this.mob.method_5934() || this.mob.method_5765()) {
            return;
        }
        if (this.mob.method_5858((class_1297)this.owner) < this.tpDistanceSqrt || !this.teleportToOwner()) {
            this.moveToFollower(this.owner, this.speedModifier);
        }
    }

    protected void moveToFollower(class_1309 follower, double speed) {
        this.mob.method_5942().method_6335((class_1297)follower, speed);
    }

    private boolean teleportToOwner() {
        class_2338 blockPos = this.owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 2);
            int l = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l)) continue;
            return true;
        }
        return false;
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!TeleportUtils.validTeleportPlace(this.mob, new class_2338(x, y, z), this::canTeleportOn)) {
            return false;
        }
        this.mob.method_5808((double)x + 0.5, (double)y, (double)z + 0.5, this.mob.method_36454(), this.mob.method_36455());
        this.mob.method_5942().method_6340();
        return true;
    }

    protected abstract boolean canTeleportOn(class_2680 var1);

    private int randomIntInclusive(int min, int max) {
        return this.mob.method_6051().nextInt(max - min + 1) + min;
    }
}

