/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai;

import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.BlockPlaceCtxHelper;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5575;

public class TendCropsGoal
extends class_1352 {
    private static final Predicate<class_1799> SEED_ITEM = s -> !s.method_7960() && s.method_7909() instanceof class_1747 && (s.method_31573(RunecraftoryTags.SEEDS) || s.method_7909() == class_1802.field_8567 || s.method_7909() == class_1802.field_8179);
    private final List<class_2338> toTend = new ArrayList<class_2338>();
    private class_2338 selected;
    protected final BaseMonster entity;
    private int checkCooldown;
    private int cooldown;
    private boolean canPlant;

    public TendCropsGoal(BaseMonster entity) {
        this.entity = entity;
    }

    public boolean method_6264() {
        if (TendCropsGoal.cantTendToCropsAnymore(this.entity) || !this.entity.method_18410() || --this.checkCooldown > 0) {
            return false;
        }
        this.toTend.clear();
        this.canPlant = this.entity.getSeedInventory() != null && Platform.INSTANCE.matchingInventory(this.entity.field_6002.method_8321(this.entity.getSeedInventory()), SEED_ITEM);
        class_2338 center = this.entity.method_18412();
        class_2338.class_2339 mutable = this.entity.method_18412().method_25503();
        int radius = MobConfig.farmRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    mutable.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                    if (!this.validPos((class_2338)mutable, this.entity.field_6002)) continue;
                    this.toTend.add(new class_2338((class_2382)mutable));
                }
            }
        }
        if (this.toTend.isEmpty()) {
            this.checkCooldown = 40;
            return false;
        }
        this.selected = this.toTend.remove(this.entity.method_6051().nextInt(this.toTend.size()));
        return true;
    }

    private boolean validPos(class_2338 pos, class_1937 level) {
        class_2302 crop;
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2302 && (crop = (class_2302)block).method_9825(state)) {
            return true;
        }
        class_2680 state2 = level.method_8320(pos.method_10074());
        if (state2.method_26164(RunecraftoryTags.FARMLAND) && (Integer)state2.method_11654((class_2769)class_2344.field_11009) < 7) {
            return true;
        }
        if (state2.method_26204() instanceof class_2344) {
            if (state.method_26164(RunecraftoryTags.MONSTER_CLEARABLE)) {
                return true;
            }
            if (this.canPlant) {
                return state.method_26215();
            }
        }
        return false;
    }

    public boolean method_6266() {
        return !this.toTend.isEmpty();
    }

    public void method_6270() {
        super.method_6270();
        this.toTend.clear();
        this.selected = null;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (TendCropsGoal.cantTendToCropsAnymore(this.entity)) {
            this.toTend.clear();
            return;
        }
        if (--this.cooldown > 0) {
            return;
        }
        if (this.selected == null) {
            if (this.toTend.isEmpty()) {
                return;
            }
            this.selected = this.toTend.remove(this.entity.method_6051().nextInt(this.toTend.size()));
            boolean bl = this.canPlant = this.entity.getSeedInventory() != null && Platform.INSTANCE.matchingInventory(this.entity.field_6002.method_8321(this.entity.getSeedInventory()), SEED_ITEM);
            if (!this.validPos(this.selected, this.entity.field_6002)) {
                this.selected = null;
                this.cooldown = 10;
                return;
            }
        }
        if (!this.selected.method_19769((class_2374)this.entity.method_19538(), Math.max(1.1, (double)this.entity.method_17681() * 1.9))) {
            class_243 to = class_243.method_24953((class_2382)this.selected);
            class_11 path = this.entity.method_5942().method_6352(to.method_10216(), to.method_10214(), to.method_10215(), 0);
            this.entity.method_5942().method_6334(path, 1.0);
            this.cooldown = this.entity.method_6051().nextInt(5) + 5;
        } else {
            class_2302 crop;
            class_2680 state = this.entity.field_6002.method_8320(this.selected);
            class_2248 block = state.method_26204();
            boolean success = false;
            if (state.method_26164(RunecraftoryTags.MONSTER_CLEARABLE)) {
                this.breakBlock((class_3218)this.entity.field_6002, this.selected, this.entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(this.entity.field_6002.method_8321(this.entity.getCropInventory()), (class_1799)s) : null);
            } else if (block instanceof class_2302 && (crop = (class_2302)block).method_9825(state)) {
                CropUtils.harvestCropRightClick(state, this.entity.field_6002, this.selected, (class_1297)this.entity, class_1799.field_8037, CropUtils.getPropertiesFor(crop), class_1268.field_5808, this.entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(this.entity.field_6002.method_8321(this.entity.getCropInventory()), (class_1799)s) : null);
                this.entity.field_6002.method_18023(class_5575.method_31795(class_1542.class), this.entity.method_5829().method_1014(0.2), e -> true);
                success = true;
            } else {
                class_2338 pos = this.selected.method_10074();
                class_2680 state2 = this.entity.field_6002.method_8320(pos);
                if (state2.method_26164(RunecraftoryTags.FARMLAND)) {
                    class_1792 class_17922;
                    class_1799 stack;
                    if ((Integer)state2.method_11654((class_2769)class_2344.field_11009) < 7) {
                        FarmlandHandler.waterLand((class_3218)this.entity.field_6002, pos, state2);
                        success = true;
                    } else if (state.method_26215() && this.entity.getSeedInventory() != null && !(stack = Platform.INSTANCE.findMatchingItem(this.entity.field_6002.method_8321(this.entity.getSeedInventory()), SEED_ITEM, 1)).method_7960() && (class_17922 = stack.method_7909()) instanceof class_1747) {
                        class_1747 blockItem = (class_1747)class_17922;
                        blockItem.method_7712(BlockPlaceCtxHelper.entityPlaceAt(this.entity.field_6002, stack, this.selected, class_2350.field_11036));
                        success = true;
                    }
                }
            }
            if (success) {
                this.entity.method_6033(this.entity.method_6032() - 1.0f);
                this.entity.addXp(5 + this.entity.method_6051().nextInt(5));
                this.entity.playInteractionAnimation();
            }
            this.selected = null;
            this.cooldown = this.entity.method_6051().nextInt(15) + 20;
        }
    }

    private void breakBlock(class_3218 level, class_2338 pos, Function<class_1799, class_1799> stackConsumer) {
        class_2586 blockEntity;
        class_2680 state = level.method_8320(pos);
        level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        class_2586 class_25862 = blockEntity = state.method_31709() ? level.method_8321(pos) : null;
        if (stackConsumer != null) {
            class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)this.entity, (class_1799)class_1799.field_8037).forEach(s -> {
                class_1799 rest = (class_1799)stackConsumer.apply((class_1799)s);
                if (!rest.method_7960()) {
                    class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)rest);
                }
            });
            state.method_26180(level, pos, class_1799.field_8037);
        } else {
            class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)this.entity, (class_1799)class_1799.field_8037);
        }
        level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
    }

    public static boolean cantTendToCropsAnymore(BaseMonster monster) {
        return (double)class_3532.method_15375((float)monster.method_6032()) <= Math.max(1.0, (double)monster.method_6063() * 0.05);
    }
}

