/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc;

import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1352;

public class NPCAttackGoal<T extends EntityNPCBase>
extends class_1352 {
    protected final T attacker;
    protected class_1309 target;
    protected int pathFindDelay;
    protected double distanceToTargetSq;
    protected boolean canSee;
    private List<NPCAction> actions;
    private int idx;
    private int actionDuration;
    private int idleTime;
    private boolean initialSelect = true;
    private NPCAction.NPCAttackAction attackAction;
    private boolean combo;

    public NPCAttackGoal(T entity) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        this.attacker = entity;
    }

    public boolean method_6264() {
        class_1309 living = this.attacker.method_5968();
        if (living == null || !living.method_5805()) {
            return false;
        }
        if (!this.attacker.method_18407(living.method_24515())) {
            return false;
        }
        return !((EntityNPCBase)this.attacker).getAttackActions().isEmpty();
    }

    public boolean method_6266() {
        return super.method_6266() && this.actions != null;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6270() {
        super.method_6270();
        class_1309 livingEntity = this.attacker.method_5968();
        if (!class_1301.field_6156.test(livingEntity)) {
            this.attacker.method_5980(null);
        }
        this.actions = null;
        this.idx = 0;
        this.initialSelect = true;
    }

    protected void selectActionSequence() {
        this.actions = ((EntityNPCBase)this.attacker).getAttackActions().getAction((EntityNPCBase)this.attacker);
        this.idx = 0;
        this.initialSelect = true;
    }

    public void setupValues() {
        this.target = this.attacker.method_5968();
        this.distanceToTargetSq = this.attacker.method_5858((class_1297)this.target);
        this.canSee = this.attacker.method_5985().method_6369((class_1297)this.target);
        if (this.initialSelect) {
            this.initialSelect = false;
            NPCAction action = this.actions.get(this.idx);
            this.attackAction = action.getAction((EntityNPCBase)this.attacker);
            this.actionDuration = Math.max(1, action.getDuration((EntityNPCBase)this.attacker));
        }
    }

    public void method_6268() {
        --this.actionDuration;
        --this.pathFindDelay;
        if (this.attacker.method_5968() == null) {
            return;
        }
        if (this.combo) {
            boolean bl = this.combo = ((EntityNPCBase)this.attacker).weaponHandler.isScheduledAction() || this.tryScheduleCombo();
            if (!this.combo && !((EntityNPCBase)this.attacker).weaponHandler.isScheduledAction()) {
                ++this.idx;
                this.initialSelect = true;
                if (this.idx >= this.actions.size()) {
                    this.selectActionSequence();
                }
            }
            return;
        }
        AnimatedAction anim = ((EntityNPCBase)this.attacker).getAnimationHandler().getAnimation();
        if (anim != null || --this.idleTime > 0) {
            return;
        }
        if (this.actions == null || this.actions.isEmpty()) {
            this.selectActionSequence();
            return;
        }
        this.setupValues();
        NPCAction npcAction = this.actions.get(this.idx);
        boolean done = npcAction.doAction((EntityNPCBase)this.attacker, this, this.attackAction);
        if (done || this.actionDuration <= 0) {
            if (done && this.attackAction != null) {
                ((EntityNPCBase)this.attacker).weaponHandler.setComboCount(0);
                ((EntityNPCBase)this.attacker).weaponHandler.doWeaponAttack(this.attackAction.action(), this.attacker.method_6047(), npcAction.getSpell());
                this.combo = this.tryScheduleCombo();
            }
            this.idleTime = npcAction.getCooldown((EntityNPCBase)this.attacker);
            if (done) {
                this.attacker.method_5942().method_6340();
            }
            if (!this.combo) {
                ++this.idx;
                this.initialSelect = true;
                if (this.idx >= this.actions.size()) {
                    this.selectActionSequence();
                }
            }
        }
    }

    private boolean tryScheduleCombo() {
        if (((EntityNPCBase)this.attacker).weaponHandler.isScheduledAction()) {
            return false;
        }
        int combo = ((EntityNPCBase)this.attacker).weaponHandler.getComboCount();
        if (this.attackAction != null && combo < this.attackAction.comboCount()) {
            NPCAction npcAction = this.actions.get(this.idx);
            ((EntityNPCBase)this.attacker).weaponHandler.doWeaponAttack(this.attackAction.action(), this.attacker.method_6047(), npcAction.getSpell());
            return true;
        }
        return false;
    }

    public class_1309 getAttackTarget() {
        return this.target;
    }

    public double getDistSqr() {
        return this.distanceToTargetSq;
    }

    public boolean canSeeTarget() {
        return this.canSee;
    }

    public void moveToEntityNearer(class_1309 target, float speed) {
        this.moveToEntity(target, speed, 0);
    }

    public void moveToEntity(class_1309 target, float speed, int accuracy) {
        if (this.pathFindDelay <= 0) {
            class_11 path = this.attacker.method_5942().method_6349((class_1297)target, accuracy);
            if (path == null || this.attacker.method_5942().method_6334(path, (double)speed)) {
                this.pathFindDelay += 15;
            }
            this.pathFindDelay += this.attacker.method_6051().nextInt(10) + 5;
        }
    }
}

