/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5321;

public class NPCFindPOI
extends class_1352 {
    protected final EntityNPCBase npc;
    private int cooldown = 2;

    public NPCFindPOI(EntityNPCBase npc) {
        this.npc = npc;
    }

    public boolean method_6264() {
        return --this.cooldown <= 0;
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6269() {
        class_4208 pos = this.npc.getBedPos();
        class_3218 serverLevel = (class_3218)this.npc.field_6002;
        if (pos == null) {
            class_4208 found = this.findAndTakePOI(serverLevel, class_4158.field_18517, class_4158.field_18517.method_19164(), p -> this.isNearOf(serverLevel, (class_2338)p, this.npc.getWorkPlace()));
            if (found != null) {
                this.npc.setBedPos(found);
            }
        } else {
            class_3218 poiLevel;
            class_2338 blockPos = pos.method_19446();
            class_3218 class_32182 = poiLevel = serverLevel.method_27983() != pos.method_19442() ? serverLevel.method_8503().method_3847(pos.method_19442()) : serverLevel;
            if (poiLevel == null || !poiLevel.method_19494().method_19116(blockPos, class_4158.field_18517.method_19164())) {
                this.npc.setBedPos(null);
            } else if (this.bedIsOccupied(poiLevel, blockPos)) {
                this.npc.setBedPos(null);
                poiLevel.method_19494().method_19129(blockPos);
                class_4209.method_19778((class_3218)poiLevel, (class_2338)blockPos);
            }
        }
        this.poiCheck(this.npc.getWorkPlace(), this.npc.getShop().poiType.get(), this.npc.getShop().predicate, serverLevel, p -> this.isNearOf(serverLevel, (class_2338)p, this.npc.getBedPos()), this.npc::setWorkPlace);
        this.poiCheck(this.npc.getMeetingPos(), class_4158.field_18518, class_4158.field_18518.method_19164(), serverLevel, p -> true, this.npc::setMeetingPos);
        this.cooldown = this.npc.getWorkPlace() != null && this.npc.getBedPos() != null ? 20 : 10;
    }

    private void poiCheck(class_4208 pos, class_4158 poiType, Predicate<class_4158> predicate, class_3218 serverLevel, Predicate<class_2338> pred, Consumer<class_4208> set) {
        if (pos == null) {
            class_4208 found;
            if (poiType != null && (found = this.findAndTakePOI(serverLevel, poiType, predicate, pred)) != null) {
                set.accept(found);
            }
        } else {
            class_3218 poiLevel;
            class_2338 blockPos = pos.method_19446();
            class_3218 class_32182 = poiLevel = serverLevel.method_27983() != pos.method_19442() ? serverLevel.method_8503().method_3847(pos.method_19442()) : serverLevel;
            if (poiType == null) {
                if (poiLevel != null && poiLevel.method_19494().method_19116(blockPos, t -> true)) {
                    poiLevel.method_19494().method_19129(blockPos);
                }
                set.accept(null);
            } else if (poiLevel == null || !poiLevel.method_19494().method_19116(blockPos, predicate)) {
                set.accept(null);
            }
        }
    }

    private class_4208 findAndTakePOI(class_3218 serverLevel, class_4158 poiType, Predicate<class_4158> predicate, Predicate<class_2338> pred) {
        class_4153 poiManager = serverLevel.method_19494();
        Set set = poiManager.method_30957(predicate, pred, this.npc.method_24515(), 48, class_4153.class_4155.field_18487).limit(5L).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return null;
        }
        class_11 path = this.npc.method_5942().method_29934(set, poiType.method_21648());
        if (path != null && path.method_21655()) {
            class_2338 blockPos2 = path.method_48();
            if (this.bedIsOccupied(serverLevel, blockPos2)) {
                return null;
            }
            return poiManager.method_19132(blockPos2).map(type -> {
                poiManager.method_19126(predicate, arg_0 -> ((class_2338)blockPos2).equals(arg_0), blockPos2, 1);
                class_4209.method_19778((class_3218)serverLevel, (class_2338)blockPos2);
                return class_4208.method_19443((class_5321)serverLevel.method_27983(), (class_2338)blockPos2);
            }).orElse(null);
        }
        return null;
    }

    private boolean bedIsOccupied(class_3218 serverLevel, class_2338 blockPos) {
        class_2680 blockState = serverLevel.method_8320(blockPos);
        return blockState.method_26164(class_3481.field_16443) && (Boolean)blockState.method_11654((class_2769)class_2244.field_9968) != false && !this.npc.method_6113();
    }

    private boolean isNearOf(class_3218 level, class_2338 pos, class_4208 gPos) {
        if (gPos == null) {
            return true;
        }
        if (level.method_27983() != gPos.method_19442()) {
            return false;
        }
        return gPos.method_19446().method_19771((class_2382)pos, 16.0);
    }
}

