/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc;

import com.google.common.base.Suppliers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4076;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_5321;
import net.minecraft.class_5532;
import net.minecraft.class_5534;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class NPCWanderGoal
extends class_1352 {
    private static final Supplier<Set<class_4158>> SHELTER_POIS = Suppliers.memoize(() -> ModNPCJobs.allJobs().stream().map(s -> s.poiType.get()).filter(Objects::nonNull).collect(Collectors.toSet()));
    protected final EntityNPCBase npc;
    private int walkCooldown;
    private int shelterPOISearchCooldown;
    private int pathFindCooldown;
    private class_4168 prevActivity;

    public NPCWanderGoal(EntityNPCBase npc) {
        this.npc = npc;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        return this.npc.getEntityToFollowUUID() == null;
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_4168 activity = this.npc.getActivity();
        boolean changed = this.prevActivity != activity;
        this.prevActivity = activity;
        --this.shelterPOISearchCooldown;
        --this.walkCooldown;
        --this.pathFindCooldown;
        if (changed) {
            this.npc.method_5942().method_6340();
            this.npc.method_18868().method_18875(class_4140.field_18445);
            this.npc.method_18868().method_18875(class_4140.field_19293);
        }
        this.moveToTarget();
        if (activity == class_4168.field_18597 ? this.rest() : (activity == class_4168.field_18596 ? this.work() : activity == class_4168.field_18598 && this.goMeet())) {
            return;
        }
        this.wanderAround();
    }

    public boolean rest() {
        class_4208 pos = this.npc.getBedPos();
        if (pos != null && this.npc.field_6002.method_27983() == pos.method_19442()) {
            class_2680 blockState;
            if (this.npc.method_18868().method_18904(class_4140.field_18445).isEmpty() && !this.npc.method_6113()) {
                float spd = this.npc.method_5721() && this.npc.method_5649((double)pos.method_19446().method_10263() + 0.5, pos.method_19446().method_10264(), (double)pos.method_19446().method_10260() + 0.5) > 25.0 ? 1.3f : 1.0f;
                this.setWalkTargetTo(pos.method_19446(), spd, 0, () -> this.npc.setBedPos(null));
            }
            if (pos.method_19446().method_19769((class_2374)this.npc.method_19538(), 2.0) && (blockState = this.npc.field_6002.method_8320(pos.method_19446())).method_26164(class_3481.field_16443) && !((Boolean)blockState.method_11654((class_2769)class_2244.field_9968)).booleanValue()) {
                this.npc.method_18403(pos.method_19446());
                this.npc.method_18868().method_18875(class_4140.field_18445);
            }
            return true;
        }
        return false;
    }

    public boolean work() {
        class_4208 pos = this.npc.getWorkPlace();
        if (pos != null && this.npc.field_6002.method_27983() == pos.method_19442()) {
            if (pos.method_19446().method_19769((class_2374)this.npc.method_19538(), 2.0)) {
                return true;
            }
            if (this.npc.method_18868().method_18904(class_4140.field_18445).isEmpty()) {
                this.setWalkTargetTo(pos.method_19446(), 1.0f, 1, () -> this.npc.setWorkPlace(null));
            }
            return true;
        }
        return false;
    }

    public boolean goMeet() {
        if (this.seekShelter()) {
            return true;
        }
        class_4208 pos = this.npc.getMeetingPos();
        if (pos != null && this.npc.field_6002.method_27983() == pos.method_19442()) {
            if (pos.method_19446().method_19769((class_2374)this.npc.method_19538(), 6.0) && this.walkCooldown <= 0) {
                class_243 to = this.getRandomPosition(5);
                if (to != null) {
                    this.setWalkTarget(new class_2338(to), 1.0f, 0);
                    this.walkCooldown = this.npc.method_6051().nextInt(40) + 90;
                } else {
                    this.walkCooldown = this.npc.method_6051().nextInt(20) + 30;
                }
                return true;
            }
            if (this.npc.method_18868().method_18904(class_4140.field_18445).isEmpty()) {
                this.setWalkTargetTo(pos.method_19446(), 1.0f, 1, () -> this.npc.setMeetingPos(null));
            }
            return true;
        }
        return false;
    }

    public boolean seekShelter() {
        if (this.npc.field_6002.method_8419()) {
            if (--this.shelterPOISearchCooldown < 0) {
                Optional hide = this.npc.method_18868().method_18904(class_4140.field_19008);
                if (hide.isEmpty()) {
                    class_4153 poiManager = ((class_3218)this.npc.field_6002).method_19494();
                    Set set = poiManager.method_30957(p -> SHELTER_POIS.get().contains(p), p -> {
                        if (this.npc.getBedPos() != null) {
                            return this.npc.method_24515().method_10262((class_2382)this.npc.getBedPos().method_19446()) > p.method_10262((class_2382)this.npc.method_24515());
                        }
                        return true;
                    }, this.npc.method_24515(), 48, class_4153.class_4155.field_18489).limit(5L).collect(Collectors.toSet());
                    boolean found = false;
                    for (class_2338 pos : set) {
                        class_238 atPos = new class_238(pos).method_1014(10.0);
                        if (this.npc.field_6002.method_18023(class_5575.method_31795(EntityNPCBase.class), atPos, e -> true).size() >= 5 || !this.isUnderRoof(pos)) continue;
                        this.npc.method_18868().method_18878(class_4140.field_19008, (Object)class_4208.method_19443((class_5321)this.npc.field_6002.method_27983(), (class_2338)pos));
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (this.npc.getBedPos() != null && this.npc.getBedPos().method_19442() == this.npc.field_6002.method_27983() && this.isUnderRoof(this.npc.getBedPos().method_19446())) {
                            this.npc.method_18868().method_18878(class_4140.field_19008, (Object)this.npc.getBedPos());
                        } else if (this.npc.getWorkPlace() != null && this.npc.getWorkPlace().method_19442() == this.npc.field_6002.method_27983() && this.isUnderRoof(this.npc.getWorkPlace().method_19446())) {
                            this.npc.method_18868().method_18878(class_4140.field_19008, (Object)this.npc.getWorkPlace());
                        }
                    }
                } else if (!this.isUnderRoof(((class_4208)hide.get()).method_19446())) {
                    this.npc.method_18868().method_18875(class_4140.field_19008);
                }
                this.shelterPOISearchCooldown = 60 + this.npc.method_6051().nextInt(40);
            }
            if (--this.walkCooldown <= 0 && this.npc.method_5942().method_6357()) {
                this.npc.method_18868().method_18904(class_4140.field_19008).ifPresent(p -> {
                    class_243 target;
                    float spd = 1.0f;
                    int acc = 0;
                    if (this.npc.method_5649((double)p.method_19446().method_10263() + 0.5, p.method_19446().method_10264(), (double)p.method_19446().method_10260() + 0.5) < 49.0) {
                        target = this.getRandomPosition(6);
                        if (target != null && this.npc.field_6002.method_8311(new class_2338(target))) {
                            target = null;
                        }
                    } else {
                        target = class_243.method_24953((class_2382)p.method_19446());
                        spd = 1.3f;
                        acc = 4;
                    }
                    if (target != null) {
                        this.setWalkTargetTo(new class_2338(target), spd, acc, () -> this.npc.method_18868().method_18875(class_4140.field_19008));
                        this.walkCooldown = this.npc.method_6051().nextInt(40) + 90;
                    } else {
                        this.walkCooldown = this.npc.method_6051().nextInt(20) + 30;
                    }
                });
            }
            return true;
        }
        if (this.npc.method_18868().method_18904(class_4140.field_19008).isPresent()) {
            this.npc.method_18868().method_18875(class_4140.field_19008);
        }
        return false;
    }

    public void wanderAround() {
        if (this.seekShelter()) {
            return;
        }
        if (this.walkCooldown <= 0 && this.npc.method_5942().method_6357()) {
            class_4076 sectionPos;
            class_4076 sectionPos2;
            class_3218 serverLevel = (class_3218)this.npc.field_6002;
            class_2338 blockPos = this.npc.method_24515();
            class_243 pos = serverLevel.method_19500(blockPos) ? this.getRandomPosition(10) : ((sectionPos2 = class_4215.method_20419((class_3218)serverLevel, (class_4076)(sectionPos = class_4076.method_18682((class_2338)blockPos)), (int)2)) != sectionPos ? this.setTargetedPosTowards(sectionPos2) : this.getRandomPosition(10));
            if (pos != null) {
                this.setWalkTarget(new class_2338(pos), 1.0f, 0);
                this.walkCooldown = this.npc.method_6051().nextInt(40) + 90;
            } else {
                this.walkCooldown = this.npc.method_6051().nextInt(20) + 30;
            }
        }
    }

    private void setWalkTargetTo(class_2338 pos, float speed, int accuracy, Runnable onFail) {
        if (this.tiredOfTryingToFindTarget(this.npc.field_6002, this.npc)) {
            onFail.run();
        } else if (pos.method_19455((class_2382)this.npc.method_24515()) > 100) {
            int i;
            class_243 vec3 = null;
            int attempts = 300;
            for (i = 0; i < attempts && (vec3 == null || this.distManhattan(this.npc.method_19538(), vec3) > 100.0); ++i) {
                vec3 = class_5532.method_31512((class_1314)this.npc, (int)15, (int)7, (class_243)class_243.method_24953((class_2382)pos), (double)1.5707963705062866);
            }
            if (i == attempts || vec3 == null) {
                onFail.run();
                return;
            }
            this.setWalkTarget(new class_2338(vec3), speed, accuracy);
        } else {
            this.setWalkTarget(pos, speed, accuracy);
        }
    }

    private boolean tiredOfTryingToFindTarget(class_1937 level, EntityNPCBase npc) {
        return npc.method_18868().method_18904(class_4140.field_19293).map(l -> level.method_8510() - l > 1000L).orElse(false);
    }

    private double distManhattan(class_243 vec3, class_243 other) {
        double f = Math.abs(vec3.method_10216() - other.method_10216());
        double g = Math.abs(vec3.method_10214() - other.method_10214());
        double h = Math.abs(vec3.method_10215() - other.method_10215());
        return f + g + h;
    }

    private void setWalkTarget(class_2338 pos, float speed, int accuracy) {
        this.npc.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(pos, speed, accuracy));
    }

    private void moveToTarget() {
        if (this.pathFindCooldown <= 0 && this.npc.method_5942().method_6357()) {
            this.npc.method_18868().method_18904(class_4140.field_18445).ifPresent(target -> {
                class_11 path = this.npc.method_5942().method_6348(target.method_19094().method_18989(), target.method_19096());
                boolean canReach = true;
                if (path == null || (canReach = !path.method_21655() && (float)this.npc.method_24515().method_19455((class_2382)target.method_19094().method_18989()) < 85.0f)) {
                    if (!this.npc.method_18868().method_18896(class_4140.field_19293)) {
                        this.npc.method_18868().method_18878(class_4140.field_19293, (Object)this.npc.field_6002.method_8510());
                    }
                    if (path == null) {
                        this.pathFindCooldown = this.npc.method_6051().nextInt(30) + 15;
                        return;
                    }
                }
                if (canReach) {
                    this.npc.method_18868().method_18875(class_4140.field_19293);
                }
                this.npc.method_5942().method_6334(path, (double)target.method_19095());
                this.pathFindCooldown = this.npc.method_6051().nextInt(15) + 15;
            });
        }
        this.npc.method_18868().method_18904(class_4140.field_18445).ifPresent(target -> {
            if (this.npc.method_24515().method_19455((class_2382)target.method_19094().method_18989()) <= target.method_19096()) {
                this.npc.method_18868().method_18875(class_4140.field_18445);
                this.npc.method_5942().method_6340();
            }
        });
    }

    private boolean isUnderRoof(class_2338 pos) {
        return class_2338.method_20437((class_2338)pos.method_10069(-2, 1, -2), (class_2338)pos.method_10069(2, 1, 2)).noneMatch(p -> this.npc.field_6002.method_8311(p) && this.npc.field_6002.method_8598(class_2902.class_2903.field_13197, p).method_10264() <= p.method_10264());
    }

    @Nullable
    protected class_243 getRandomPosition(int radius) {
        if (this.npc.method_5816()) {
            class_243 vec3 = class_5534.method_31527((class_1314)this.npc, (int)15, (int)7);
            return vec3 == null ? class_5532.method_31510((class_1314)this.npc, (int)10, (int)7) : vec3;
        }
        return class_5532.method_31510((class_1314)this.npc, (int)radius, (int)7);
    }

    private class_243 setTargetedPosTowards(class_4076 sectionPos) {
        return class_5532.method_31512((class_1314)this.npc, (int)10, (int)7, (class_243)class_243.method_24955((class_2382)sectionPos.method_19768()), (double)1.5707963705062866);
    }
}

