/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5658;

public class AttackMeleeAction
implements NPCAction {
    public static final Codec<AttackMeleeAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("walk_time").forGetter(d -> d.walkTime), NPCAction.optionalNumCooldown(d -> d.cooldown), (App)Codec.FLOAT.fieldOf("speed").forGetter(d -> Float.valueOf(d.speed))).apply((Applicative)instance, AttackMeleeAction::new));
    private final class_5658 walkTime;
    private final class_5658 cooldown;
    private final float speed;

    private AttackMeleeAction(class_5658 walkTime, Optional<class_5658> cooldown, float speed) {
        this(walkTime, cooldown.orElse(NPCAction.CONST_SEC), speed);
    }

    public AttackMeleeAction(class_5658 walkTime) {
        this(walkTime, NPCAction.CONST_SEC, 1.2f);
    }

    public AttackMeleeAction(class_5658 walkTime, float speed) {
        this(walkTime, NPCAction.CONST_SEC, speed);
    }

    public AttackMeleeAction(class_5658 walkTime, class_5658 cooldown, float speed) {
        this.walkTime = walkTime;
        this.cooldown = cooldown;
        this.speed = speed;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.MELEE_ATTACK;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return this.walkTime.method_366(NPCAction.createLootContext(npc));
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.method_366(NPCAction.createLootContext(npc));
    }

    @Override
    public NPCAction.NPCAttackAction getAction(EntityNPCBase npc) {
        IItemUsable usabe;
        AttackAction action;
        class_1799 hand = npc.method_6047();
        class_1792 class_17922 = hand.method_7909();
        if (class_17922 instanceof IItemUsable && (action = (usabe = (IItemUsable)class_17922).getWeaponType().getAction()) != null) {
            int amount = npc.method_6051().nextInt(action.combos().size()) + 1;
            return new NPCAction.NPCAttackAction(action, amount);
        }
        return null;
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        goal.moveToEntityNearer(goal.getAttackTarget(), this.speed);
        npc.method_5988().method_6226((class_1297)goal.getAttackTarget(), 30.0f, 30.0f);
        double minDist = npc.method_33191(goal.getAttackTarget());
        if (goal.getDistSqr() <= minDist) {
            if (action == null) {
                npc.method_6104(class_1268.field_5808);
                npc.npcAttack(npc::method_6121);
            }
            npc.weaponHandler.setComboCount(npc.method_6051().nextInt(2));
            return true;
        }
        return false;
    }
}

