/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityThrownItem;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5658;

public class FoodThrowAction
implements NPCAction {
    public static final Codec<FoodThrowAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.listOf().fieldOf("items").forGetter(d -> d.items), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("walk_time").forGetter(d -> d.walkTime), NPCAction.optionalNumCooldown(d -> d.cooldown)).apply((Applicative)instance, FoodThrowAction::new));
    private final List<class_1799> items;
    private final class_5658 walkTime;
    private final class_5658 cooldown;

    private FoodThrowAction(List<class_1799> items, class_5658 walkTime, Optional<class_5658> cooldown) {
        this(items, walkTime, cooldown.orElse(NPCAction.CONST_ZERO));
    }

    public FoodThrowAction(List<class_1799> items, class_5658 walkTime) {
        this(items, walkTime, NPCAction.CONST_ZERO);
    }

    public FoodThrowAction(List<class_1799> items, class_5658 walkTime, class_5658 cooldown) {
        this.items = items;
        this.walkTime = walkTime;
        this.cooldown = cooldown;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.FOOD_THROW_ACTION;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return this.walkTime.method_366(NPCAction.createLootContext(npc));
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.method_366(NPCAction.createLootContext(npc));
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        if (npc.followEntity() == null || this.items.isEmpty()) {
            return true;
        }
        goal.moveToEntity((class_1309)npc.followEntity(), 1.0f, 2);
        npc.method_5988().method_6226((class_1297)npc.followEntity(), 30.0f, 30.0f);
        if (npc.method_5858((class_1297)npc.followEntity()) <= 30.0) {
            npc.method_6104(class_1268.field_5808);
            class_1799 stack = this.items.get(npc.method_6051().nextInt(this.items.size())).method_7972();
            EntityThrownItem entity = new EntityThrownItem(npc.field_6002, (class_1309)npc);
            entity.setItem(stack);
            entity.setActAsFood(true);
            entity.shootAtEntity((class_1297)npc.followEntity(), 0.6f, 0.0f);
            npc.field_6002.method_8649((class_1297)entity);
            npc.method_5942().method_6340();
            return true;
        }
        return false;
    }
}

