/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_2048;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_6011;

public class NPCAttackActions {
    public static final Codec<NPCAttackActions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WeightedAction.CODEC.listOf().fieldOf("actions").forGetter(d -> d.actions)).apply((Applicative)instance, NPCAttackActions::new));
    public static final NPCAttackActions DEFAULT = new NPCAttackActions(List.of());
    private final List<WeightedAction> actions;

    public NPCAttackActions(List<WeightedAction> chainedActions) {
        this.actions = ImmutableList.copyOf(chainedActions);
    }

    public List<NPCAction> getAction(EntityNPCBase npc) {
        List<WeightedAction> list = this.actions.stream().filter(w -> w.predicate.method_8909((class_3218)npc.field_6002, npc.method_19538(), (class_1297)npc)).toList();
        if (list.isEmpty()) {
            return List.of();
        }
        return class_6011.method_34986((Random)npc.method_6051(), list).map(w -> w.chainedActions).orElse(List.of());
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public static class WeightedAction
    implements class_6008 {
        public static final Codec<WeightedAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("weight").forGetter(d -> d.weight.method_34976()), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> d.predicate == class_2048.field_9599 ? Optional.empty() : Optional.of(d.predicate)), (App)CodecUtils.registryCodec(ModNPCActions.ACTIONS_REGISTRY_KEY).dispatchStable(c -> c.codec().get(), c -> c.codec).listOf().fieldOf("concurrent_actions").forGetter(d -> d.chainedActions)).apply((Applicative)instance, (weight, pred, concurrent) -> new WeightedAction((int)weight, pred.orElse(class_2048.field_9599), (List<NPCAction>)concurrent)));
        private final class_6007 weight;
        private final class_2048 predicate;
        private final List<NPCAction> chainedActions;

        public WeightedAction(int weight, class_2048 predicate, List<NPCAction> chainedActions) {
            this.weight = class_6007.method_34977((int)weight);
            this.predicate = predicate;
            this.chainedActions = chainedActions;
        }

        public class_6007 method_34979() {
            return this.weight;
        }
    }

    public static class ActionBuilder {
        private final int weight;
        private class_2048 predicate = class_2048.field_9599;
        private final List<NPCAction> chainedActions = new ArrayList<NPCAction>();

        public ActionBuilder(int weight) {
            this.weight = weight;
        }

        public ActionBuilder predicate(class_2048 predicate) {
            this.predicate = predicate;
            return this;
        }

        public ActionBuilder action(NPCAction action) {
            this.chainedActions.add(action);
            return this;
        }

        public WeightedAction build() {
            return new WeightedAction(this.weight, this.predicate, this.chainedActions);
        }
    }

    public static class Builder {
        private final List<WeightedAction> chainedActions = new ArrayList<WeightedAction>();

        public Builder addAction(ActionBuilder builder) {
            this.chainedActions.add(builder.build());
            return this;
        }

        public NPCAttackActions build() {
            return new NPCAttackActions(this.chainedActions);
        }
    }
}

