/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2941;
import net.minecraft.class_2960;

public class SyncableEntityData {
    private static final Map<class_2960, SyncedEntityData<?>> REGISTRY = new HashMap();

    public static synchronized <T> SyncedEntityData<T> register(class_2960 id, class_2941<T> serializer) {
        return SyncableEntityData.register(new SyncedEntityData<T>(id, serializer));
    }

    public static synchronized <T> SyncedEntityData<T> register(SyncedEntityData<T> inst) {
        if (REGISTRY.putIfAbsent(inst.id, inst) != null) {
            throw new IllegalStateException("ID is already registered");
        }
        return inst;
    }

    public static synchronized <T> SyncedEntityData<T> get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public record SyncedEntityData<T>(class_2960 id, class_2941<T> serializer) {
    }

    public static class SyncedContainer<T> {
        private final SyncedEntityData<T> syncedEntityData;
        private final T value;

        public SyncedContainer(SyncedEntityData<T> syncedEntityData, T value) {
            this.syncedEntityData = syncedEntityData;
            this.value = value;
        }

        public <E> void runIf(SyncedEntityData<E> other, Consumer<E> cons) {
            if (this.syncedEntityData.equals(other)) {
                T v = this.value;
                cons.accept(v);
            }
        }

        public void write(class_2540 buf) {
            buf.method_10812(this.syncedEntityData.id);
            buf.writeBoolean(this.value != null);
            if (this.value != null) {
                this.syncedEntityData.serializer().method_12715(buf, this.value);
            }
        }

        public static <T> SyncedContainer<T> from(class_2540 buf) {
            class_2960 id = buf.method_10810();
            SyncedEntityData data = SyncableEntityData.get(id);
            boolean none = buf.readBoolean();
            return new SyncedContainer<Object>(data, (none ? data.serializer().method_12716(buf) : null));
        }
    }
}

