/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1160;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class EntityAmbrosiaWave
extends BaseDamageCloud {
    private static final class_2940<Integer> MAX_TICK = class_2945.method_12791(EntityAmbrosiaWave.class, (class_2941)class_2943.field_13327);
    private static final List<class_1160> CIRCLE_PARTICLE_MOTION = RayTraceUtils.rotatedVecs((class_243)new class_243(0.25, 0.0, 0.0), (class_243)new class_243(0.0, 1.0, 0.0), (float)-180.0f, (float)175.0f, (float)5.0f);
    private final Set<FrozenEntity> hitEntityPos = new HashSet<FrozenEntity>();

    public EntityAmbrosiaWave(class_1299<? extends EntityAmbrosiaWave> type, class_1937 level) {
        super(type, level);
        this.damageMultiplier = 0.3f;
    }

    public EntityAmbrosiaWave(class_1937 level, class_1309 shooter, int maxLivingTick) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)ModEntities.AMBROSIA_WAVE.get()), level, shooter);
        this.field_6011.method_12778(MAX_TICK, (Object)maxLivingTick);
        this.damageMultiplier = 0.3f;
    }

    public float radiusIncrease() {
        return 0.5f;
    }

    public double maxRadius() {
        return 5.0;
    }

    public int livingTickMax() {
        return (Integer)this.field_6011.method_12789(MAX_TICK);
    }

    public boolean canStartDamage() {
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MAX_TICK, (Object)140);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            if (this.livingTicks < (Integer)this.field_6011.method_12789(MAX_TICK) - 8 && this.livingTicks % 5 == 1) {
                for (class_1160 vec : CIRCLE_PARTICLE_MOTION) {
                    this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.STATIC_LIGHT.get(), 0.78431374f, 0.52156866f, 0.14117648f, 1.0f, 0.4f), this.method_23317(), this.method_23318() + 0.2, this.method_23321(), (double)vec.method_4943(), (double)vec.method_4945(), (double)vec.method_4947());
                }
            }
        } else {
            if (this.canStartDamage()) {
                this.method_5783((class_3414)ModSounds.ENTITY_AMBROSIA_WAVE.get(), 1.0f, 1.0f);
            }
            if (this.method_35057() != null && !this.method_35057().method_5805()) {
                this.method_31472();
            }
            this.hitEntityPos.forEach(frozenEntity -> {
                class_1309 patt3506$temp = frozenEntity.entity;
                if (patt3506$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt3506$temp;
                    player.method_24203(frozenEntity.pos.method_10216(), frozenEntity.pos.method_10214(), frozenEntity.pos.method_10215());
                } else {
                    frozenEntity.entity.method_5814(frozenEntity.pos.method_10216(), frozenEntity.pos.method_10214(), frozenEntity.pos.method_10215());
                }
            });
        }
    }

    @Override
    protected boolean canHit(class_1309 e) {
        return super.canHit(e) && e.method_5858((class_1297)this) <= (double)(this.getRadius() * this.getRadius());
    }

    protected class_238 damageBoundingBox() {
        float radius = this.getRadius();
        return this.method_5829().method_1009((double)radius, 0.75, (double)radius);
    }

    protected boolean damageEntity(class_1309 e) {
        CustomDamage.Builder builder = new CustomDamage.Builder((class_1297)this, this.method_35057()).magic().noKnockback().hurtResistant(5).element(EnumElement.EARTH).withChangedAttribute((class_1320)ModAttributes.DRAIN.get(), 50.0);
        if (CombatUtils.damageWithFaintAndCrit(this.method_35057(), (class_1297)e, builder, CombatUtils.getAttributeValue(this.method_35057(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            e.method_6092(new class_1293(class_1294.field_5909, 10, 6, true, false));
            this.hitEntityPos.add(new FrozenEntity(e, e.method_19538()));
            return true;
        }
        return false;
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(MAX_TICK, (Object)compound.method_10550("MaxTick"));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("MaxTick", ((Integer)this.field_6011.method_12789(MAX_TICK)).intValue());
    }

    record FrozenEntity(class_1309 entity, class_243 pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FrozenEntity) {
                FrozenEntity frozenEntity = (FrozenEntity)obj;
                return this.entity == frozenEntity.entity;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entity.method_5667().hashCode();
        }
    }
}

