/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class EntityAppleProjectile
extends BaseProjectile {
    private static final class_2940<Float> SIZE = class_2945.method_12791(EntityAppleProjectile.class, (class_2941)class_2943.field_13320);
    private boolean circling;
    private int angleOffset;
    private int circleTime;

    public EntityAppleProjectile(class_1299<? extends BaseProjectile> type, class_1937 world) {
        super(type, world);
    }

    public EntityAppleProjectile(class_1937 world, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)ModEntities.APPLE.get()), world, shooter);
    }

    public void setAngleOffset(int angleOffset) {
        this.angleOffset = angleOffset;
    }

    public void setCircling(boolean circling, int circleTime) {
        this.circling = circling;
        this.circleTime = circleTime;
    }

    public void withSizeInc(float size) {
        this.field_6011.method_12778(SIZE, (Object)Float.valueOf(size));
    }

    public int livingTickMax() {
        return 400;
    }

    public float radius() {
        return ((Float)this.field_6011.method_12789(SIZE)).floatValue();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SIZE, (Object)Float.valueOf(0.0f));
    }

    public float getScale() {
        return ((Float)this.field_6011.method_12789(SIZE)).floatValue() + 1.0f;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            --this.circleTime;
            class_1297 owner = this.method_24921();
            if (owner == null) {
                this.method_31472();
            } else if (this.circling) {
                if (this.circleTime > 0) {
                    class_243 ownerPos = owner.method_19538();
                    double[] pos = MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)((double)owner.method_17681() + 0.5), (double)0.0, (double)0.0, (float)((float)Math.PI / 180 * (float)(13 * this.livingTicks + this.angleOffset)));
                    this.method_18800(ownerPos.field_1352 + pos[0] - this.method_23317(), ownerPos.field_1351 + (double)this.method_24921().method_17682() * 0.25 - this.method_23318(), ownerPos.field_1350 + pos[2] - this.method_23321());
                    this.field_6007 = true;
                } else if (this.circleTime == 0) {
                    class_1308 mob;
                    if (owner instanceof class_1308 && (mob = (class_1308)owner).method_5968() != null) {
                        this.shootAtEntity((class_1297)mob.method_5968(), 1.0f, 0.0f);
                    } else {
                        this.shoot(owner, owner.method_36455(), owner.method_36454(), 0.0f, 1.0f, 0.0f);
                    }
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return this.circling ? 0.005f : super.getGravityVelocity();
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).knock(CustomDamage.KnockBackType.NONE).hurtResistant(4).projectile(), CombatUtils.getAttributeValue(this.method_24921(), class_5134.field_23721) * (double)this.damageMultiplier, null)) {
            this.method_31472();
            return true;
        }
        return false;
    }

    protected void onBlockHit(class_3965 result) {
        if (!this.circling || this.circleTime < 0) {
            this.method_31472();
        }
    }

    protected class_3966 getEntityHit(class_243 from, class_243 to) {
        if (!this.method_5805()) {
            return null;
        }
        if (this.attackedEntities.isEmpty()) {
            return RayTraceUtils.rayTraceEntities((class_1937)this.field_6002, (class_1297)this, (class_243)from, (class_243)to, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::canHit, e -> this.radius() + 0.3f);
        }
        return null;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.circling = compound.method_10577("Circling");
        this.circleTime = compound.method_10550("CirclingTime");
        this.angleOffset = compound.method_10550("AngleOffset");
        this.withSizeInc(compound.method_10583("Size"));
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Circling", this.circling);
        compound.method_10569("CirclingTime", this.circleTime);
        compound.method_10569("AngleOffset", this.angleOffset);
        compound.method_10548("Size", ((Float)this.field_6011.method_12789(SIZE)).floatValue());
    }
}

