/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class EntityBigRaccoonLeaf
extends BaseProjectile {
    private static final class_2940<Boolean> SPIN = class_2945.method_12791(EntityBigRaccoonLeaf.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> INITIAL_YAW = class_2945.method_12791(EntityBigRaccoonLeaf.class, (class_2941)class_2943.field_13320);
    private double diameter;
    private class_243 axis;
    private class_243 dir;
    private class_243 center;
    private float sumAngles;

    public EntityBigRaccoonLeaf(class_1299<? extends BaseProjectile> type, class_1937 world) {
        super(type, world);
    }

    public EntityBigRaccoonLeaf(class_1937 world, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)ModEntities.BIG_RACCOON_LEAF.get()), world, shooter);
        if (shooter.method_17682() > 2.0f) {
            this.method_5814(this.method_23317(), shooter.method_23318() + (double)shooter.method_17682() * 0.5, this.method_23321());
        }
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
        this.field_6011.method_12778(INITIAL_YAW, (Object)Float.valueOf(this.method_36454()));
        this.dir = this.method_18798();
        this.axis = this.method_18863(-this.method_5695(1.0f), -this.method_5705(1.0f));
    }

    public void setDiameter(double diameter) {
        this.diameter = Math.max(diameter, 1.0);
    }

    public float radius() {
        return 0.5f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SPIN, (Object)false);
        this.field_6011.method_12784(INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return 30;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            if (this.diameter > 0.0) {
                class_243 toCenterDir = this.dir.method_1029().method_1021(this.diameter * 0.5);
                if (this.center == null) {
                    this.center = this.method_19538().method_1019(toCenterDir);
                }
                float angle = (float)(Math.PI * 2 / (double)this.livingTickMax() * this.dir.method_1033());
                if (!this.spinRight()) {
                    angle *= -1.0f;
                }
                if (this.sumAngles == 0.0f) {
                    this.sumAngles += angle * 3.0f;
                }
                double[] point = MathUtils.rotate((double)this.axis.field_1352, (double)this.axis.field_1351, (double)this.axis.field_1350, (double)(-toCenterDir.field_1352), (double)(-toCenterDir.field_1351), (double)(-toCenterDir.field_1350), (float)this.sumAngles);
                this.sumAngles += angle;
                class_243 newPos = new class_243(point[0], point[1], point[2]).method_1019(this.center);
                this.method_18799(newPos.method_1020(this.method_19538()));
                this.field_6007 = true;
            }
            if ((double)this.sumAngles >= Math.PI * 2) {
                this.method_31472();
            }
        }
    }

    public void withRightSpin(boolean spin) {
        this.field_6011.method_12778(SPIN, (Object)spin);
    }

    public boolean spinRight() {
        return (Boolean)this.field_6011.method_12789(SPIN);
    }

    public float initialYaw() {
        return ((Float)this.field_6011.method_12789(INITIAL_YAW)).floatValue();
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(2).element(EnumElement.EARTH), CombatUtils.getAttributeValue(this.method_24921(), class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (att) {
            this.method_31472();
        }
        return att;
    }

    protected void onBlockHit(class_3965 result) {
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.diameter = compound.method_10574("Diameter");
        class_2499 listTag = compound.method_10554("Axis", 6);
        this.axis = new class_243(listTag.method_10611(0), listTag.method_10611(1), listTag.method_10611(2));
        listTag = compound.method_10554("Direction", 6);
        this.dir = new class_243(listTag.method_10611(0), listTag.method_10611(1), listTag.method_10611(2));
        listTag = compound.method_10554("Center", 6);
        this.center = new class_243(listTag.method_10611(0), listTag.method_10611(1), listTag.method_10611(2));
        this.sumAngles = compound.method_10583("Angles");
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10549("Diameter", this.diameter);
        compound.method_10566("Axis", (class_2520)this.method_5846(new double[]{this.axis.field_1352, this.axis.field_1351, this.axis.field_1350}));
        compound.method_10566("Direction", (class_2520)this.method_5846(new double[]{this.dir.field_1352, this.dir.field_1351, this.dir.field_1350}));
        compound.method_10566("Center", (class_2520)this.method_5846(new double[]{this.center.field_1352, this.center.field_1351, this.center.field_1350}));
        compound.method_10549("Angles", (double)this.sumAngles);
    }
}

