/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class EntityBullet
extends BaseProjectile {
    private static final float[] SIN_POINTS = EntityBullet.calcSinPoints();
    private static final class_2940<Integer> ELEMENT_DATA = class_2945.method_12791(EntityBullet.class, (class_2941)class_2943.field_13327);
    private EnumElement element = EnumElement.NONE;
    private boolean straight;
    private boolean reverse;
    private class_243 dir;
    private class_243 side;

    public EntityBullet(class_1299<? extends EntityBullet> type, class_1937 level) {
        super(type, level);
    }

    public EntityBullet(class_1937 level, class_1309 thrower) {
        super((class_1299<? extends BaseProjectile>)((class_1299)ModEntities.CIRCLING_BULLET.get()), level, thrower);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = class_3532.method_15362((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ELEMENT_DATA, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = EnumElement.values()[(Integer)this.field_6011.method_12789(ELEMENT_DATA)];
        }
        super.method_5674(key);
    }

    public void setElement(EnumElement element) {
        this.element = element;
        this.field_6011.method_12778(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public EnumElement element() {
        return this.element;
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
        class_243 up = this.method_18863(-this.method_5695(1.0f), -this.method_5705(1.0f)).method_1029();
        this.dir = this.method_18798();
        this.side = new class_243(RayTraceUtils.rotatedAround((class_243)this.dir, (class_1160)new class_1160(up), (float)90.0f)).method_1029();
    }

    public void reverseMovement() {
        this.reverse = !this.reverse;
    }

    public void setStraight() {
        this.straight = true;
    }

    public int livingTickMax() {
        return this.straight ? 20 : 50;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236 && !this.straight && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = this.reverse ? -SIN_POINTS[t] : SIN_POINTS[t] * 2.0f;
            this.method_18800(this.dir.field_1352 + this.side.field_1352 * (double)sT, this.dir.field_1351 + this.side.field_1351 * (double)sT, this.dir.field_1350 + this.side.field_1350 * (double)sT);
            this.field_6007 = true;
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        boolean res = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(0).element(this.element).projectile(), CombatUtils.getAttributeValue(this.method_24921(), class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (res) {
            this.method_31472();
        }
        return res;
    }

    protected void onBlockHit(class_3965 result) {
        this.method_31472();
    }
}

