/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class EntityButterfly
extends BaseProjectile {
    protected static final class_2940<Float> LOCKED_YAW = class_2945.method_12791(EntityButterfly.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> LOCKED_PITCH = class_2945.method_12791(EntityButterfly.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Optional<UUID>> HIT = class_2945.method_12791(EntityButterfly.class, (class_2941)class_2943.field_13313);
    protected static final class_2940<Float> HIT_X = class_2945.method_12791(EntityButterfly.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> HIT_Y = class_2945.method_12791(EntityButterfly.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> HIT_Z = class_2945.method_12791(EntityButterfly.class, (class_2941)class_2943.field_13320);
    private static final int DEFAULT_MAX_TICK = 50;
    private class_1309 stuckEntity;
    private int livingTickMax = 50;

    public EntityButterfly(class_1299<? extends EntityButterfly> type, class_1937 level) {
        super(type, level);
        this.damageMultiplier = 0.15f;
    }

    public EntityButterfly(class_1937 level, class_1309 thrower) {
        super((class_1299<? extends BaseProjectile>)((class_1299)ModEntities.BUTTERFLY.get()), level, thrower);
        this.damageMultiplier = 0.15f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LOCKED_YAW, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LOCKED_PITCH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(HIT, Optional.empty());
        this.field_6011.method_12784(HIT_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(HIT_Y, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(HIT_Z, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return this.livingTickMax;
    }

    public void method_5773() {
        super.method_5773();
        class_1309 stuck = this.getHitEntity();
        if (stuck != null) {
            this.method_36457(((Float)this.field_6011.method_12789(LOCKED_PITCH)).floatValue());
            this.method_36456(((Float)this.field_6011.method_12789(LOCKED_YAW)).floatValue());
            class_243 pos = stuck.method_19538().method_1031((double)((Float)this.field_6011.method_12789(HIT_X)).floatValue(), (double)((Float)this.field_6011.method_12789(HIT_Y)).floatValue(), (double)((Float)this.field_6011.method_12789(HIT_Z)).floatValue());
            this.method_33574(pos);
            if (!this.field_6002.field_9236 && this.livingTicks % 40 == 0 && this.method_24921() != null) {
                class_1297 class_12972 = this.method_24921();
                if (class_12972 instanceof class_1309) {
                    class_1309 living = (class_1309)class_12972;
                    CombatUtils.applyTempAttribute(living, (class_1320)ModAttributes.DRAIN.get(), 80.0);
                }
                CustomDamage.Builder builder = new CustomDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(0);
                builder.get().hurtEntity((class_1297)stuck, (float)(CombatUtils.getAttributeValue(this.method_24921(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier * 0.7));
                class_1297 class_12973 = this.method_24921();
                if (class_12973 instanceof class_1309) {
                    class_1309 living = (class_1309)class_12973;
                    CombatUtils.removeTempAttribute(living, (class_1320)ModAttributes.DRAIN.get());
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(5), CombatUtils.getAttributeValue(this.method_24921(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            class_1297 class_12972 = result.method_17782();
            if (class_12972 instanceof class_1309) {
                class_1309 livingTarget = (class_1309)class_12972;
                this.hitEntity(livingTarget);
            } else {
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    private void hitEntity(class_1309 target) {
        target.method_6092(new class_1293(class_1294.field_5909, 60, 3));
        this.livingTickMax += 60;
        this.field_6011.method_12778(LOCKED_PITCH, (Object)Float.valueOf(this.method_36455()));
        this.field_6011.method_12778(LOCKED_YAW, (Object)Float.valueOf(this.method_36454()));
        this.field_6011.method_12778(HIT, Optional.of(target.method_5667()));
        class_243 dir = this.method_19538().method_1019(this.method_18798().method_1021(1.5)).method_1020(target.method_19538()).method_1021(0.98);
        this.field_6011.method_12778(HIT_X, (Object)Float.valueOf((float)dir.method_10216()));
        this.field_6011.method_12778(HIT_Y, (Object)Float.valueOf((float)dir.method_10214()));
        this.field_6011.method_12778(HIT_Z, (Object)Float.valueOf((float)dir.method_10215()));
    }

    protected void onBlockHit(class_3965 blockRayTraceResult) {
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(LOCKED_PITCH, (Object)Float.valueOf(compound.method_10583("LockedPitch")));
        this.field_6011.method_12778(LOCKED_YAW, (Object)Float.valueOf(compound.method_10583("LockedYaw")));
        if (compound.method_25928("HitEntity")) {
            this.field_6011.method_12778(HIT, Optional.of(compound.method_25926("HitEntity")));
        }
        this.field_6011.method_12778(HIT_X, (Object)Float.valueOf(compound.method_10583("HitX")));
        this.field_6011.method_12778(HIT_Y, (Object)Float.valueOf(compound.method_10583("HitY")));
        this.field_6011.method_12778(HIT_Z, (Object)Float.valueOf(compound.method_10583("HitZ")));
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("LockedPitch", ((Float)this.field_6011.method_12789(LOCKED_PITCH)).floatValue());
        compound.method_10548("LockedYaw", ((Float)this.field_6011.method_12789(LOCKED_YAW)).floatValue());
        ((Optional)this.field_6011.method_12789(HIT)).ifPresent(id -> compound.method_25927("HitEntity", id));
        compound.method_10548("HitX", ((Float)this.field_6011.method_12789(HIT_X)).floatValue());
        compound.method_10548("HitY", ((Float)this.field_6011.method_12789(HIT_Y)).floatValue());
        compound.method_10548("HitZ", ((Float)this.field_6011.method_12789(HIT_Z)).floatValue());
    }

    public class_1309 getHitEntity() {
        if (this.stuckEntity != null && !this.stuckEntity.method_31481()) {
            return this.stuckEntity;
        }
        ((Optional)this.field_6011.method_12789(HIT)).ifPresent(uuid -> {
            this.stuckEntity = (class_1309)EntityUtil.findFromUUID(class_1309.class, (class_1937)this.field_6002, (UUID)uuid);
            this.onUpdateOwner();
        });
        return this.stuckEntity;
    }
}

