/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolFishingRod;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.runecraftory.mixinhelper.ExtendedFishingRodHookTrigger;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_52;

public class EntityCustomFishingHook
extends EntityProjectile {
    private static final class_2940<Boolean> DATA_BITING = class_2945.method_12791(EntityCustomFishingHook.class, (class_2941)class_2943.field_13323);
    private boolean inFishingSpot;
    private boolean inSand;
    private EnumElement element = EnumElement.NONE;
    private class_3610 currentFluidState;
    private int nibble;
    private int timeUntilBite;
    private float fishAngle;
    private final int luck;
    private final int lureSpeedBonus;
    private final int nibbleBonus;
    private int difficultyBonus;
    private BooleanSupplier canAttack;
    private Runnable setOnCooldown;

    public EntityCustomFishingHook(class_1299<? extends EntityCustomFishingHook> entityType, class_1937 level) {
        super(entityType, level);
        this.luck = 0;
        this.lureSpeedBonus = 0;
        this.nibbleBonus = 0;
    }

    public EntityCustomFishingHook(class_1937 world, class_1309 shooter, int speed, int luck, int charge) {
        super((class_1299)ModEntities.FISHING_HOOK.get(), world, shooter);
        this.method_5814(this.method_23317(), this.method_23318() + 0.1, this.method_23321());
        this.shoot((class_1297)shooter, Math.max(-90.0f, shooter.method_36455() - 5.0f), shooter.method_36454(), 0.0f, 1.1f + Math.max(-0.3f, class_3532.method_15374((float)(-shooter.method_36455() * ((float)Math.PI / 180)))), 0.0f);
        this.lureSpeedBonus = speed;
        this.luck = luck;
        this.nibbleBonus = charge;
    }

    public void setElement(EnumElement element) {
        this.element = element;
    }

    public void attackHandlingPlayer(BooleanSupplier canAttack, Runnable runnable) {
        this.canAttack = canAttack;
        this.setOnCooldown = runnable;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_BITING, (Object)false);
    }

    public void method_5773() {
        if (this.shouldStopFishing()) {
            return;
        }
        class_2338 blockPos = this.method_24515();
        class_2680 state = this.field_6002.method_8320(blockPos);
        class_2680 below = this.field_6002.method_8320(new class_2338(this.method_19538().method_1031(0.0, -0.2, 0.0)));
        this.currentFluidState = this.field_6002.method_8316(blockPos);
        float fluid = 0.0f;
        this.inSand = false;
        if (this.currentFluidState.method_15767(class_3486.field_15517)) {
            fluid = this.currentFluidState.method_15763((class_1922)this.field_6002, blockPos);
        } else if (state.method_26215() && below.method_26164(class_3481.field_15466)) {
            this.inFishingSpot = true;
            this.inSand = true;
        }
        if (!this.inFishingSpot && fluid > 0.0f) {
            this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
            this.inFishingSpot = true;
            return;
        }
        if (this.inFishingSpot) {
            boolean canFish;
            class_243 vec3 = this.method_18798();
            double d = this.method_23318() + vec3.field_1351 - (double)blockPos.method_10264() - (double)fluid;
            if (Math.abs(d) < 0.01) {
                d += Math.signum(d) * 0.1;
            }
            this.method_18800(vec3.field_1352 * 0.9, vec3.field_1351 - d * (double)this.field_5974.nextFloat() * 0.2, vec3.field_1350 * 0.9);
            boolean bl = canFish = (fluid > 0.0f || this.inSand) && this.correctLocation(blockPos);
            if (canFish) {
                if (((Boolean)this.field_6011.method_12789(DATA_BITING)).booleanValue()) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.field_5974.nextFloat() * (double)this.field_5974.nextFloat(), 0.0));
                }
                if (!this.field_6002.field_9236) {
                    this.doFishing();
                }
            }
        }
        super.method_5773();
    }

    public void moveEntity() {
        if (!this.currentFluidState.method_15767(class_3486.field_15517)) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)(-this.getGravityVelocity()), 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_26962();
        if (!this.inFishingSpot && (this.field_5952 || this.field_5976)) {
            this.method_18799(class_243.field_1353);
        }
        this.method_18799(this.method_18798().method_1021((double)this.motionReduction(this.method_5799())));
        this.method_23311();
    }

    protected float motionReduction(boolean inWater) {
        return 0.92f;
    }

    public boolean isPiercing() {
        return true;
    }

    public int maxPierceAmount() {
        return 5;
    }

    protected boolean entityRayTraceHit(class_3966 entityHitResult) {
        if (this.canAttack != null && !this.canAttack.getAsBoolean()) {
            this.method_31472();
            return false;
        }
        boolean att = CombatUtils.damageWithFaintAndCrit(this.method_24921(), entityHitResult.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).noKnockback().element(this.element).hurtResistant(5), CombatUtils.getAttributeValue(this.method_24921(), class_5134.field_23721), null);
        if (att && this.setOnCooldown != null) {
            this.setOnCooldown.run();
            this.setOnCooldown = null;
            this.canAttack = null;
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_3222) {
                class_3222 player = (class_3222)class_12972;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                    LevelCalc.levelSkill(player, data, EnumSkills.FISHING, 10.0f);
                    LevelCalc.levelSkill(player, data, EnumSkills.WATER, 1.0f);
                });
            }
        }
        return att;
    }

    protected void onBlockHit(class_3965 blockHitResult) {
        this.method_18799(this.method_18798().method_1029().method_1021(blockHitResult.method_24801((class_1297)this)));
    }

    public boolean method_5822() {
        return false;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                data.fishingHook = null;
            });
        }
    }

    public void method_36209() {
        super.method_36209();
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                data.fishingHook = null;
            });
        }
    }

    public void onUpdateOwner() {
        super.onUpdateOwner();
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                data.fishingHook = this;
            });
        }
    }

    private boolean shouldStopFishing() {
        class_1297 class_12972 = this.method_24921();
        if (!(class_12972 instanceof class_1309)) {
            return true;
        }
        class_1309 entity = (class_1309)class_12972;
        class_1799 itemStack = entity.method_6047();
        class_1799 itemStack2 = entity.method_6079();
        boolean bl = itemStack.method_7909() instanceof ItemToolFishingRod;
        boolean bl2 = itemStack2.method_7909() instanceof ItemToolFishingRod;
        if (entity.method_31481() || !entity.method_5805() || !bl && !bl2 || this.method_5858((class_1297)entity) > 1024.0) {
            this.method_31472();
            return true;
        }
        return false;
    }

    private boolean correctLocation(class_2338 blockPos) {
        for (int i = -1; i < 2; ++i) {
            int state = i != 1 ? 0 : 1;
            int yD = this.inSand ? i - 1 : i;
            boolean check = class_2338.method_20437((class_2338)blockPos.method_10069(-1, yD, -1), (class_2338)blockPos.method_10069(1, yD, 1)).allMatch(p -> this.blockCheck((class_2338)p, state) != LocationType.INVALID);
            if (check) continue;
            return false;
        }
        return true;
    }

    private LocationType blockCheck(class_2338 blockPos, int state) {
        class_2680 blockState = this.field_6002.method_8320(blockPos);
        if (state != 0 && (blockState.method_26215() || blockState.method_27852(class_2246.field_10588))) {
            return LocationType.AIR;
        }
        if (this.inSand) {
            if (state != 1 && blockState.method_26164(class_3481.field_15466)) {
                return LocationType.MATCH;
            }
            return LocationType.INVALID;
        }
        class_3610 fluidState = blockState.method_26227();
        if (state != 1 && fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && blockState.method_26220((class_1922)this.field_6002, blockPos).method_1110()) {
            return LocationType.MATCH;
        }
        return LocationType.INVALID;
    }

    protected void doFishing() {
        class_1937 class_19372 = this.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilBite = 0;
                this.method_5841().method_12778(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilBite > 0) {
            --this.timeUntilBite;
            float splashChance = 0.15f;
            if (this.timeUntilBite < 20) {
                splashChance += (float)(20 - this.timeUntilBite) * 0.05f;
            } else if (this.timeUntilBite < 40) {
                splashChance += (float)(40 - this.timeUntilBite) * 0.02f;
            } else if (this.timeUntilBite < 60) {
                splashChance += (float)(60 - this.timeUntilBite) * 0.01f;
            }
            if (this.field_5974.nextFloat() < splashChance) {
                float a = class_3532.method_15344((Random)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float c = class_3532.method_15344((Random)this.field_5974, (float)25.0f, (float)60.0f);
                double x = this.method_23317() + (double)(class_3532.method_15374((float)a) * c) * 0.1;
                double y = (float)class_3532.method_15357((double)this.method_23318()) + 1.0f;
                double z = this.method_23321() + (double)(class_3532.method_15362((float)a) * c) * 0.1;
                if (this.inSand) {
                    class_243 belowPos = this.method_19538().method_1031(0.0, -0.2, 0.0);
                    class_2680 below = this.field_6002.method_8320(new class_2338(x, belowPos.field_1351, z));
                    if (below.method_26164(class_3481.field_15466)) {
                        serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, below), x, y - 0.9, z, 2 + this.field_5974.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                    }
                } else if (serverLevel.method_8320(new class_2338(x, y - 1.0, z)).method_27852(class_2246.field_10382)) {
                    serverLevel.method_14199((class_2394)class_2398.field_11202, x, y, z, 2 + this.field_5974.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilBite > 0) {
                this.fishAngle = (float)((double)this.fishAngle + this.field_5974.nextGaussian() * 4.0);
                float angle = this.fishAngle * ((float)Math.PI / 180);
                float g = class_3532.method_15374((float)angle);
                float h = class_3532.method_15362((float)angle);
                double y = (float)class_3532.method_15357((double)this.method_23318()) + 1.0f;
                double z = this.method_23321() + (double)(h * (float)this.timeUntilBite * 0.1f);
                double x = this.method_23317() + (double)(g * (float)this.timeUntilBite * 0.1f);
                if (this.inSand) {
                    y -= 1.0;
                }
                class_2680 blockState = serverLevel.method_8320(new class_2338(x, y - 1.0, z));
                if (this.inSand && blockState.method_27852(class_2246.field_10102) || !this.inSand && blockState.method_27852(class_2246.field_10382)) {
                    class_2400 bubble = class_2398.field_11247;
                    class_2400 particle = class_2398.field_11247;
                    if (this.inSand) {
                        particle = bubble = new class_2388(class_2398.field_11217, blockState);
                        y += 0.1;
                    }
                    if (this.field_5974.nextFloat() < 0.15f) {
                        serverLevel.method_14199((class_2394)bubble, x, y - (double)0.1f, z, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverLevel.method_14199((class_2394)particle, x, y, z, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverLevel.method_14199((class_2394)particle, x, y, z, 0, (double)(-l), 0.01, (double)k, 1.0);
                }
            } else {
                this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.4f);
                double m = this.method_23318() + 0.5;
                class_2400 particle = class_2398.field_11247;
                if (this.inSand) {
                    class_2680 below = this.field_6002.method_8320(new class_2338(this.method_19538().method_1031(0.0, -0.2, 0.0)));
                    particle = new class_2388(class_2398.field_11217, below);
                }
                serverLevel.method_14199((class_2394)particle, this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                if (!this.inSand) {
                    serverLevel.method_14199((class_2394)class_2398.field_11244, this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                }
                serverLevel.method_14199((class_2394)class_2398.field_11224, this.method_23317(), m, this.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
                this.difficultyBonus = class_3532.method_15395((Random)this.field_5974, (int)0, (int)3);
                this.nibble = class_3532.method_15395((Random)this.field_5974, (int)12, (int)(30 - this.difficultyBonus * 3)) - this.difficultyBonus * 5;
                this.nibble += this.nibbleBonus * 3;
                this.nibble = Math.max(1, this.nibble);
                this.method_5841().method_12778(DATA_BITING, (Object)true);
            }
        } else {
            this.fishAngle = class_3532.method_15344((Random)this.field_5974, (float)0.0f, (float)360.0f);
            this.timeUntilBite = class_3532.method_15395((Random)this.field_5974, (int)Math.max(5, 100 - this.lureSpeedBonus * 15), (int)Math.max(50, 600 - this.lureSpeedBonus * 75));
        }
    }

    public void retract(class_1799 stack) {
        class_1297 eOwner = this.method_24921();
        if (this.field_6002.field_9236 || this.shouldStopFishing()) {
            return;
        }
        if (!(eOwner instanceof class_3222)) {
            this.method_31472();
            return;
        }
        class_3222 owner = (class_3222)eOwner;
        if (this.nibble > 0) {
            float luck = (float)this.luck + owner.method_7292() + (float)this.difficultyBonus * 0.5f + (float)Platform.INSTANCE.getPlayerData((class_1657)owner).map(d -> d.getSkillLevel(EnumSkills.FISHING).getLevel()).orElse(0).intValue() * 0.02f;
            class_47.class_48 builder = new class_47.class_48((class_3218)this.field_6002).method_312(class_181.field_24424, (Object)this.method_19538()).method_312(class_181.field_1229, (Object)stack).method_312(class_181.field_1226, (Object)this).method_311(this.field_5974).method_303(luck);
            class_2960 loot = this.inSand ? LootTableResources.SAND_FISHING : LootTableResources.FISHING;
            class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(loot);
            List list = lootTable.method_319(builder.method_309(class_173.field_1176));
            ((ExtendedFishingRodHookTrigger)class_174.field_1203).runecraftory$customTrigger(owner, stack, this, list);
            for (class_1799 itemStack2 : list) {
                class_1542 itemEntity = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), itemStack2);
                double d2 = owner.method_23317() - this.method_23317();
                double e = owner.method_23318() - this.method_23318();
                double f = owner.method_23321() - this.method_23321();
                itemEntity.method_18800(d2 * 0.1, e * 0.1 + Math.sqrt(Math.sqrt(d2 * d2 + e * e + f * f)) * 0.08, f * 0.1);
                this.field_6002.method_8649((class_1297)itemEntity);
                owner.field_6002.method_8649((class_1297)new class_1303(owner.field_6002, owner.method_23317(), owner.method_23318() + 0.5, owner.method_23321() + 0.5, this.field_5974.nextInt(6) + 1));
                if (!itemStack2.method_31573(class_3489.field_15527)) continue;
                owner.method_7339(class_3468.field_15391, 1);
            }
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_3222) {
                class_3222 player = (class_3222)class_12972;
                Platform.INSTANCE.getPlayerData((class_1657)player).ifPresent(data -> {
                    LevelCalc.useRP((class_1657)player, data, 10 * (this.nibbleBonus + 1), true, 0.0f, true, EnumSkills.FISHING);
                    LevelCalc.levelSkill(player, data, EnumSkills.FISHING, 25.0f);
                    LevelCalc.levelSkill(player, data, EnumSkills.WATER, 5.0f);
                });
            }
        }
        this.method_31472();
    }

    static enum LocationType {
        AIR,
        MATCH,
        INVALID;

    }
}

