/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class EntityDarkBall
extends BaseDamageCloud {
    private static final float[] SIN_POINTS = EntityDarkBall.calcSinPoints();
    private Type type = Type.BALL;
    private class_243 dir;
    private class_243 side;

    public EntityDarkBall(class_1299<? extends EntityDarkBall> type, class_1937 level) {
        super(type, level);
    }

    public EntityDarkBall(class_1937 level, class_1309 thrower, Type type) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)ModEntities.DARK_BALL.get()), level, thrower);
        this.method_5814(this.method_23317(), this.method_23318() + (double)thrower.method_17682() * 0.5, this.method_23321());
        this.type = type;
        this.setRadius(1.5f);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = class_3532.method_15362((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    public void shootAtPos(class_243 targetPos, float velocity, float inaccuracy) {
        class_243 dir = new class_243(targetPos.method_10216() - this.method_23317(), targetPos.method_10214() - this.method_23318(), targetPos.method_10215() - this.method_23321());
        this.shoot(dir.field_1352, dir.field_1351, dir.field_1350, velocity, inaccuracy);
    }

    public void shoot(class_1297 entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -class_3532.method_15374((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -class_3532.method_15374((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        class_243 throwerMotion = entityThrower.method_18798();
        this.method_18799(this.method_18798().method_1031(throwerMotion.field_1352, entityThrower.method_24828() ? 0.0 : throwerMotion.field_1351, throwerMotion.field_1350));
        this.method_18798().method_1031(throwerMotion.field_1352, 0.0, throwerMotion.field_1350);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vector3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_5974.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_5974.nextGaussian() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vector3d);
        double f = Math.sqrt(EntityProjectile.horizontalMag((class_243)vector3d));
        this.method_36456((float)(class_3532.method_15349((double)vector3d.field_1352, (double)vector3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vector3d.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        class_243 up = this.method_18863(-this.method_5695(1.0f), -this.method_5705(1.0f)).method_1029();
        this.dir = this.method_18798();
        this.side = new class_243(RayTraceUtils.rotatedAround((class_243)this.dir, (class_1160)new class_1160(up), (float)90.0f)).method_1029();
    }

    public int livingTickMax() {
        return this.type == Type.BALL ? 100 : 60;
    }

    public void method_5773() {
        super.method_5773();
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        this.method_5814(newX, newY, newZ);
        if (this.field_6002.field_9236) {
            int i;
            for (i = 0; i < 5; ++i) {
                this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.SHORT_LIGHT.get(), 0.25490198f, 0.007843138f, 0.4117647f, 0.2f, 5.5f), this.method_23317() + this.field_5974.nextGaussian() * 0.15, this.method_23318() + this.field_5974.nextGaussian() * 0.07, this.method_23321() + this.field_5974.nextGaussian() * 0.15, this.field_5974.nextGaussian() * 0.01, Math.abs(this.field_5974.nextGaussian() * 0.03), this.field_5974.nextGaussian() * 0.01);
            }
            for (i = 0; i < 3; ++i) {
                this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.SHORT_LIGHT.get(), 0.6666667f, 0.3647059f, 0.83137256f, 0.2f, 5.5f), this.method_23317() + this.field_5974.nextGaussian() * 0.15, this.method_23318() + this.field_5974.nextGaussian() * 0.07, this.method_23321() + this.field_5974.nextGaussian() * 0.15, this.field_5974.nextGaussian() * 0.01, Math.abs(this.field_5974.nextGaussian() * 0.03), this.field_5974.nextGaussian() * 0.01);
            }
        } else if (this.type == Type.SNAKE && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = SIN_POINTS[t];
            this.method_18800(this.dir.field_1352 + this.side.field_1352 * (double)sT, this.dir.field_1351 + this.side.field_1351 * (double)sT, this.dir.field_1350 + this.side.field_1350 * (double)sT);
            this.field_6007 = true;
        }
    }

    protected boolean damageEntity(class_1309 target) {
        return CombatUtils.damageWithFaintAndCrit(this.method_35057(), (class_1297)target, new CustomDamage.Builder((class_1297)this, this.method_35057()).magic().noKnockback().hurtResistant(10).element(EnumElement.DARK), CombatUtils.getAttributeValue(this.method_35057(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        try {
            this.type = Type.valueOf(compound.method_10558("Type"));
        }
        catch (IllegalArgumentException e) {
            this.type = Type.BALL;
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Type", this.type.toString());
    }

    public static enum Type {
        BALL,
        SNAKE;

    }
}

