/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;

public class EntityFurniture
extends BaseProjectile {
    private static final class_2940<Integer> FURNITURE_TYPE_SYNC = class_2945.method_12791(EntityFurniture.class, (class_2941)class_2943.field_13327);
    private Type furnitureType = Type.CHEST;
    private float randomRotationOffset;

    public EntityFurniture(class_1299<? extends EntityFurniture> type, class_1937 world) {
        super(type, world);
        this.randomRotationOffset = this.field_5974.nextFloat() * 360.0f;
        this.setFurnitureType(Type.WOOLYPLUSH);
    }

    public EntityFurniture(class_1937 world, class_1309 shooter, Type furnitureType) {
        super((class_1299<? extends BaseProjectile>)((class_1299)ModEntities.FURNITURE.get()), world, shooter);
        this.setFurnitureType(furnitureType);
    }

    public int livingTickMax() {
        return this.method_5740() ? 300 : 200;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FURNITURE_TYPE_SYNC, (Object)0);
    }

    protected float getGravityVelocity() {
        return this.method_5740() ? 0.0f : 0.1f;
    }

    protected float motionReduction(boolean inWater) {
        return this.method_5740() ? 1.0f : super.motionReduction(inWater);
    }

    public float getRandomRotationOffset() {
        return this.randomRotationOffset;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        this.method_18382();
        boolean att = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(4).element(EnumElement.DARK), CombatUtils.getAttributeValue(this.method_24921(), class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (att) {
            this.method_31472();
        }
        return att;
    }

    protected class_3966 getEntityHit(class_243 from, class_243 to) {
        if (!this.method_5805()) {
            return null;
        }
        return this.entityCollision(from, to, this::canHit);
    }

    private class_3966 entityCollision(class_243 from, class_243 to, Predicate<class_1297> pred) {
        double distVar = Double.MAX_VALUE;
        class_1297 ret = null;
        class_238 entityBB = this.method_5829();
        for (class_1297 entity1 : this.field_6002.method_8333((class_1297)this, this.method_5829().method_1014(0.5).method_18804(this.method_18798()), pred)) {
            double dist;
            class_238 axisalignedbb = entity1.method_5829().method_1014((double)0.33f);
            if (!entityBB.method_994(axisalignedbb) || !((dist = this.method_19538().method_1025(entity1.method_19538())) < distVar)) continue;
            ret = entity1;
            distVar = dist;
        }
        return ret == null ? null : new class_3966(ret);
    }

    protected void onBlockHit(class_3965 blockHitResult) {
        if (!this.method_5740() && blockHitResult.method_17780() == class_2350.field_11036) {
            this.method_31472();
        }
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key == FURNITURE_TYPE_SYNC) {
            this.method_18382();
            int id = (Integer)this.field_6011.method_12789(FURNITURE_TYPE_SYNC);
            if (id >= 0 && id < Type.values().length) {
                this.furnitureType = Type.values()[id];
            }
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18385((float)(this.furnitureType.range * 2.0f), (float)(this.furnitureType.range * 2.0f));
    }

    public Type getFurnitureType() {
        return this.furnitureType;
    }

    protected void setFurnitureType(Type furnitureType) {
        this.furnitureType = furnitureType;
        this.field_6011.method_12778(FURNITURE_TYPE_SYNC, (Object)this.furnitureType.ordinal());
        this.method_18382();
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        try {
            this.furnitureType = Type.valueOf(compound.method_10558("Type"));
        }
        catch (IllegalArgumentException e) {
            this.furnitureType = Type.CHEST;
        }
        this.field_6011.method_12778(FURNITURE_TYPE_SYNC, (Object)this.furnitureType.ordinal());
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Type", this.furnitureType.toString());
    }

    public static enum Type {
        CHEST(0.5f),
        BARREL(0.5f),
        ANVIL(0.5f),
        CHAIR(0.4f),
        WOOLYPLUSH(0.4f),
        CHIPSQUEEKPLUSH(0.4f);

        final float range;

        private Type(float range) {
            this.range = range;
        }
    }
}

