/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;

public class EntityMarionettaTrap
extends class_1297
implements class_6025,
IAnimated {
    private static final class_2940<class_2487> CAUGHT_ENTITIES = class_2945.method_12791(EntityMarionettaTrap.class, (class_2941)class_2943.field_13318);
    private static final AnimatedAction[] ANIMS = new AnimatedAction[0];
    private final List<class_1309> caughtEntities = new ArrayList<class_1309>();
    private boolean dirty = true;
    private final AnimationHandler<EntityMarionettaTrap> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private int tickLeft = 100;
    private class_1309 shooter;
    private UUID shooterUUID;
    private float damageMultiplier = 0.7f;

    public EntityMarionettaTrap(class_1299<? extends EntityMarionettaTrap> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
    }

    public EntityMarionettaTrap(class_1937 world, class_1309 shooter) {
        this((class_1299<? extends EntityMarionettaTrap>)((class_1299)ModEntities.TRAP_CHEST.get()), world);
        this.shooter = shooter;
        this.shooterUUID = shooter.method_5667();
        this.method_5814(shooter.method_23317(), shooter.method_23320(), shooter.method_23321());
    }

    public static double horizontalMag(class_243 vec) {
        return vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350;
    }

    public void addCaughtEntity(class_1309 entity) {
        this.caughtEntities.add(entity);
        this.dirty = true;
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    protected void method_5693() {
        this.field_6011.method_12784(CAUGHT_ENTITIES, (Object)new class_2487());
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key == CAUGHT_ENTITIES) {
            class_2487 tag = (class_2487)this.field_6011.method_12789(CAUGHT_ENTITIES);
            this.readCaughtEntities(tag);
        }
    }

    public void method_5670() {
        super.method_5670();
        if (!this.field_5952) {
            class_243 motion = this.method_18798();
            double f = Math.sqrt(EntityMarionettaTrap.horizontalMag(motion));
            this.method_36456(this.updateRotation(this.field_5982, (float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.29577951308232)));
            this.method_36457(this.updateRotation(this.field_6004, (float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875)));
            boolean water = this.method_5799();
            float friction = water ? 0.8f : 0.85f;
            this.method_18799(motion.method_1021((double)friction).method_1023(0.0, (double)0.05f, 0.0));
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        --this.tickLeft;
        this.caughtEntities.forEach(e -> {
            if (e.method_5805()) {
                e.method_5814(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.05, this.method_23321());
                e.field_6037 = true;
                Platform.INSTANCE.getEntityData((class_1309)e).ifPresent(data -> {
                    if (!data.isOrthoView()) {
                        data.setOrthoView((class_1309)e, true);
                    }
                });
            }
        });
        if (!this.field_6002.field_9236) {
            if (this.dirty) {
                this.field_6011.method_12778(CAUGHT_ENTITIES, (Object)this.writeCaughtEntities());
                this.dirty = false;
            }
            if (this.tickLeft <= 21 && this.tickLeft >= 9 && this.getOwner() != null && this.tickLeft % 3 == 0) {
                this.caughtEntities.forEach(e -> CombatUtils.mobAttack(this.getOwner(), (class_1297)e, new CustomDamage.Builder(this, (class_1297)this.getOwner()).hurtResistant(this.tickLeft == 7 ? 10 : 0), CombatUtils.getAttributeValue((class_1297)this.getOwner(), class_5134.field_23721) * (double)this.damageMultiplier));
            }
            if (this.tickLeft <= 0) {
                this.caughtEntities.forEach(e -> Platform.INSTANCE.getEntityData((class_1309)e).ifPresent(data -> data.setOrthoView((class_1309)e, false)));
                this.method_31472();
            }
        }
    }

    public void method_5749(class_2487 compound) {
        this.damageMultiplier = compound.method_10583("DamageMultiplier");
    }

    public void method_5652(class_2487 compound) {
        compound.method_10548("DamageMultiplier", this.damageMultiplier);
    }

    public boolean method_30948() {
        return true;
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public int getTickLeft() {
        return this.tickLeft;
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return class_3532.method_16439((float)0.2f, (float)prev, (float)current);
    }

    public UUID method_6139() {
        return this.shooterUUID;
    }

    @Nullable
    public class_1309 getOwner() {
        UUID uuid;
        if ((this.shooter == null || this.shooter.method_31481()) && (uuid = this.method_6139()) != null) {
            this.shooter = (class_1309)EntityUtil.findFromUUID(class_1309.class, (class_1937)this.field_6002, (UUID)uuid);
        }
        return this.shooter;
    }

    private class_2487 writeCaughtEntities() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        this.caughtEntities.forEach(e -> list.add((Object)class_2497.method_23247((int)e.method_5628())));
        tag.method_10566("Caught", (class_2520)list);
        return tag;
    }

    private void readCaughtEntities(class_2487 tag) {
        class_2499 list = tag.method_10554("Caught", 3);
        this.caughtEntities.clear();
        list.forEach(t -> {
            class_1297 e = this.field_6002.method_8469(((class_2497)t).method_10701());
            if (e instanceof class_1309) {
                class_1309 entity = (class_1309)e;
                this.caughtEntities.add(entity);
            }
        });
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

